/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core;

import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.RenderProps;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.core.CoreProps;
import io.noties.markwon.core.SimpleBlockNodeVisitor;
import io.noties.markwon.core.factory.BlockQuoteSpanFactory;
import io.noties.markwon.core.factory.CodeBlockSpanFactory;
import io.noties.markwon.core.factory.CodeSpanFactory;
import io.noties.markwon.core.factory.EmphasisSpanFactory;
import io.noties.markwon.core.factory.HeadingSpanFactory;
import io.noties.markwon.core.factory.LinkSpanFactory;
import io.noties.markwon.core.factory.ListItemSpanFactory;
import io.noties.markwon.core.factory.StrongEmphasisSpanFactory;
import io.noties.markwon.core.factory.ThematicBreakSpanFactory;
import io.noties.markwon.core.spans.OrderedListItemSpan;
import io.noties.markwon.core.spans.TextViewSpan;
import io.noties.markwon.image.ImageProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;

public class CorePlugin
extends AbstractMarkwonPlugin {
    private final List<OnTextAddedListener> onTextAddedListeners = new ArrayList<OnTextAddedListener>(0);
    private boolean hasExplicitMovementMethod;

    @NonNull
    public static CorePlugin create() {
        return new CorePlugin();
    }

    @NonNull
    public static Set<Class<? extends Block>> enabledBlockTypes() {
        return new HashSet<Class<? extends Block>>(Arrays.asList(BlockQuote.class, Heading.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, ListBlock.class, IndentedCodeBlock.class));
    }

    protected CorePlugin() {
    }

    @NonNull
    public CorePlugin hasExplicitMovementMethod(boolean hasExplicitMovementMethod) {
        this.hasExplicitMovementMethod = hasExplicitMovementMethod;
        return this;
    }

    @NonNull
    public CorePlugin addOnTextAddedListener(@NonNull OnTextAddedListener onTextAddedListener) {
        this.onTextAddedListeners.add(onTextAddedListener);
        return this;
    }

    @Override
    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        this.text(builder);
        CorePlugin.strongEmphasis(builder);
        CorePlugin.emphasis(builder);
        CorePlugin.blockQuote(builder);
        CorePlugin.code(builder);
        CorePlugin.fencedCodeBlock(builder);
        CorePlugin.indentedCodeBlock(builder);
        CorePlugin.image(builder);
        CorePlugin.bulletList(builder);
        CorePlugin.orderedList(builder);
        CorePlugin.listItem(builder);
        CorePlugin.thematicBreak(builder);
        CorePlugin.heading(builder);
        CorePlugin.softLineBreak(builder);
        CorePlugin.hardLineBreak(builder);
        CorePlugin.paragraph(builder);
        CorePlugin.link(builder);
    }

    @Override
    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        CodeBlockSpanFactory codeBlockSpanFactory = new CodeBlockSpanFactory();
        builder.setFactory(StrongEmphasis.class, new StrongEmphasisSpanFactory()).setFactory(Emphasis.class, new EmphasisSpanFactory()).setFactory(BlockQuote.class, new BlockQuoteSpanFactory()).setFactory(Code.class, new CodeSpanFactory()).setFactory(FencedCodeBlock.class, codeBlockSpanFactory).setFactory(IndentedCodeBlock.class, codeBlockSpanFactory).setFactory(ListItem.class, new ListItemSpanFactory()).setFactory(Heading.class, new HeadingSpanFactory()).setFactory(Link.class, new LinkSpanFactory()).setFactory(ThematicBreak.class, new ThematicBreakSpanFactory());
    }

    @Override
    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        OrderedListItemSpan.measure(textView, (CharSequence)markdown);
        if (markdown instanceof Spannable) {
            Spannable spannable = (Spannable)markdown;
            TextViewSpan.applyTo(spannable, textView);
        }
    }

    @Override
    public void afterSetText(@NonNull TextView textView) {
        if (!this.hasExplicitMovementMethod && textView.getMovementMethod() == null) {
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private void text(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Text.class, new MarkwonVisitor.NodeVisitor<Text>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Text text) {
                String literal = text.getLiteral();
                visitor.builder().append(literal);
                if (!CorePlugin.this.onTextAddedListeners.isEmpty()) {
                    int length = visitor.length() - literal.length();
                    for (OnTextAddedListener onTextAddedListener : CorePlugin.this.onTextAddedListeners) {
                        onTextAddedListener.onTextAdded(visitor, literal, length);
                    }
                }
            }
        });
    }

    private static void strongEmphasis(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(StrongEmphasis.class, new MarkwonVisitor.NodeVisitor<StrongEmphasis>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull StrongEmphasis strongEmphasis) {
                int length = visitor.length();
                visitor.visitChildren((Node)strongEmphasis);
                visitor.setSpansForNodeOptional(strongEmphasis, length);
            }
        });
    }

    private static void emphasis(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Emphasis.class, new MarkwonVisitor.NodeVisitor<Emphasis>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Emphasis emphasis) {
                int length = visitor.length();
                visitor.visitChildren((Node)emphasis);
                visitor.setSpansForNodeOptional(emphasis, length);
            }
        });
    }

    private static void blockQuote(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(BlockQuote.class, new MarkwonVisitor.NodeVisitor<BlockQuote>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull BlockQuote blockQuote) {
                visitor.blockStart((Node)blockQuote);
                int length = visitor.length();
                visitor.visitChildren((Node)blockQuote);
                visitor.setSpansForNodeOptional(blockQuote, length);
                visitor.blockEnd((Node)blockQuote);
            }
        });
    }

    private static void code(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Code.class, new MarkwonVisitor.NodeVisitor<Code>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Code code) {
                int length = visitor.length();
                visitor.builder().append('\u00a0').append(code.getLiteral()).append('\u00a0');
                visitor.setSpansForNodeOptional(code, length);
            }
        });
    }

    private static void fencedCodeBlock(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(FencedCodeBlock.class, new MarkwonVisitor.NodeVisitor<FencedCodeBlock>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull FencedCodeBlock fencedCodeBlock) {
                CorePlugin.visitCodeBlock(visitor, fencedCodeBlock.getInfo(), fencedCodeBlock.getLiteral(), (Node)fencedCodeBlock);
            }
        });
    }

    private static void indentedCodeBlock(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(IndentedCodeBlock.class, new MarkwonVisitor.NodeVisitor<IndentedCodeBlock>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull IndentedCodeBlock indentedCodeBlock) {
                CorePlugin.visitCodeBlock(visitor, null, indentedCodeBlock.getLiteral(), (Node)indentedCodeBlock);
            }
        });
    }

    private static void image(MarkwonVisitor.Builder builder) {
        builder.on(Image.class, new MarkwonVisitor.NodeVisitor<Image>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Image image) {
                SpanFactory spanFactory = visitor.configuration().spansFactory().get(Image.class);
                if (spanFactory == null) {
                    visitor.visitChildren((Node)image);
                    return;
                }
                int length = visitor.length();
                visitor.visitChildren((Node)image);
                if (length == visitor.length()) {
                    visitor.builder().append('\ufffc');
                }
                MarkwonConfiguration configuration = visitor.configuration();
                Node parent = image.getParent();
                boolean link = parent instanceof Link;
                String destination = configuration.imageDestinationProcessor().process(image.getDestination());
                RenderProps props = visitor.renderProps();
                ImageProps.DESTINATION.set(props, destination);
                ImageProps.REPLACEMENT_TEXT_IS_LINK.set(props, link);
                ImageProps.IMAGE_SIZE.set(props, null);
                visitor.setSpans(length, spanFactory.getSpans(configuration, props));
            }
        });
    }

    @VisibleForTesting
    static void visitCodeBlock(@NonNull MarkwonVisitor visitor, @Nullable String info, @NonNull String code, @NonNull Node node) {
        visitor.blockStart(node);
        int length = visitor.length();
        visitor.builder().append('\u00a0').append('\n').append(visitor.configuration().syntaxHighlight().highlight(info, code));
        visitor.ensureNewLine();
        visitor.builder().append('\u00a0');
        CoreProps.CODE_BLOCK_INFO.set(visitor.renderProps(), info);
        visitor.setSpansForNodeOptional(node, length);
        visitor.blockEnd(node);
    }

    private static void bulletList(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(BulletList.class, new SimpleBlockNodeVisitor());
    }

    private static void orderedList(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(OrderedList.class, new SimpleBlockNodeVisitor());
    }

    private static void listItem(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(ListItem.class, new MarkwonVisitor.NodeVisitor<ListItem>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull ListItem listItem) {
                int length = visitor.length();
                visitor.visitChildren((Node)listItem);
                Block parent = listItem.getParent();
                if (parent instanceof OrderedList) {
                    int start = ((OrderedList)parent).getStartNumber();
                    CoreProps.LIST_ITEM_TYPE.set(visitor.renderProps(), CoreProps.ListItemType.ORDERED);
                    CoreProps.ORDERED_LIST_ITEM_NUMBER.set(visitor.renderProps(), start);
                    OrderedList orderedList = (OrderedList)parent;
                    orderedList.setStartNumber(orderedList.getStartNumber() + 1);
                } else {
                    CoreProps.LIST_ITEM_TYPE.set(visitor.renderProps(), CoreProps.ListItemType.BULLET);
                    CoreProps.BULLET_LIST_ITEM_LEVEL.set(visitor.renderProps(), CorePlugin.listLevel((Node)listItem));
                }
                visitor.setSpansForNodeOptional(listItem, length);
                if (visitor.hasNext((Node)listItem)) {
                    visitor.ensureNewLine();
                }
            }
        });
    }

    private static int listLevel(@NonNull Node node) {
        int level = 0;
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ListItem)) continue;
            ++level;
        }
        return level;
    }

    private static void thematicBreak(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(ThematicBreak.class, new MarkwonVisitor.NodeVisitor<ThematicBreak>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull ThematicBreak thematicBreak) {
                visitor.blockStart((Node)thematicBreak);
                int length = visitor.length();
                visitor.builder().append('\u00a0');
                visitor.setSpansForNodeOptional(thematicBreak, length);
                visitor.blockEnd((Node)thematicBreak);
            }
        });
    }

    private static void heading(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Heading.class, new MarkwonVisitor.NodeVisitor<Heading>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Heading heading) {
                visitor.blockStart((Node)heading);
                int length = visitor.length();
                visitor.visitChildren((Node)heading);
                CoreProps.HEADING_LEVEL.set(visitor.renderProps(), heading.getLevel());
                visitor.setSpansForNodeOptional(heading, length);
                visitor.blockEnd((Node)heading);
            }
        });
    }

    private static void softLineBreak(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(SoftLineBreak.class, new MarkwonVisitor.NodeVisitor<SoftLineBreak>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull SoftLineBreak softLineBreak) {
                visitor.builder().append(' ');
            }
        });
    }

    private static void hardLineBreak(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(HardLineBreak.class, new MarkwonVisitor.NodeVisitor<HardLineBreak>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull HardLineBreak hardLineBreak) {
                visitor.ensureNewLine();
            }
        });
    }

    private static void paragraph(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Paragraph.class, new MarkwonVisitor.NodeVisitor<Paragraph>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Paragraph paragraph) {
                boolean inTightList = CorePlugin.isInTightList(paragraph);
                if (!inTightList) {
                    visitor.blockStart((Node)paragraph);
                }
                int length = visitor.length();
                visitor.visitChildren((Node)paragraph);
                CoreProps.PARAGRAPH_IS_IN_TIGHT_LIST.set(visitor.renderProps(), inTightList);
                visitor.setSpansForNodeOptional(paragraph, length);
                if (!inTightList) {
                    visitor.blockEnd((Node)paragraph);
                }
            }
        });
    }

    private static boolean isInTightList(@NonNull Paragraph paragraph) {
        Node gramps;
        Block parent = paragraph.getParent();
        if (parent != null && (gramps = parent.getParent()) instanceof ListBlock) {
            ListBlock list = (ListBlock)gramps;
            return list.isTight();
        }
        return false;
    }

    private static void link(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Link.class, new MarkwonVisitor.NodeVisitor<Link>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Link link) {
                int length = visitor.length();
                visitor.visitChildren((Node)link);
                String destination = link.getDestination();
                CoreProps.LINK_DESTINATION.set(visitor.renderProps(), destination);
                visitor.setSpansForNodeOptional(link, length);
            }
        });
    }

    public static interface OnTextAddedListener {
        public void onTextAdded(@NonNull MarkwonVisitor var1, @NonNull String var2, int var3);
    }
}

