/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.core.spans.ObjectsPool;
import io.noties.markwon.utils.LeadingMarginUtils;

public class BulletListItemSpan
implements LeadingMarginSpan {
    private static final boolean IS_NOUGAT;
    private MarkwonTheme theme;
    private final Paint paint = ObjectsPool.paint();
    private final RectF circle = ObjectsPool.rectF();
    private final Rect rectangle = ObjectsPool.rect();
    private final int level;

    public BulletListItemSpan(@NonNull MarkwonTheme theme, @IntRange(from=0L) int level) {
        this.theme = theme;
        this.level = level;
    }

    public int getLeadingMargin(boolean first) {
        return this.theme.getBlockMargin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first || !LeadingMarginUtils.selfStart(start, text, this)) {
            return;
        }
        this.paint.set(p);
        this.theme.applyListItemStyle(this.paint);
        int save = c.save();
        try {
            int r;
            int l;
            int width = this.theme.getBlockMargin();
            int textLineHeight = (int)(this.paint.descent() - this.paint.ascent() + 0.5f);
            int side = this.theme.getBulletWidth(textLineHeight);
            int marginLeft = (width - side) / 2;
            if (IS_NOUGAT) {
                int diff = dir < 0 ? x - (layout.getWidth() - width * this.level) : width * this.level - x;
                int left = x + dir * marginLeft;
                int right = left + dir * side;
                l = Math.min(left, right) + dir * diff;
                r = Math.max(left, right) + dir * diff;
            } else {
                l = dir > 0 ? x + marginLeft : x - width + marginLeft;
                r = l + side;
            }
            int t = baseline + (int)((this.paint.descent() + this.paint.ascent()) / 2.0f + 0.5f) - side / 2;
            int b = t + side;
            if (this.level == 0 || this.level == 1) {
                this.circle.set((float)l, (float)t, (float)r, (float)b);
                Paint.Style style = this.level == 0 ? Paint.Style.FILL : Paint.Style.STROKE;
                this.paint.setStyle(style);
                c.drawOval(this.circle, this.paint);
            } else {
                this.rectangle.set(l, t, r, b);
                this.paint.setStyle(Paint.Style.FILL);
                c.drawRect(this.rectangle, this.paint);
            }
        }
        finally {
            c.restoreToCount(save);
        }
    }

    static {
        int sdk = Build.VERSION.SDK_INT;
        IS_NOUGAT = 24 == sdk || 25 == sdk;
    }
}

