/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.core.spans.ObjectsPool;
import io.noties.markwon.utils.LeadingMarginUtils;

public class HeadingSpan
extends MetricAffectingSpan
implements LeadingMarginSpan {
    private final MarkwonTheme theme;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();
    private final int level;

    public HeadingSpan(@NonNull MarkwonTheme theme, @IntRange(from=1L, to=6L) int level) {
        this.theme = theme;
        this.level = level;
    }

    public void updateMeasureState(TextPaint p) {
        this.apply(p);
    }

    public void updateDrawState(TextPaint tp) {
        this.apply(tp);
    }

    private void apply(TextPaint paint) {
        this.theme.applyHeadingTextStyle((Paint)paint, this.level);
    }

    public int getLeadingMargin(boolean first) {
        return 0;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if ((this.level == 1 || this.level == 2) && LeadingMarginUtils.selfEnd(end, text, (Object)this)) {
            this.paint.set(p);
            this.theme.applyHeadingBreakStyle(this.paint);
            float height = this.paint.getStrokeWidth();
            if (height > 0.0f) {
                int right;
                int left;
                int b = (int)((float)bottom - height + 0.5f);
                if (dir > 0) {
                    left = x;
                    right = c.getWidth();
                } else {
                    left = x - c.getWidth();
                    right = x;
                }
                this.rect.set(left, b, right, bottom);
                c.drawRect(this.rect, this.paint);
            }
        }
    }

    public int getLevel() {
        return this.level;
    }
}

