/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageSize;
import io.noties.markwon.image.ImageSizeResolver;

public class AsyncDrawable
extends Drawable {
    private final String destination;
    private final AsyncDrawableLoader loader;
    private final ImageSize imageSize;
    private final ImageSizeResolver imageSizeResolver;
    private final Drawable placeholder;
    private Drawable result;
    private Drawable.Callback callback;
    private int canvasWidth;
    private float textSize;
    private boolean waitingForDimensions;
    private boolean wasPlayingBefore = false;

    public AsyncDrawable(@NonNull String destination, @NonNull AsyncDrawableLoader loader, @NonNull ImageSizeResolver imageSizeResolver, @Nullable ImageSize imageSize) {
        this.destination = destination;
        this.loader = loader;
        this.imageSizeResolver = imageSizeResolver;
        this.imageSize = imageSize;
        Drawable placeholder = this.placeholder = loader.placeholder(this);
        if (placeholder != null) {
            this.setPlaceholderResult(placeholder);
        }
    }

    @NonNull
    public String getDestination() {
        return this.destination;
    }

    @Nullable
    public ImageSize getImageSize() {
        return this.imageSize;
    }

    @NonNull
    public ImageSizeResolver getImageSizeResolver() {
        return this.imageSizeResolver;
    }

    public boolean hasKnownDimensions() {
        return this.canvasWidth > 0;
    }

    public int getLastKnownCanvasWidth() {
        return this.canvasWidth;
    }

    public float getLastKnowTextSize() {
        return this.textSize;
    }

    public Drawable getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public boolean isAttached() {
        return this.getCallback() != null;
    }

    public void setCallback2(@Nullable Drawable.Callback cb) {
        this.callback = cb == null ? null : new WrappedCallback(cb);
        super.setCallback(cb);
        if (this.callback != null) {
            boolean shouldLoad;
            if (this.result != null && this.result.getCallback() == null) {
                this.result.setCallback(this.callback);
            }
            boolean bl = shouldLoad = this.result == null || this.result == this.placeholder;
            if (this.result != null) {
                this.result.setCallback(this.callback);
                if (this.result instanceof Animatable && this.wasPlayingBefore) {
                    ((Animatable)this.result).start();
                }
            }
            if (shouldLoad) {
                this.loader.load(this);
            }
        } else {
            if (this.result != null) {
                Animatable animatable;
                boolean isPlaying;
                this.result.setCallback(null);
                if (this.result instanceof Animatable && (isPlaying = (this.wasPlayingBefore = (animatable = (Animatable)this.result).isRunning()))) {
                    animatable.stop();
                }
            }
            this.loader.cancel(this);
        }
    }

    protected void setPlaceholderResult(@NonNull Drawable placeholder) {
        Rect rect;
        if (this.result != null) {
            this.result.setCallback(null);
        }
        if ((rect = placeholder.getBounds()).isEmpty()) {
            Rect intrinsic = DrawableUtils.intrinsicBounds(placeholder);
            if (intrinsic.isEmpty()) {
                placeholder.setBounds(0, 0, 1, 1);
            } else {
                placeholder.setBounds(intrinsic);
            }
            this.setBounds(placeholder.getBounds());
            this.setResult(placeholder);
        } else {
            this.result = placeholder;
            this.result.setCallback(this.callback);
            this.setBounds(rect);
            this.waitingForDimensions = false;
        }
    }

    public void setResult(@NonNull Drawable result) {
        this.wasPlayingBefore = false;
        if (this.result != null) {
            this.result.setCallback(null);
        }
        this.result = result;
        this.initBounds();
    }

    public void clearResult() {
        Drawable result = this.result;
        if (result != null) {
            result.setCallback(null);
            this.result = null;
            this.setBounds(0, 0, 0, 0);
        }
    }

    private void initBounds() {
        if (this.canvasWidth == 0) {
            this.waitingForDimensions = true;
            this.setBounds(AsyncDrawable.noDimensionsBounds(this.result));
            return;
        }
        this.waitingForDimensions = false;
        Rect bounds = this.resolveBounds();
        this.result.setBounds(bounds);
        this.result.setCallback(this.callback);
        this.setBounds(bounds);
        this.invalidateSelf();
    }

    @NonNull
    private static Rect noDimensionsBounds(@Nullable Drawable result) {
        if (result != null) {
            Rect bounds = result.getBounds();
            if (!bounds.isEmpty()) {
                return bounds;
            }
            Rect intrinsicBounds = DrawableUtils.intrinsicBounds(result);
            if (!intrinsicBounds.isEmpty()) {
                return intrinsicBounds;
            }
        }
        return new Rect(0, 0, 1, 1);
    }

    public void initWithKnownDimensions(int width, float textSize) {
        this.canvasWidth = width;
        this.textSize = textSize;
        if (this.waitingForDimensions) {
            this.initBounds();
        }
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.hasResult()) {
            this.result.draw(canvas);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        int opacity = this.hasResult() ? this.result.getOpacity() : -2;
        return opacity;
    }

    public int getIntrinsicWidth() {
        int out = this.hasResult() ? this.result.getIntrinsicWidth() : 1;
        return out;
    }

    public int getIntrinsicHeight() {
        int out = this.hasResult() ? this.result.getIntrinsicHeight() : 1;
        return out;
    }

    @NonNull
    private Rect resolveBounds() {
        return this.imageSizeResolver.resolveImageSize(this);
    }

    @NonNull
    public String toString() {
        return "AsyncDrawable{destination='" + this.destination + '\'' + ", imageSize=" + this.imageSize + ", result=" + this.result + ", canvasWidth=" + this.canvasWidth + ", textSize=" + this.textSize + ", waitingForDimensions=" + this.waitingForDimensions + '}';
    }

    private class WrappedCallback
    implements Drawable.Callback {
        private final Drawable.Callback callback;

        WrappedCallback(Drawable.Callback callback) {
            this.callback = callback;
        }

        public void invalidateDrawable(@NonNull Drawable who) {
            this.callback.invalidateDrawable((Drawable)AsyncDrawable.this);
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            this.callback.scheduleDrawable((Drawable)AsyncDrawable.this, what, when);
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            this.callback.unscheduleDrawable((Drawable)AsyncDrawable.this, what);
        }
    }
}

