/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.utils;

import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;

public abstract class DumpNodes {
    @NonNull
    @CheckResult
    public static String dump(@NonNull Node node) {
        return DumpNodes.dump(node, null);
    }

    @NonNull
    @CheckResult
    public static String dump(@NonNull Node node, @Nullable NodeProcessor nodeProcessor) {
        final NodeProcessor processor = nodeProcessor != null ? nodeProcessor : new NodeProcessorToString();
        final Indent indent = new Indent();
        final StringBuilder builder = new StringBuilder();
        Visitor visitor = (Visitor)Proxy.newProxyInstance(Visitor.class.getClassLoader(), new Class[]{Visitor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Node argument = (Node)args[0];
                indent.appendTo(builder);
                builder.append(processor.process(argument));
                if (argument.getFirstChild() != null) {
                    builder.append(" [\n");
                    indent.increment();
                    DumpNodes.visitChildren((Visitor)proxy, argument);
                    indent.decrement();
                    indent.appendTo(builder);
                    builder.append("]\n");
                } else {
                    builder.append("\n");
                }
                return null;
            }
        });
        node.accept(visitor);
        return builder.toString();
    }

    private DumpNodes() {
    }

    private static void visitChildren(@NonNull Visitor visitor, @NonNull Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            node.accept(visitor);
            node = next;
        }
    }

    private static class NodeProcessorToString
    implements NodeProcessor {
        private NodeProcessorToString() {
        }

        @Override
        @NonNull
        public String process(@NonNull Node node) {
            return node.toString();
        }
    }

    private static class Indent {
        private int count;

        private Indent() {
        }

        void increment() {
            ++this.count;
        }

        void decrement() {
            --this.count;
        }

        void appendTo(@NonNull StringBuilder builder) {
            for (int i = 0; i < this.count; ++i) {
                builder.append(' ').append(' ');
            }
        }
    }

    public static interface NodeProcessor {
        @NonNull
        public String process(@NonNull Node var1);
    }
}

