/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.Paint;
import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.ext.latex.JLatexAsyncDrawableSpan;
import io.noties.markwon.ext.latex.JLatextAsyncDrawable;
import io.noties.markwon.image.AsyncDrawable;

class JLatexInlineAsyncDrawableSpan
extends JLatexAsyncDrawableSpan {
    private final AsyncDrawable drawable;

    JLatexInlineAsyncDrawableSpan(@NonNull MarkwonTheme theme, @NonNull JLatextAsyncDrawable drawable, @ColorInt int color) {
        super(theme, drawable, color);
        this.drawable = drawable;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
        int size;
        if (this.drawable.hasResult()) {
            Rect rect = this.drawable.getBounds();
            if (fm != null) {
                int half = rect.bottom / 2;
                fm.ascent = -half;
                fm.descent = half;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
            size = rect.right;
        } else {
            size = (int)(paint.measureText(text, start, end) + 0.5f);
        }
        return size;
    }
}

