/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.latex;

import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import ru.noties.jlatexmath.JLatexMathDrawable;

public abstract class JLatexMathTheme {
    @NonNull
    public static JLatexMathTheme create(@Px float textSize) {
        return JLatexMathTheme.builder(textSize).build();
    }

    @NonNull
    public static JLatexMathTheme create(@Px float inlineTextSize, @Px float blockTextSize) {
        return JLatexMathTheme.builder(inlineTextSize, blockTextSize).build();
    }

    @NonNull
    public static Builder builder(@Px float textSize) {
        return new Builder(textSize, 0.0f, 0.0f);
    }

    @NonNull
    public static Builder builder(@Px float inlineTextSize, @Px float blockTextSize) {
        return new Builder(0.0f, inlineTextSize, blockTextSize);
    }

    @Px
    public abstract float inlineTextSize();

    @Px
    public abstract float blockTextSize();

    @Nullable
    public abstract BackgroundProvider inlineBackgroundProvider();

    @Nullable
    public abstract BackgroundProvider blockBackgroundProvider();

    public abstract boolean blockFitCanvas();

    @JLatexMathDrawable.Align
    public abstract int blockHorizontalAlignment();

    @Nullable
    public abstract Padding inlinePadding();

    @Nullable
    public abstract Padding blockPadding();

    @ColorInt
    public abstract int inlineTextColor();

    @ColorInt
    public abstract int blockTextColor();

    static class Impl
    extends JLatexMathTheme {
        private final float textSize;
        private final float inlineTextSize;
        private final float blockTextSize;
        private final BackgroundProvider backgroundProvider;
        private final BackgroundProvider inlineBackgroundProvider;
        private final BackgroundProvider blockBackgroundProvider;
        private final boolean blockFitCanvas;
        private int blockHorizontalAlignment;
        private final Padding padding;
        private final Padding inlinePadding;
        private final Padding blockPadding;
        private final int textColor;
        private final int inlineTextColor;
        private final int blockTextColor;

        Impl(@NonNull Builder builder) {
            this.textSize = builder.textSize;
            this.inlineTextSize = builder.inlineTextSize;
            this.blockTextSize = builder.blockTextSize;
            this.backgroundProvider = builder.backgroundProvider;
            this.inlineBackgroundProvider = builder.inlineBackgroundProvider;
            this.blockBackgroundProvider = builder.blockBackgroundProvider;
            this.blockFitCanvas = builder.blockFitCanvas;
            this.blockHorizontalAlignment = builder.blockHorizontalAlignment;
            this.padding = builder.padding;
            this.inlinePadding = builder.inlinePadding;
            this.blockPadding = builder.blockPadding;
            this.textColor = builder.textColor;
            this.inlineTextColor = builder.inlineTextColor;
            this.blockTextColor = builder.blockTextColor;
        }

        @Override
        public float inlineTextSize() {
            if (this.inlineTextSize > 0.0f) {
                return this.inlineTextSize;
            }
            return this.textSize;
        }

        @Override
        public float blockTextSize() {
            if (this.blockTextSize > 0.0f) {
                return this.blockTextSize;
            }
            return this.textSize;
        }

        @Override
        @Nullable
        public BackgroundProvider inlineBackgroundProvider() {
            if (this.inlineBackgroundProvider != null) {
                return this.inlineBackgroundProvider;
            }
            return this.backgroundProvider;
        }

        @Override
        @Nullable
        public BackgroundProvider blockBackgroundProvider() {
            if (this.blockBackgroundProvider != null) {
                return this.blockBackgroundProvider;
            }
            return this.backgroundProvider;
        }

        @Override
        public boolean blockFitCanvas() {
            return this.blockFitCanvas;
        }

        @Override
        public int blockHorizontalAlignment() {
            return this.blockHorizontalAlignment;
        }

        @Override
        @Nullable
        public Padding inlinePadding() {
            if (this.inlinePadding != null) {
                return this.inlinePadding;
            }
            return this.padding;
        }

        @Override
        @Nullable
        public Padding blockPadding() {
            if (this.blockPadding != null) {
                return this.blockPadding;
            }
            return this.padding;
        }

        @Override
        public int inlineTextColor() {
            if (this.inlineTextColor != 0) {
                return this.inlineTextColor;
            }
            return this.textColor;
        }

        @Override
        public int blockTextColor() {
            if (this.blockTextColor != 0) {
                return this.blockTextColor;
            }
            return this.textColor;
        }
    }

    public static class Builder {
        private final float textSize;
        private final float inlineTextSize;
        private final float blockTextSize;
        private BackgroundProvider backgroundProvider;
        private BackgroundProvider inlineBackgroundProvider;
        private BackgroundProvider blockBackgroundProvider;
        private boolean blockFitCanvas = true;
        private int blockHorizontalAlignment = 1;
        private Padding padding;
        private Padding inlinePadding;
        private Padding blockPadding;
        private int textColor;
        private int inlineTextColor;
        private int blockTextColor;

        Builder(float textSize, float inlineTextSize, float blockTextSize) {
            this.textSize = textSize;
            this.inlineTextSize = inlineTextSize;
            this.blockTextSize = blockTextSize;
        }

        @NonNull
        public Builder backgroundProvider(@Nullable BackgroundProvider backgroundProvider) {
            this.backgroundProvider = backgroundProvider;
            this.inlineBackgroundProvider = backgroundProvider;
            this.blockBackgroundProvider = backgroundProvider;
            return this;
        }

        @NonNull
        public Builder inlineBackgroundProvider(@Nullable BackgroundProvider inlineBackgroundProvider) {
            this.inlineBackgroundProvider = inlineBackgroundProvider;
            return this;
        }

        @NonNull
        public Builder blockBackgroundProvider(@Nullable BackgroundProvider blockBackgroundProvider) {
            this.blockBackgroundProvider = blockBackgroundProvider;
            return this;
        }

        @NonNull
        public Builder blockFitCanvas(boolean blockFitCanvas) {
            this.blockFitCanvas = blockFitCanvas;
            return this;
        }

        @NonNull
        public Builder blockHorizontalAlignment(@JLatexMathDrawable.Align int blockHorizontalAlignment) {
            this.blockHorizontalAlignment = blockHorizontalAlignment;
            return this;
        }

        @NonNull
        public Builder padding(@Nullable Padding padding) {
            this.padding = padding;
            this.inlinePadding = padding;
            this.blockPadding = padding;
            return this;
        }

        @NonNull
        public Builder inlinePadding(@Nullable Padding inlinePadding) {
            this.inlinePadding = inlinePadding;
            return this;
        }

        @NonNull
        public Builder blockPadding(@Nullable Padding blockPadding) {
            this.blockPadding = blockPadding;
            return this;
        }

        @NonNull
        public Builder textColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        @NonNull
        public Builder inlineTextColor(@ColorInt int inlineTextColor) {
            this.inlineTextColor = inlineTextColor;
            return this;
        }

        @NonNull
        public Builder blockTextColor(@ColorInt int blockTextColor) {
            this.blockTextColor = blockTextColor;
            return this;
        }

        @NonNull
        public JLatexMathTheme build() {
            return new Impl(this);
        }
    }

    public static class Padding {
        public final int left;
        public final int top;
        public final int right;
        public final int bottom;

        public Padding(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        @NonNull
        public String toString() {
            return "Padding{left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + '}';
        }

        @NonNull
        public static Padding all(int value) {
            return new Padding(value, value, value, value);
        }

        @NonNull
        public static Padding symmetric(int vertical, int horizontal) {
            return new Padding(horizontal, vertical, horizontal, vertical);
        }

        @NonNull
        public static Padding of(int left, int top, int right, int bottom) {
            return new Padding(left, top, right, bottom);
        }
    }

    public static interface BackgroundProvider {
        @NonNull
        public Drawable provide();
    }
}

