/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tasklist;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.MarkwonVisitor;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.ext.tasklist.TaskListDrawable;
import io.noties.markwon.ext.tasklist.TaskListItem;
import io.noties.markwon.ext.tasklist.TaskListPostProcessor;
import io.noties.markwon.ext.tasklist.TaskListProps;
import io.noties.markwon.ext.tasklist.TaskListSpanFactory;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;

public class TaskListPlugin
extends AbstractMarkwonPlugin {
    private final Drawable drawable;

    @NonNull
    public static TaskListPlugin create(@NonNull Drawable drawable) {
        return new TaskListPlugin(drawable);
    }

    @NonNull
    public static TaskListPlugin create(@NonNull Context context) {
        int linkColor = TaskListPlugin.resolve(context, 16842907);
        int backgroundColor = TaskListPlugin.resolve(context, 0x1010031);
        return new TaskListPlugin(new TaskListDrawable(linkColor, linkColor, backgroundColor));
    }

    @NonNull
    public static TaskListPlugin create(@ColorInt int checkedFillColor, @ColorInt int normalOutlineColor, @ColorInt int checkMarkColor) {
        return new TaskListPlugin(new TaskListDrawable(checkedFillColor, normalOutlineColor, checkMarkColor));
    }

    private TaskListPlugin(@NonNull Drawable drawable) {
        this.drawable = drawable;
    }

    public void configureParser(@NonNull Parser.Builder builder) {
        builder.postProcessor((PostProcessor)new TaskListPostProcessor());
    }

    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(TaskListItem.class, (SpanFactory)new TaskListSpanFactory(this.drawable));
    }

    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(TaskListItem.class, (MarkwonVisitor.NodeVisitor)new MarkwonVisitor.NodeVisitor<TaskListItem>(){

            public void visit(@NonNull MarkwonVisitor visitor, @NonNull TaskListItem taskListItem) {
                int length = visitor.length();
                visitor.visitChildren((Node)taskListItem);
                TaskListProps.DONE.set(visitor.renderProps(), (Object)taskListItem.isDone());
                visitor.setSpansForNode((Node)taskListItem, length);
                if (visitor.hasNext((Node)taskListItem)) {
                    visitor.ensureNewLine();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolve(@NonNull Context context, @AttrRes int attr2) {
        TypedValue typedValue = new TypedValue();
        int[] attrs = new int[]{attr2};
        TypedArray typedArray = context.obtainStyledAttributes(typedValue.data, attrs);
        try {
            int n = typedArray.getColor(0, 0);
            return n;
        }
        finally {
            typedArray.recycle();
        }
    }
}

