/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.ext.tasklist;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.utils.LeadingMarginUtils;

public class TaskListSpan
implements LeadingMarginSpan {
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private static final int[] STATE_NONE = new int[0];
    private final MarkwonTheme theme;
    private final Drawable drawable;
    private boolean isDone;

    public TaskListSpan(@NonNull MarkwonTheme theme, @NonNull Drawable drawable, boolean isDone) {
        this.theme = theme;
        this.drawable = drawable;
        this.isDone = isDone;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }

    public int getLeadingMargin(boolean first) {
        return this.theme.getBlockMargin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first || !LeadingMarginUtils.selfStart((int)start, (CharSequence)text, (Object)this)) {
            return;
        }
        float descent = p.descent();
        float ascent = p.ascent();
        int save = c.save();
        try {
            int width = this.theme.getBlockMargin();
            int height = (int)(descent - ascent + 0.5f);
            int w = (int)((float)width * 0.75f + 0.5f);
            int h = (int)((float)height * 0.75f + 0.5f);
            this.drawable.setBounds(0, 0, w, h);
            if (this.drawable.isStateful()) {
                int[] state = this.isDone ? STATE_CHECKED : STATE_NONE;
                this.drawable.setState(state);
            }
            int l = dir > 0 ? x + (width - w) / 2 : x - (width - w) / 2 - w;
            int t = (int)((float)baseline + ascent + 0.5f) + (height - h) / 2;
            c.translate((float)l, (float)t);
            this.drawable.draw(c);
        }
        finally {
            c.restoreToCount(save);
        }
    }
}

