/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.gif;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.gif.GifSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import pl.droidsonroids.gif.GifDrawable;

public class GifMediaDecoder
extends MediaDecoder {
    public static final String CONTENT_TYPE = "image/gif";
    private final boolean autoPlayGif;

    @NonNull
    public static GifMediaDecoder create() {
        return GifMediaDecoder.create(true);
    }

    @NonNull
    public static GifMediaDecoder create(boolean autoPlayGif) {
        return new GifMediaDecoder(autoPlayGif);
    }

    protected GifMediaDecoder(boolean autoPlayGif) {
        this.autoPlayGif = autoPlayGif;
        GifMediaDecoder.validate();
    }

    @Override
    @NonNull
    public Drawable decode(@Nullable String contentType, @NonNull InputStream inputStream) {
        GifDrawable drawable;
        byte[] bytes;
        try {
            bytes = GifMediaDecoder.readBytes(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read GIF input-stream", e);
        }
        try {
            drawable = this.newGifDrawable(bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception creating GifDrawable", e);
        }
        if (!this.autoPlayGif) {
            drawable.pause();
        }
        return drawable;
    }

    @Override
    @NonNull
    public Collection<String> supportedTypes() {
        return Collections.singleton(CONTENT_TYPE);
    }

    @NonNull
    protected GifDrawable newGifDrawable(@NonNull byte[] bytes) throws IOException {
        return new GifDrawable(bytes);
    }

    @NonNull
    protected static byte[] readBytes(@NonNull InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int length = 8192;
        byte[] buffer = new byte[8192];
        while ((read = stream.read(buffer, 0, 8192)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        return outputStream.toByteArray();
    }

    private static void validate() {
        if (!GifSupport.hasGifSupport()) {
            throw new IllegalStateException(GifSupport.missingMessage());
        }
    }
}

