/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.svg;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import io.noties.markwon.image.MediaDecoder;
import io.noties.markwon.image.svg.SvgSupport;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;

public class SvgMediaDecoder
extends MediaDecoder {
    public static final String CONTENT_TYPE = "image/svg+xml";
    private final Resources resources;

    @NonNull
    public static SvgMediaDecoder create() {
        return SvgMediaDecoder.create(Resources.getSystem());
    }

    @NonNull
    public static SvgMediaDecoder create(@NonNull Resources resources) {
        return new SvgMediaDecoder(resources);
    }

    SvgMediaDecoder(Resources resources) {
        this.resources = resources;
        SvgMediaDecoder.validate();
    }

    @Override
    @NonNull
    public Drawable decode(@Nullable String contentType, @NonNull InputStream inputStream) {
        SVG svg;
        try {
            svg = SVG.getFromInputStream((InputStream)inputStream);
        }
        catch (SVGParseException e) {
            throw new IllegalStateException("Exception decoding SVG", e);
        }
        float w = svg.getDocumentWidth();
        float h = svg.getDocumentHeight();
        float density = this.resources.getDisplayMetrics().density;
        int width = (int)(w * density + 0.5f);
        int height = (int)(h * density + 0.5f);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(density, density);
        svg.renderToCanvas(canvas);
        return new BitmapDrawable(this.resources, bitmap);
    }

    @Override
    @NonNull
    public Collection<String> supportedTypes() {
        return Collections.singleton(CONTENT_TYPE);
    }

    private static void validate() {
        if (!SvgSupport.hasSvgSupport()) {
            throw new IllegalStateException(SvgSupport.missingMessage());
        }
    }
}

