/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.recycler.table;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import io.noties.markwon.Markwon;
import io.noties.markwon.ext.tables.Table;
import io.noties.markwon.recycler.MarkwonAdapter;
import io.noties.markwon.recycler.table.TableBorderDrawable;
import io.noties.markwon.recycler.table.TableEntryPlugin;
import io.noties.markwon.recycler.table.TableEntryTheme;
import io.noties.markwon.utils.NoCopySpannableFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.ext.gfm.tables.TableBlock;

public class TableEntry
extends MarkwonAdapter.Entry<TableBlock, Holder> {
    private final int tableLayoutResId;
    private final int tableIdRes;
    private final int textLayoutResId;
    private final int textIdRes;
    private final boolean isRecyclable;
    private final boolean cellTextCenterVertical;
    private LayoutInflater inflater;
    private final Map<TableBlock, Table> map = new HashMap<TableBlock, Table>(3);

    @NonNull
    public static Builder builder() {
        return new BuilderImpl();
    }

    @NonNull
    public static TableEntry create(@NonNull BuilderConfigure configure) {
        Builder builder = TableEntry.builder();
        configure.configure(builder);
        return builder.build();
    }

    TableEntry(@LayoutRes int tableLayoutResId, @IdRes int tableIdRes, @LayoutRes int textLayoutResId, @IdRes int textIdRes, boolean isRecyclable, boolean cellTextCenterVertical) {
        this.tableLayoutResId = tableLayoutResId;
        this.tableIdRes = tableIdRes;
        this.textLayoutResId = textLayoutResId;
        this.textIdRes = textIdRes;
        this.isRecyclable = isRecyclable;
        this.cellTextCenterVertical = cellTextCenterVertical;
    }

    @NonNull
    public Holder createHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        return new Holder(this.isRecyclable, this.tableIdRes, inflater.inflate(this.tableLayoutResId, parent, false));
    }

    public void bindHolder(@NonNull Markwon markwon, @NonNull Holder holder, @NonNull TableBlock node) {
        Table table = this.map.get(node);
        if (table == null) {
            table = Table.parse((Markwon)markwon, (TableBlock)node);
            this.map.put(node, table);
        }
        TableLayout layout = holder.tableLayout;
        if (table == null || table == layout.getTag(this.tableLayoutResId)) {
            return;
        }
        layout.setTag(this.tableLayoutResId, (Object)table);
        TableEntryPlugin plugin = (TableEntryPlugin)markwon.getPlugin(TableEntryPlugin.class);
        if (plugin == null) {
            throw new IllegalStateException("No TableEntryPlugin is found. Make sure that it is _used_ whilst configuring Markwon instance");
        }
        TableEntryTheme theme = plugin.theme();
        TextView textView = this.ensureTextView(layout, 0, 0);
        int borderWidth = theme.tableBorderWidth((Paint)textView.getPaint());
        int borderColor = theme.tableBorderColor((Paint)textView.getPaint());
        int cellPadding = theme.tableCellPadding();
        this.ensureTableBorderBackground((View)layout, borderWidth, borderColor);
        List rows = table.rows();
        int rowsSize = rows.size();
        int columnsSize = rowsSize > 0 ? ((Table.Row)rows.get(0)).columns().size() : 0;
        for (int y = 0; y < rowsSize; ++y) {
            boolean isEven;
            TextView textView2;
            Table.Row row = (Table.Row)rows.get(y);
            TableRow tableRow = this.ensureRow(layout, y);
            for (int x = 0; x < columnsSize; ++x) {
                Table.Column column = (Table.Column)row.columns().get(x);
                textView2 = this.ensureTextView(layout, y, x);
                textView2.setGravity(TableEntry.textGravity(column.alignment(), this.cellTextCenterVertical));
                textView2.getPaint().setFakeBoldText(row.header());
                if (cellPadding > 0) {
                    textView2.setPadding(cellPadding, cellPadding, cellPadding, cellPadding);
                }
                this.ensureTableBorderBackground((View)textView2, borderWidth, borderColor);
                markwon.setParsedMarkdown(textView2, column.content());
            }
            if (row.header()) {
                tableRow.setBackgroundColor(theme.tableHeaderRowBackgroundColor());
                continue;
            }
            boolean bl = isEven = y % 2 == 1;
            if (isEven) {
                tableRow.setBackgroundColor(theme.tableEvenRowBackgroundColor());
                continue;
            }
            textView2 = this.ensureTextView(layout, y, 0);
            tableRow.setBackgroundColor(theme.tableOddRowBackgroundColor((Paint)textView2.getPaint()));
        }
        TableEntry.removeUnused(layout, rowsSize, columnsSize);
    }

    @NonNull
    private TableRow ensureRow(@NonNull TableLayout layout, int row) {
        int count = layout.getChildCount();
        if (row >= count) {
            Context context = layout.getContext();
            for (int diff = row - count + 1; diff > 0; --diff) {
                layout.addView((View)new TableRow(context));
            }
        }
        return (TableRow)layout.getChildAt(row);
    }

    @NonNull
    private TextView ensureTextView(@NonNull TableLayout layout, int row, int column) {
        TableRow tableRow = this.ensureRow(layout, row);
        int count = tableRow.getChildCount();
        if (column >= count) {
            LayoutInflater inflater = this.ensureInflater(layout.getContext());
            boolean textViewChecked = false;
            for (int diff = column - count + 1; diff > 0; --diff) {
                TextView textView;
                View view = inflater.inflate(this.textLayoutResId, (ViewGroup)tableRow, false);
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams.height != -1) {
                    layoutParams.height = -1;
                }
                if (!textViewChecked) {
                    if (this.textIdRes == 0) {
                        if (!(view instanceof TextView)) {
                            String name = layout.getContext().getResources().getResourceName(this.textLayoutResId);
                            throw new IllegalStateException(String.format("textLayoutResId(R.layout.%s) has other than TextView root view. Specify TextView ID explicitly", name));
                        }
                        textView = (TextView)view;
                    } else {
                        textView = (TextView)view.findViewById(this.textIdRes);
                        if (textView == null) {
                            Resources r = layout.getContext().getResources();
                            String layoutName = r.getResourceName(this.textLayoutResId);
                            String idName = r.getResourceName(this.textIdRes);
                            throw new NullPointerException(String.format("textLayoutResId(R.layout.%s) has no TextView found by id(R.id.%s): %s", layoutName, idName, view));
                        }
                    }
                    textViewChecked = true;
                } else {
                    textView = this.textIdRes == 0 ? (TextView)view : (TextView)view.findViewById(this.textIdRes);
                }
                textView.setSpannableFactory((Spannable.Factory)NoCopySpannableFactory.getInstance());
                tableRow.addView((View)textView);
            }
        }
        View last = tableRow.getChildAt(column);
        if (this.textIdRes == 0) {
            return (TextView)last;
        }
        return (TextView)last.findViewById(this.textIdRes);
    }

    private void ensureTableBorderBackground(@NonNull View view, @Px int borderWidth, @ColorInt int borderColor) {
        if (borderWidth == 0) {
            view.setBackground(null);
        } else {
            Drawable drawable = view.getBackground();
            if (!(drawable instanceof TableBorderDrawable)) {
                TableBorderDrawable borderDrawable = new TableBorderDrawable();
                borderDrawable.update(borderWidth, borderColor);
                view.setBackground((Drawable)borderDrawable);
            } else {
                ((TableBorderDrawable)drawable).update(borderWidth, borderColor);
            }
        }
    }

    @NonNull
    private LayoutInflater ensureInflater(@NonNull Context context) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)context);
        }
        return this.inflater;
    }

    @VisibleForTesting
    static void removeUnused(@NonNull TableLayout layout, int usedRows, int usedColumns) {
        int rowsCount = layout.getChildCount();
        if (rowsCount > usedRows) {
            layout.removeViews(usedRows, rowsCount - usedRows);
        }
        for (int i = 0; i < usedRows; ++i) {
            TableRow tableRow = (TableRow)layout.getChildAt(i);
            int columnCount = tableRow.getChildCount();
            if (columnCount <= usedColumns) continue;
            tableRow.removeViews(usedColumns, columnCount - usedColumns);
        }
    }

    public void clear() {
        this.map.clear();
    }

    @SuppressLint(value={"RtlHardcoded"})
    @VisibleForTesting
    static int textGravity(@NonNull Table.Alignment alignment, boolean cellTextCenterVertical) {
        int gravity;
        switch (alignment) {
            case LEFT: {
                gravity = 3;
                break;
            }
            case CENTER: {
                gravity = 1;
                break;
            }
            case RIGHT: {
                gravity = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown table alignment: " + alignment);
            }
        }
        if (cellTextCenterVertical) {
            return gravity | 0x10;
        }
        return gravity;
    }

    static class BuilderImpl
    implements Builder {
        private int tableLayoutResId;
        private int tableIdRes;
        private int textLayoutResId;
        private int textIdRes;
        private boolean cellTextCenterVertical = true;
        private boolean isRecyclable = true;

        BuilderImpl() {
        }

        @Override
        @NonNull
        public Builder tableLayout(int tableLayoutResId, int tableIdRes) {
            this.tableLayoutResId = tableLayoutResId;
            this.tableIdRes = tableIdRes;
            return this;
        }

        @Override
        @NonNull
        public Builder tableLayoutIsRoot(int tableLayoutResId) {
            this.tableLayoutResId = tableLayoutResId;
            this.tableIdRes = 0;
            return this;
        }

        @Override
        @NonNull
        public Builder textLayout(int textLayoutResId, int textIdRes) {
            this.textLayoutResId = textLayoutResId;
            this.textIdRes = textIdRes;
            return this;
        }

        @Override
        @NonNull
        public Builder textLayoutIsRoot(int textLayoutResId) {
            this.textLayoutResId = textLayoutResId;
            this.textIdRes = 0;
            return this;
        }

        @Override
        @NonNull
        public Builder cellTextCenterVertical(boolean cellTextCenterVertical) {
            this.cellTextCenterVertical = cellTextCenterVertical;
            return this;
        }

        @Override
        @NonNull
        public Builder isRecyclable(boolean isRecyclable) {
            this.isRecyclable = isRecyclable;
            return this;
        }

        @Override
        @NonNull
        public TableEntry build() {
            if (this.tableLayoutResId == 0) {
                throw new IllegalStateException("`tableLayoutResId` argument is required");
            }
            if (this.textLayoutResId == 0) {
                throw new IllegalStateException("`textLayoutResId` argument is required");
            }
            return new TableEntry(this.tableLayoutResId, this.tableIdRes, this.textLayoutResId, this.textIdRes, this.isRecyclable, this.cellTextCenterVertical);
        }
    }

    public static class Holder
    extends MarkwonAdapter.Holder {
        final TableLayout tableLayout;

        public Holder(boolean isRecyclable, @IdRes int tableLayoutIdRes, @NonNull View itemView) {
            super(itemView);
            TableLayout tableLayout;
            this.setIsRecyclable(isRecyclable);
            if (tableLayoutIdRes == 0) {
                if (!(itemView instanceof TableLayout)) {
                    throw new IllegalStateException("Root view is not TableLayout. Please provide TableLayout ID explicitly");
                }
                tableLayout = (TableLayout)itemView;
            } else {
                tableLayout = (TableLayout)this.requireView(tableLayoutIdRes);
            }
            this.tableLayout = tableLayout;
        }
    }

    public static interface BuilderConfigure {
        public void configure(@NonNull Builder var1);
    }

    public static interface Builder {
        @NonNull
        public Builder tableLayout(@LayoutRes int var1, @IdRes int var2);

        @NonNull
        public Builder tableLayoutIsRoot(@LayoutRes int var1);

        @NonNull
        public Builder textLayout(@LayoutRes int var1, @IdRes int var2);

        @NonNull
        public Builder textLayoutIsRoot(@LayoutRes int var1);

        @NonNull
        public Builder cellTextCenterVertical(boolean var1);

        @NonNull
        public Builder isRecyclable(boolean var1);

        @NonNull
        public TableEntry build();
    }
}

