/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.syntax;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.syntax.Prism4jSyntaxVisitor;
import io.noties.markwon.syntax.Prism4jTheme;
import io.noties.markwon.syntax.SyntaxHighlight;
import io.noties.prism4j.Prism4j;

public class Prism4jSyntaxHighlight
implements SyntaxHighlight {
    private final Prism4j prism4j;
    private final Prism4jTheme theme;
    private final String fallback;

    @NonNull
    public static Prism4jSyntaxHighlight create(@NonNull Prism4j prism4j, @NonNull Prism4jTheme theme) {
        return new Prism4jSyntaxHighlight(prism4j, theme, null);
    }

    @NonNull
    public static Prism4jSyntaxHighlight create(@NonNull Prism4j prism4j, @NonNull Prism4jTheme theme, @Nullable String fallback) {
        return new Prism4jSyntaxHighlight(prism4j, theme, fallback);
    }

    protected Prism4jSyntaxHighlight(@NonNull Prism4j prism4j, @NonNull Prism4jTheme theme, @Nullable String fallback) {
        this.prism4j = prism4j;
        this.theme = theme;
        this.fallback = fallback;
    }

    @NonNull
    public CharSequence highlight(@Nullable String info, @NonNull String code) {
        if (code.isEmpty()) {
            return code;
        }
        return info == null ? this.highlightNoLanguageInfo(code) : this.highlightWithLanguageInfo(info, code);
    }

    @NonNull
    protected CharSequence highlightNoLanguageInfo(@NonNull String code) {
        return code;
    }

    @NonNull
    protected CharSequence highlightWithLanguageInfo(@NonNull String info, @NonNull String code) {
        String _language = info;
        Prism4j.Grammar _grammar = this.prism4j.grammar(info);
        if (_grammar == null && !TextUtils.isEmpty((CharSequence)this.fallback)) {
            _language = this.fallback;
            _grammar = this.prism4j.grammar(this.fallback);
        }
        String language = _language;
        Prism4j.Grammar grammar = _grammar;
        CharSequence out = grammar != null ? this.highlight(language, grammar, code) : code;
        return out;
    }

    @NonNull
    protected CharSequence highlight(@NonNull String language, @NonNull Prism4j.Grammar grammar, @NonNull String code) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        Prism4jSyntaxVisitor visitor = new Prism4jSyntaxVisitor(language, this.theme, builder);
        visitor.visit(this.prism4j.tokenize(code, grammar));
        return builder;
    }

    @NonNull
    protected Prism4j prism4j() {
        return this.prism4j;
    }

    @NonNull
    protected Prism4jTheme theme() {
        return this.theme;
    }

    @Nullable
    protected String fallback() {
        return this.fallback;
    }
}

