/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.syntax;

import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.syntax.Prism4jTheme;
import io.noties.prism4j.Prism4j;
import java.util.HashMap;

public abstract class Prism4jThemeBase
implements Prism4jTheme {
    private final ColorHashMap colorHashMap = this.init();

    @ColorInt
    protected static int applyAlpha(@IntRange(from=0L, to=255L) int alpha, @ColorInt int color) {
        return color & 0xFFFFFF | alpha << 24;
    }

    @ColorInt
    protected static int applyAlpha(@FloatRange(from=0.0, to=1.0) float alpha, @ColorInt int color) {
        return Prism4jThemeBase.applyAlpha((int)(255.0f * alpha + 0.5f), color);
    }

    protected static boolean isOfType(@NonNull String expected, @NonNull String type, @Nullable String alias) {
        return expected.equals(type) || expected.equals(alias);
    }

    protected Prism4jThemeBase() {
    }

    @NonNull
    protected abstract ColorHashMap init();

    @ColorInt
    protected int color(@NonNull String language, @NonNull String type, @Nullable String alias) {
        Color color = (Color)this.colorHashMap.get(type);
        if (color == null && alias != null) {
            color = (Color)this.colorHashMap.get(alias);
        }
        return color != null ? color.color : 0;
    }

    @Override
    public void apply(@NonNull String language, @NonNull Prism4j.Syntax syntax, @NonNull SpannableStringBuilder builder, int start, int end) {
        String alias;
        String type = syntax.type();
        int color = this.color(language, type, alias = syntax.alias());
        if (color != 0) {
            this.applyColor(language, type, alias, color, builder, start, end);
        }
    }

    protected void applyColor(@NonNull String language, @NonNull String type, @Nullable String alias, @ColorInt int color, @NonNull SpannableStringBuilder builder, int start, int end) {
        builder.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
    }

    protected static class ColorHashMap
    extends HashMap<String, Color> {
        protected ColorHashMap() {
        }

        @NonNull
        protected ColorHashMap add(@ColorInt int color, String name) {
            this.put(name, Color.of(color));
            return this;
        }

        @NonNull
        protected ColorHashMap add(@ColorInt int color, @NonNull String name1, @NonNull String name2) {
            Color c = Color.of(color);
            this.put(name1, c);
            this.put(name2, c);
            return this;
        }

        @NonNull
        protected ColorHashMap add(@ColorInt int color, @NonNull String name1, @NonNull String name2, @NonNull String name3) {
            Color c = Color.of(color);
            this.put(name1, c);
            this.put(name2, c);
            this.put(name3, c);
            return this;
        }

        @NonNull
        protected ColorHashMap add(@ColorInt int color, String ... names) {
            Color c = Color.of(color);
            for (String name : names) {
                this.put(name, c);
            }
            return this;
        }
    }

    protected static class Color {
        @ColorInt
        protected final int color;

        @NonNull
        public static Color of(@ColorInt int color) {
            return new Color(color);
        }

        protected Color(@ColorInt int color) {
            this.color = color;
        }
    }
}

