/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.rx.action.combination.FanInAction;
import reactor.rx.action.combination.FanInSubscription;

public final class MergeAction<O>
extends FanInAction<O, O, O, InnerSubscriber<O>> {
    public MergeAction(Dispatcher dispatcher) {
        super(dispatcher);
    }

    public MergeAction(Dispatcher dispatcher, List<? extends Publisher<? extends O>> publishers) {
        super(dispatcher, publishers);
    }

    @Override
    protected void doNext(O ev) {
        this.broadcastNext(ev);
    }

    protected InnerSubscriber<O> createSubscriber() {
        return new InnerSubscriber(this);
    }

    public static final class InnerSubscriber<I>
    extends FanInAction.InnerSubscriber<I, I, I> {
        InnerSubscriber(FanInAction<I, I, I, InnerSubscriber<I>> outerAction) {
            super(outerAction);
        }

        public void onSubscribe(Subscription subscription) {
            long toRequest;
            this.setSubscription(new FanInSubscription.InnerSubscription(subscription, this));
            if (this.outerAction.dynamicMergeAction != null) {
                this.outerAction.dynamicMergeAction.decrementWip();
            }
            if ((toRequest = this.pendingRequests) > 0L) {
                this.pendingRequests = 0L;
                this.request(toRequest);
            }
        }

        public void onNext(I ev) {
            this.outerAction.innerSubscriptions.serialNext(ev);
            ++this.emittedSignals;
            if (--this.pendingRequests < 0L) {
                this.pendingRequests = 0L;
            }
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return false;
        }

        @Override
        public String toString() {
            return "Merge.InnerSubscriber{pending=" + this.pendingRequests + ", emitted=" + this.emittedSignals + "}";
        }
    }
}

