/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.FinalizerRunnable;
import io.realm.internal.NativeObject;
import io.realm.internal.NativeObjectReference;
import java.lang.ref.ReferenceQueue;
import java.util.LinkedList;

public class NativeContext {
    private static final ReferenceQueue<NativeObject> referenceQueue = new ReferenceQueue();
    private static final Thread finalizingThread = new Thread(new FinalizerRunnable(referenceQueue));
    public static final NativeContext dummyContext = new NativeContext();

    public void addReference(NativeObject referent) {
        new NativeObjectReference(this, referent, referenceQueue);
    }

    static void execute(NativeContextRunnable runnable) {
        ManualReleaseNativeContext nativeContext = new ManualReleaseNativeContext();
        runnable.run(nativeContext);
        nativeContext.release();
    }

    static {
        finalizingThread.setName("RealmFinalizingDaemon");
        finalizingThread.start();
    }

    private static class ManualReleaseNativeContext
    extends NativeContext {
        private final LinkedList<NativeObject> references = new LinkedList();

        ManualReleaseNativeContext() {
        }

        @Override
        public void addReference(NativeObject referent) {
            this.references.add(referent);
        }

        public void release() {
            for (NativeObject object : this.references) {
                NativeObjectReference.nativeCleanUp(object.getNativeFinalizerPtr(), object.getNativePtr());
            }
        }
    }

    public static interface NativeContextRunnable {
        public void run(NativeContext var1);
    }
}

