/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmAny;
import io.realm.RealmAnyNativeFunctionsImpl;
import io.realm.Sort;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.Table;
import io.realm.internal.core.NativeRealmAny;
import io.realm.internal.objectstore.OsKeyPathMapping;
import java.util.Date;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;

public class TableQuery
implements NativeObject {
    private static final boolean DEBUG = false;
    private static final long nativeFinalizerPtr = TableQuery.nativeGetFinalizerPtr();
    private final Table table;
    private final long nativePtr;
    private final RealmAnyNativeFunctionsImpl realmAnyNativeFunctions = new RealmAnyNativeFunctionsImpl();
    private boolean queryValidated = true;

    private static String escapeFieldName(@Nullable String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return fieldName.replace(" ", "\\ ");
    }

    public TableQuery(NativeContext context, Table table, long nativeQueryPtr) {
        this.table = table;
        this.nativePtr = nativeQueryPtr;
        context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Table getTable() {
        return this.table;
    }

    public void validateQuery() {
        if (!this.queryValidated) {
            String invalidMessage = this.nativeValidateQuery(this.nativePtr);
            if ("".equals(invalidMessage)) {
                this.queryValidated = true;
            } else {
                throw new UnsupportedOperationException(invalidMessage);
            }
        }
    }

    public TableQuery beginGroup() {
        this.nativeBeginGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endGroup() {
        this.nativeEndGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery or() {
        this.nativeOr(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery not() {
        this.nativeNot(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public static String buildSortDescriptor(String[] fieldNames, Sort[] sortOrders) {
        StringBuilder descriptorBuilder = new StringBuilder("SORT(");
        String sortSeparator = "";
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            descriptorBuilder.append(sortSeparator).append(TableQuery.escapeFieldName(fieldName)).append(" ").append(sortOrders[i] == Sort.ASCENDING ? "ASC" : "DESC");
            sortSeparator = ", ";
        }
        descriptorBuilder.append(")");
        return descriptorBuilder.toString();
    }

    public TableQuery sort(@Nullable OsKeyPathMapping mapping, String[] fieldNames, Sort[] sortOrders) {
        String descriptor = TableQuery.buildSortDescriptor(fieldNames, sortOrders);
        this.rawDescriptor(mapping, descriptor);
        return this;
    }

    public static String buildDistinctDescriptor(String[] fieldNames) {
        StringBuilder descriptorBuilder = new StringBuilder("DISTINCT(");
        String distinctSeparator = "";
        for (String fieldName : fieldNames) {
            descriptorBuilder.append(distinctSeparator).append(TableQuery.escapeFieldName(fieldName));
            distinctSeparator = ", ";
        }
        descriptorBuilder.append(")");
        return descriptorBuilder.toString();
    }

    public TableQuery distinct(@Nullable OsKeyPathMapping mapping, String[] fieldNames) {
        String descriptor = TableQuery.buildDistinctDescriptor(fieldNames);
        this.rawDescriptor(mapping, descriptor);
        return this;
    }

    public TableQuery limit(long limit) {
        this.rawDescriptor(null, "LIMIT(" + limit + ")");
        return this;
    }

    public TableQuery isEmpty(@Nullable OsKeyPathMapping mapping, String fieldName) {
        this.rawPredicateWithPointers(mapping, TableQuery.escapeFieldName(fieldName) + ".@count = 0", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotEmpty(@Nullable OsKeyPathMapping mapping, String fieldName) {
        this.rawPredicateWithPointers(mapping, TableQuery.escapeFieldName(fieldName) + ".@count != 0", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery rawPredicate(@Nullable OsKeyPathMapping mapping, String predicate, RealmAny ... args) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, predicate, args);
        return this;
    }

    public void rawPredicateWithPointers(@Nullable OsKeyPathMapping mapping, String predicate, long ... values) {
        this.nativeRawPredicate(this.nativePtr, predicate, values, mapping != null ? mapping.getNativePtr() : 0L);
    }

    private void rawDescriptor(@Nullable OsKeyPathMapping mapping, String descriptor) {
        this.nativeRawDescriptor(this.nativePtr, descriptor, mapping != null ? mapping.getNativePtr() : 0L);
    }

    public TableQuery equalTo(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " = $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " != $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalToInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " =[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualToInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " !=[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " > $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " >= $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " < $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " <= $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value1, RealmAny value2) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, "(" + TableQuery.escapeFieldName(fieldName) + " >= $0 AND " + TableQuery.escapeFieldName(fieldName) + " <= $1)", value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " BEGINSWITH $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWithInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " BEGINSWITH[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " ENDSWITH $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWithInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " ENDSWITH[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery like(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " LIKE $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery likeInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " LIKE[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " CONTAINS $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery containsInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + " CONTAINS[c] $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery containsKey(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny key) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, "ANY " + TableQuery.escapeFieldName(fieldName) + ".@keys == $0", key);
        this.queryValidated = false;
        return this;
    }

    public TableQuery containsValue(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, "ANY " + TableQuery.escapeFieldName(fieldName) + ".@values == $0", value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery containsEntry(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny key, RealmAny value) {
        this.realmAnyNativeFunctions.callRawPredicate(this, mapping, TableQuery.escapeFieldName(fieldName) + "[$0] == $1", key, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNull(@Nullable OsKeyPathMapping mapping, String fieldName) {
        this.rawPredicateWithPointers(mapping, TableQuery.escapeFieldName(fieldName) + " = NULL", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotNull(@Nullable OsKeyPathMapping mapping, String fieldName) {
        this.rawPredicateWithPointers(mapping, TableQuery.escapeFieldName(fieldName) + " != NULL", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery alwaysTrue() {
        this.rawPredicateWithPointers(null, "TRUEPREDICATE", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery alwaysFalse() {
        this.rawPredicateWithPointers(null, "FALSEPREDICATE", new long[0]);
        this.queryValidated = false;
        return this;
    }

    public TableQuery in(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny[] values) {
        fieldName = TableQuery.escapeFieldName(fieldName);
        this.beginGroup();
        boolean first = true;
        for (RealmAny value : values) {
            if (!first) {
                this.or();
            }
            if (value == null) {
                this.isNull(mapping, fieldName);
            } else {
                this.equalTo(mapping, fieldName, value);
            }
            first = false;
        }
        this.endGroup();
        this.queryValidated = false;
        return this;
    }

    public TableQuery inInsensitive(@Nullable OsKeyPathMapping mapping, String fieldName, RealmAny[] values) {
        fieldName = TableQuery.escapeFieldName(fieldName);
        this.beginGroup();
        boolean first = true;
        for (RealmAny value : values) {
            if (!first) {
                this.or();
            }
            if (value == null) {
                this.isNull(mapping, fieldName);
            } else {
                this.equalToInsensitive(mapping, fieldName, value);
            }
            first = false;
        }
        this.endGroup();
        this.queryValidated = false;
        return this;
    }

    public long find() {
        this.validateQuery();
        return this.nativeFind(this.nativePtr);
    }

    public long sumInt(long columnKey) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnKey);
    }

    public Long maximumInt(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnKey);
    }

    public Long minimumInt(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnKey);
    }

    public double averageInt(long columnKey) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnKey);
    }

    public double sumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnKey);
    }

    public Float maximumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnKey);
    }

    public Float minimumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnKey);
    }

    public double averageFloat(long columnKey) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnKey);
    }

    public double sumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnKey);
    }

    public Decimal128 sumDecimal128(long columnKey) {
        this.validateQuery();
        long[] data = this.nativeSumDecimal128(this.nativePtr, columnKey);
        if (data != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
        }
        return null;
    }

    public Double maximumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnKey);
    }

    public Double minimumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnKey);
    }

    public double averageDouble(long columnKey) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnKey);
    }

    public Decimal128 sumRealmAny(long columnKey) {
        this.validateQuery();
        long[] data = this.nativeSumRealmAny(this.nativePtr, columnKey);
        return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
    }

    public NativeRealmAny maximumRealmAny(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumRealmAny(this.nativePtr, columnKey);
    }

    public NativeRealmAny minimumRealmAny(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumRealmAny(this.nativePtr, columnKey);
    }

    public Decimal128 averageRealmAny(long columnKey) {
        this.validateQuery();
        long[] data = this.nativeAverageRealmAny(this.nativePtr, columnKey);
        return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
    }

    public Decimal128 averageDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeAverageDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    public Decimal128 maximumDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeMaximumDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    public Date maximumDate(long columnKey) {
        this.validateQuery();
        Long result = this.nativeMaximumTimestamp(this.nativePtr, columnKey);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Date minimumDate(long columnKey) {
        this.validateQuery();
        Long result = this.nativeMinimumTimestamp(this.nativePtr, columnKey);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Decimal128 minimumDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeMinimumDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    @Deprecated
    public long count() {
        this.validateQuery();
        return this.nativeCount(this.nativePtr);
    }

    public long remove() {
        this.validateQuery();
        if (this.table.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr);
    }

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }

    private native long nativeFind(long var1);

    private native long nativeSumInt(long var1, long var3);

    private native Long nativeMaximumInt(long var1, long var3);

    private native Long nativeMinimumInt(long var1, long var3);

    private native double nativeAverageInt(long var1, long var3);

    private native double nativeSumFloat(long var1, long var3);

    private native Float nativeMaximumFloat(long var1, long var3);

    private native Float nativeMinimumFloat(long var1, long var3);

    private native double nativeAverageFloat(long var1, long var3);

    private native long[] nativeSumRealmAny(long var1, long var3);

    private native double nativeSumDouble(long var1, long var3);

    private native long[] nativeSumDecimal128(long var1, long var3);

    private native Double nativeMaximumDouble(long var1, long var3);

    private native NativeRealmAny nativeMaximumRealmAny(long var1, long var3);

    private native long[] nativeMaximumDecimal128(long var1, long var3);

    private native NativeRealmAny nativeMinimumRealmAny(long var1, long var3);

    private native Double nativeMinimumDouble(long var1, long var3);

    private native long[] nativeMinimumDecimal128(long var1, long var3);

    private native long[] nativeAverageRealmAny(long var1, long var3);

    private native double nativeAverageDouble(long var1, long var3);

    private native long[] nativeAverageDecimal128(long var1, long var3);

    private native Long nativeMaximumTimestamp(long var1, long var3);

    private native Long nativeMinimumTimestamp(long var1, long var3);

    private native long nativeCount(long var1);

    private native long nativeRemove(long var1);

    private native void nativeRawPredicate(long var1, String var3, long[] var4, long var5);

    private native void nativeRawDescriptor(long var1, String var3, long var4);

    private native void nativeBeginGroup(long var1);

    private native void nativeEndGroup(long var1);

    private native void nativeOr(long var1);

    private native void nativeNot(long var1);

    private native String nativeValidateQuery(long var1);

    private static native long nativeGetFinalizerPtr();
}

