/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import android.os.Handler;
import android.os.Looper;
import io.realm.RealmAsyncTask;
import io.realm.RealmQuery;
import io.realm.internal.NativeObject;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.internal.objectstore.OsMutableSubscriptionSet;
import io.realm.internal.objectstore.OsSubscription;
import io.realm.mongodb.sync.Subscription;
import io.realm.mongodb.sync.SubscriptionSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class OsSubscriptionSet
implements NativeObject,
SubscriptionSet {
    public static final byte STATE_VALUE_UNCOMMITTED = 0;
    public static final byte STATE_VALUE_PENDING = 1;
    public static final byte STATE_VALUE_BOOTSTRAPPING = 2;
    public static final byte STATE_VALUE_COMPLETE = 3;
    public static final byte STATE_VALUE_ERROR = 4;
    public static final byte STATE_VALUE_SUPERSEDED = 5;
    private static final long nativeFinalizerPtr = OsSubscriptionSet.nativeGetFinalizerMethodPtr();
    protected final RealmProxyMediator schema;
    private final RealmThreadPoolExecutor stateListenerExecutor;
    private final RealmThreadPoolExecutor updateExecutor;
    private long nativePtr;
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    public OsSubscriptionSet(long nativePtr, RealmProxyMediator schema, RealmThreadPoolExecutor listenerExecutor, RealmThreadPoolExecutor writeExecutor) {
        this.nativePtr = nativePtr;
        this.schema = schema;
        this.stateListenerExecutor = listenerExecutor;
        this.updateExecutor = writeExecutor;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    @Override
    @Nullable
    public Subscription find(RealmQuery query) {
        long subscriptionPtr = OsSubscriptionSet.nativeFindByQuery(this.nativePtr, query.getQueryPointer());
        if (subscriptionPtr != -1L) {
            return new OsSubscription(subscriptionPtr);
        }
        return null;
    }

    @Override
    @Nullable
    public Subscription find(String name) {
        long subscriptionPtr = OsSubscriptionSet.nativeFindByName(this.nativePtr, name);
        if (subscriptionPtr != -1L) {
            return new OsSubscription(subscriptionPtr);
        }
        return null;
    }

    @Override
    public SubscriptionSet.State getState() {
        byte value = OsSubscriptionSet.nativeState(this.nativePtr);
        return SubscriptionSet.State.fromNativeValue(value);
    }

    @Override
    public int size() {
        return (int)OsSubscriptionSet.nativeSize(this.nativePtr);
    }

    @Override
    public String getErrorMessage() {
        return OsSubscriptionSet.nativeErrorMessage(this.nativePtr);
    }

    @Override
    public boolean waitForSynchronization() {
        return this.waitForSynchronization(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public boolean waitForSynchronization(Long timeOut, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean success = new AtomicBoolean(false);
        OsSubscriptionSet.nativeWaitForSynchronization(this.nativePtr, new StateChangeCallback(){

            @Override
            public void onChange(byte state) {
                success.set(SubscriptionSet.State.fromNativeValue(state) == SubscriptionSet.State.COMPLETE);
                latch.countDown();
            }
        });
        try {
            if (!latch.await(timeOut, unit)) {
                throw new RuntimeException("Waiting for waitForSynchronization() timed out.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for waitForSynchronization() was interrupted.");
        }
        this.refresh();
        return success.get();
    }

    @Override
    public RealmAsyncTask waitForSynchronizationAsync(SubscriptionSet.StateChangeCallback callback) {
        return this.waitForSynchronizationAsync(Long.MAX_VALUE, TimeUnit.SECONDS, callback);
    }

    @Override
    public RealmAsyncTask waitForSynchronizationAsync(final Long timeOut, final TimeUnit unit, final SubscriptionSet.StateChangeCallback callback) {
        Future<?> future = this.stateListenerExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    OsSubscriptionSet.this.waitForSynchronization(timeOut, unit);
                    OsSubscriptionSet.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onStateChange(OsSubscriptionSet.this);
                        }
                    });
                }
                catch (Exception e) {
                    OsSubscriptionSet.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(e);
                        }
                    });
                }
            }
        });
        return new RealmAsyncTaskImpl(future, this.stateListenerExecutor);
    }

    @Override
    public SubscriptionSet update(SubscriptionSet.UpdateCallback action) {
        OsMutableSubscriptionSet mutableSubs = new OsMutableSubscriptionSet(OsSubscriptionSet.nativeCreateMutableSubscriptionSet(this.nativePtr), this.schema, this.stateListenerExecutor, this.updateExecutor);
        action.update(mutableSubs);
        long newSubscriptionsSet = mutableSubs.commit();
        long oldPointer = this.nativePtr;
        this.nativePtr = newSubscriptionsSet;
        OsSubscriptionSet.nativeRelease(oldPointer);
        return this;
    }

    @Override
    public RealmAsyncTask updateAsync(final SubscriptionSet.UpdateAsyncCallback callback) {
        Future<?> future = this.updateExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    final SubscriptionSet updatedSubscriptions = OsSubscriptionSet.this.update(callback);
                    OsSubscriptionSet.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(updatedSubscriptions);
                        }
                    });
                }
                catch (Throwable exception) {
                    OsSubscriptionSet.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(exception);
                        }
                    });
                }
            }
        });
        return new RealmAsyncTaskImpl(future, this.updateExecutor);
    }

    public void refresh() {
        OsSubscriptionSet.nativeRefresh(this.nativePtr);
    }

    @Override
    public Iterator<Subscription> iterator() {
        return new Iterator<Subscription>(){
            private int cursor = 0;
            private final int size = OsSubscriptionSet.this.size();

            @Override
            public boolean hasNext() {
                return this.cursor < this.size;
            }

            @Override
            public Subscription next() {
                if (this.cursor >= this.size) {
                    throw new NoSuchElementException("Iterator has no more elements. Tried index " + this.cursor + ". Size is " + this.size + ".");
                }
                long subscriptionPtr = OsSubscriptionSet.nativeSubscriptionAt(OsSubscriptionSet.this.nativePtr, this.cursor);
                ++this.cursor;
                return new OsSubscription(subscriptionPtr);
            }
        };
    }

    private static native long nativeGetFinalizerMethodPtr();

    private static native void nativeRelease(long var0);

    private static native long nativeSize(long var0);

    private static native byte nativeState(long var0);

    private static native String nativeErrorMessage(long var0);

    private static native long nativeCreateMutableSubscriptionSet(long var0);

    private static native long nativeSubscriptionAt(long var0, int var2);

    private static native void nativeWaitForSynchronization(long var0, StateChangeCallback var2);

    private static native long nativeFindByName(long var0, String var2);

    private static native long nativeFindByQuery(long var0, long var2);

    private static native void nativeRefresh(long var0);

    private static interface StateChangeCallback {
        public void onChange(byte var1);
    }
}

