/*
 * Decompiled with CFR 0.152.
 */
package io.realm.mongodb.sync;

import io.realm.RealmAsyncTask;
import io.realm.RealmQuery;
import io.realm.internal.Keep;
import io.realm.mongodb.sync.MutableSubscriptionSet;
import io.realm.mongodb.sync.Subscription;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Keep
public interface SubscriptionSet
extends Iterable<Subscription> {
    @Nullable
    public Subscription find(RealmQuery var1);

    @Nullable
    public Subscription find(String var1);

    public State getState();

    public int size();

    @Nullable
    public String getErrorMessage();

    public boolean waitForSynchronization();

    public boolean waitForSynchronization(Long var1, TimeUnit var2);

    public RealmAsyncTask waitForSynchronizationAsync(StateChangeCallback var1);

    public RealmAsyncTask waitForSynchronizationAsync(Long var1, TimeUnit var2, StateChangeCallback var3);

    public SubscriptionSet update(UpdateCallback var1);

    public RealmAsyncTask updateAsync(UpdateAsyncCallback var1);

    @Keep
    public static interface StateChangeCallback {
        public void onStateChange(SubscriptionSet var1);

        public void onError(Throwable var1);
    }

    public static interface UpdateAsyncCallback
    extends UpdateCallback {
        public void onSuccess(SubscriptionSet var1);

        public void onError(Throwable var1);
    }

    public static interface UpdateCallback {
        public void update(MutableSubscriptionSet var1);
    }

    public static enum State {
        UNCOMMITTED(0),
        PENDING(1),
        BOOTSTRAPPING(2),
        COMPLETE(3),
        ERROR(4),
        SUPERSEDED(5);

        private final byte value;

        private State(byte nativeValue) {
            this.value = nativeValue;
        }

        public static State fromNativeValue(long value) {
            for (State state : State.values()) {
                if ((long)state.value != value) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown SubscriptionSetState code: " + value);
        }
    }
}

