/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class StringListOperator
extends ManagedListOperator<String> {
    StringListOperator(BaseRealm realm, OsList osList, Class<String> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public String get(int index) {
        return (String)this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.String", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addString((String)value);
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertString(index, (String)value);
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setString(index, (String)value);
    }
}

