/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmChangeListener;
import io.realm.internal.Keep;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsSharedRealm;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@Keep
public abstract class RealmNotifier
implements Closeable {
    private ObserverPairList<RealmObserverPair> realmObserverPairs = new ObserverPairList();
    private final ObserverPairList.Callback<RealmObserverPair> onChangeCallBack = new ObserverPairList.Callback<RealmObserverPair>(){

        @Override
        public void onCalled(RealmObserverPair pair, Object observer) {
            if (RealmNotifier.this.sharedRealm != null && !RealmNotifier.this.sharedRealm.isClosed()) {
                pair.onChange(observer);
            }
        }
    };
    private OsSharedRealm sharedRealm;
    private List<Runnable> transactionCallbacks = new ArrayList<Runnable>();
    private List<Runnable> startSendingNotificationsCallbacks = new ArrayList<Runnable>();
    private List<Runnable> finishedSendingNotificationsCallbacks = new ArrayList<Runnable>();

    protected RealmNotifier(@Nullable OsSharedRealm sharedRealm) {
        this.sharedRealm = sharedRealm;
    }

    void didChange() {
        this.realmObserverPairs.foreach(this.onChangeCallBack);
        if (!this.transactionCallbacks.isEmpty()) {
            List<Runnable> callbacks = this.transactionCallbacks;
            this.transactionCallbacks = new ArrayList<Runnable>();
            for (Runnable runnable : callbacks) {
                runnable.run();
            }
        }
    }

    void beforeNotify() {
        this.sharedRealm.invalidateIterators();
    }

    void willSendNotifications() {
        for (int i = 0; i < this.startSendingNotificationsCallbacks.size(); ++i) {
            this.startSendingNotificationsCallbacks.get(i).run();
        }
    }

    void didSendNotifications() {
        for (int i = 0; i < this.startSendingNotificationsCallbacks.size(); ++i) {
            this.finishedSendingNotificationsCallbacks.get(i).run();
        }
    }

    @Override
    public void close() {
        this.removeAllChangeListeners();
        this.startSendingNotificationsCallbacks.clear();
        this.finishedSendingNotificationsCallbacks.clear();
    }

    public <T> void addChangeListener(T observer, RealmChangeListener<T> realmChangeListener) {
        RealmObserverPair<T> observerPair = new RealmObserverPair<T>(observer, realmChangeListener);
        this.realmObserverPairs.add(observerPair);
    }

    public <E> void removeChangeListener(E observer, RealmChangeListener<E> realmChangeListener) {
        this.realmObserverPairs.remove(observer, realmChangeListener);
    }

    public <E> void removeChangeListeners(E observer) {
        this.realmObserverPairs.removeByObserver(observer);
    }

    private void removeAllChangeListeners() {
        this.realmObserverPairs.clear();
    }

    public void addTransactionCallback(Runnable runnable) {
        this.transactionCallbacks.add(runnable);
    }

    public abstract boolean post(Runnable var1);

    public int getListenersListSize() {
        return this.realmObserverPairs.size();
    }

    public void addBeginSendingNotificationsCallback(Runnable runnable) {
        this.startSendingNotificationsCallbacks.add(runnable);
    }

    public void addFinishedSendingNotificationsCallback(Runnable runnable) {
        this.finishedSendingNotificationsCallbacks.add(runnable);
    }

    private static class RealmObserverPair<T>
    extends ObserverPairList.ObserverPair<T, RealmChangeListener<T>> {
        RealmObserverPair(T observer, RealmChangeListener<T> listener) {
            super(observer, listener);
        }

        private void onChange(T observer) {
            if (observer != null) {
                ((RealmChangeListener)this.listener).onChange(observer);
            }
        }
    }
}

