/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import io.realm.RealmList;
import io.realm.internal.OsList;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ProxyUtils {
    ProxyUtils() {
    }

    static <E> void setRealmListWithJsonObject(RealmList<E> realmList, JSONObject jsonObject, String fieldName) throws JSONException {
        if (!jsonObject.has(fieldName)) {
            return;
        }
        OsList osList = realmList.getOsList();
        if (jsonObject.isNull(fieldName)) {
            osList.removeAll();
            return;
        }
        JSONArray jsonArray = jsonObject.getJSONArray(fieldName);
        osList.removeAll();
        int arraySize = jsonArray.length();
        if (realmList.clazz == Boolean.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addBoolean(jsonArray.getBoolean(i));
            }
        } else if (realmList.clazz == Float.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addFloat((float)jsonArray.getDouble(i));
            }
        } else if (realmList.clazz == Double.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addDouble(jsonArray.getDouble(i));
            }
        } else if (realmList.clazz == String.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addString(jsonArray.getString(i));
            }
        } else if (realmList.clazz == byte[].class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addBinary(JsonUtils.stringToBytes(jsonArray.getString(i)));
            }
        } else if (realmList.clazz == Date.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object timestamp = jsonArray.get(i);
                if (timestamp instanceof String) {
                    osList.addDate(JsonUtils.stringToDate((String)timestamp));
                    continue;
                }
                osList.addDate(new Date(jsonArray.getLong(i)));
            }
        } else if (realmList.clazz == Long.class || realmList.clazz == Integer.class || realmList.clazz == Short.class || realmList.clazz == Byte.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addLong(jsonArray.getLong(i));
            }
        } else {
            ProxyUtils.throwWrongElementType(realmList.clazz);
        }
    }

    @TargetApi(value=11)
    static <E> RealmList<E> createRealmListWithJsonStream(Class<E> elementClass, JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == null) {
            jsonReader.skipValue();
            return null;
        }
        jsonReader.beginArray();
        RealmList<Object> realmList = new RealmList<Object>();
        if (elementClass == Boolean.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextBoolean());
            }
        } else if (elementClass == Float.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(Float.valueOf((float)jsonReader.nextDouble()));
            }
        } else if (elementClass == Double.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextDouble());
            }
        } else if (elementClass == String.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextString());
            }
        } else if (elementClass == byte[].class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(JsonUtils.stringToBytes(jsonReader.nextString()));
            }
        } else if (elementClass == Date.class) {
            while (jsonReader.hasNext()) {
                JsonToken token = jsonReader.peek();
                if (token == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                if (token == JsonToken.NUMBER) {
                    realmList.add(new Date(jsonReader.nextLong()));
                    continue;
                }
                realmList.add(JsonUtils.stringToDate(jsonReader.nextString()));
            }
        } else if (elementClass == Long.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextLong());
            }
        } else if (elementClass == Integer.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((int)jsonReader.nextLong());
            }
        } else if (elementClass == Short.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((short)jsonReader.nextLong());
            }
        } else if (elementClass == Byte.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((byte)jsonReader.nextLong());
            }
        } else {
            ProxyUtils.throwWrongElementType(elementClass);
        }
        jsonReader.endArray();
        return realmList;
    }

    private static void throwWrongElementType(@Nullable Class clazz) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Element type '%s' is not handled.", clazz));
    }
}

