/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import io.realm.ImportFlag;
import io.realm.MutableRealmInteger;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.internal.NativeContext;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import java.io.Closeable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class OsObjectBuilder
implements Closeable {
    private final Table table;
    private final long sharedRealmPtr;
    private final long builderPtr;
    private final long tablePtr;
    private final NativeContext context;
    private static ItemCallback<? extends RealmModel> objectItemCallback = new ItemCallback<RealmModel>(){

        @Override
        public void handleItem(long listPtr, RealmModel item) {
            RealmObjectProxy proxyItem = (RealmObjectProxy)item;
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, ((UncheckedRow)proxyItem.realmGet$proxyState().getRow$realm()).getNativePtr());
        }
    };
    private static ItemCallback<String> stringItemCallback = new ItemCallback<String>(){

        @Override
        public void handleItem(long listPtr, String item) {
            OsObjectBuilder.nativeAddStringListItem(listPtr, item);
        }
    };
    private static ItemCallback<Byte> byteItemCallback = new ItemCallback<Byte>(){

        @Override
        public void handleItem(long listPtr, Byte item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.longValue());
        }
    };
    private static ItemCallback<Short> shortItemCallback = new ItemCallback<Short>(){

        @Override
        public void handleItem(long listPtr, Short item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.shortValue());
        }
    };
    private static ItemCallback<Integer> integerItemCallback = new ItemCallback<Integer>(){

        @Override
        public void handleItem(long listPtr, Integer item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item.intValue());
        }
    };
    private static ItemCallback<Long> longItemCallback = new ItemCallback<Long>(){

        @Override
        public void handleItem(long listPtr, Long item) {
            OsObjectBuilder.nativeAddIntegerListItem(listPtr, item);
        }
    };
    private static ItemCallback<Boolean> booleanItemCallback = new ItemCallback<Boolean>(){

        @Override
        public void handleItem(long listPtr, Boolean item) {
            OsObjectBuilder.nativeAddBooleanListItem(listPtr, item);
        }
    };
    private static ItemCallback<Float> floatItemCallback = new ItemCallback<Float>(){

        @Override
        public void handleItem(long listPtr, Float item) {
            OsObjectBuilder.nativeAddFloatListItem(listPtr, item.floatValue());
        }
    };
    private static ItemCallback<Double> doubleItemCallback = new ItemCallback<Double>(){

        @Override
        public void handleItem(long listPtr, Double item) {
            OsObjectBuilder.nativeAddDoubleListItem(listPtr, item);
        }
    };
    private static ItemCallback<Date> dateItemCallback = new ItemCallback<Date>(){

        @Override
        public void handleItem(long listPtr, Date item) {
            OsObjectBuilder.nativeAddDateListItem(listPtr, item.getTime());
        }
    };
    private static ItemCallback<byte[]> byteArrayItemCallback = new ItemCallback<byte[]>(){

        @Override
        public void handleItem(long listPtr, byte[] item) {
            OsObjectBuilder.nativeAddByteArrayListItem(listPtr, item);
        }
    };
    private static ItemCallback<MutableRealmInteger> mutableRealmIntegerItemCallback = new ItemCallback<MutableRealmInteger>(){

        @Override
        public void handleItem(long listPtr, MutableRealmInteger item) {
            Long value = item.get();
            if (value == null) {
                OsObjectBuilder.nativeAddNullListItem(listPtr);
            } else {
                OsObjectBuilder.nativeAddIntegerListItem(listPtr, value);
            }
        }
    };
    private static ItemCallback<Decimal128> decimal128ItemCallback = new ItemCallback<Decimal128>(){

        @Override
        public void handleItem(long listPtr, Decimal128 item) {
            OsObjectBuilder.nativeAddDecimal128ListItem(listPtr, item.getLow(), item.getHigh());
        }
    };
    private static ItemCallback<ObjectId> objectIdItemCallback = new ItemCallback<ObjectId>(){

        @Override
        public void handleItem(long listPtr, ObjectId item) {
            OsObjectBuilder.nativeAddObjectIdListItem(listPtr, item.toString());
        }
    };
    private final boolean ignoreFieldsWithSameValue;

    public OsObjectBuilder(Table table, Set<ImportFlag> flags) {
        OsSharedRealm sharedRealm = table.getSharedRealm();
        this.sharedRealmPtr = sharedRealm.getNativePtr();
        this.table = table;
        this.table.getColumnNames();
        this.tablePtr = table.getNativePtr();
        this.builderPtr = OsObjectBuilder.nativeCreateBuilder();
        this.context = sharedRealm.context;
        this.ignoreFieldsWithSameValue = flags.contains((Object)ImportFlag.CHECK_SAME_VALUES_BEFORE_SET);
    }

    public void addInteger(long columnKey, @Nullable Byte val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.byteValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Short val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.shortValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Integer val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.intValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Long val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val);
        }
    }

    public void addMutableRealmInteger(long columnKey, @Nullable MutableRealmInteger val) {
        if (val == null || val.get() == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.get());
        }
    }

    public void addString(long columnKey, @Nullable String val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddString(this.builderPtr, columnKey, val);
        }
    }

    public void addFloat(long columnKey, @Nullable Float val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddFloat(this.builderPtr, columnKey, val.floatValue());
        }
    }

    public void addDouble(long columnKey, @Nullable Double val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDouble(this.builderPtr, columnKey, val);
        }
    }

    public void addBoolean(long columnKey, @Nullable Boolean val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddBoolean(this.builderPtr, columnKey, val);
        }
    }

    public void addDate(long columnKey, @Nullable Date val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDate(this.builderPtr, columnKey, val.getTime());
        }
    }

    public void addByteArray(long columnKey, @Nullable byte[] val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddByteArray(this.builderPtr, columnKey, val);
        }
    }

    public void addDecimal128(long columnKey, @Nullable Decimal128 val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDecimal128(this.builderPtr, columnKey, val.getLow(), val.getHigh());
        }
    }

    public void addObjectId(long columnKey, @Nullable ObjectId val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddObjectId(this.builderPtr, columnKey, val.toString());
        }
    }

    public void addNull(long columnKey) {
        OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
    }

    public void addObject(long columnKey, @Nullable RealmModel val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)val;
            UncheckedRow row = (UncheckedRow)proxy.realmGet$proxyState().getRow$realm();
            OsObjectBuilder.nativeAddObject(this.builderPtr, columnKey, row.getNativePtr());
        }
    }

    private <T> void addListItem(long builderPtr, long columnKey, @Nullable List<T> list, ItemCallback<T> itemCallback) {
        if (list != null) {
            long listPtr = OsObjectBuilder.nativeStartList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                T item = list.get(i);
                if (item == null) {
                    OsObjectBuilder.nativeAddNullListItem(listPtr);
                    continue;
                }
                itemCallback.handleItem(listPtr, item);
            }
            OsObjectBuilder.nativeStopList(builderPtr, columnKey, listPtr);
        } else {
            this.addEmptyList(columnKey);
        }
    }

    public <T extends RealmModel> void addObjectList(long columnKey, @Nullable RealmList<T> list) {
        if (list != null) {
            long[] rowPointers = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                RealmObjectProxy item = (RealmObjectProxy)list.get(i);
                if (item == null) {
                    throw new IllegalArgumentException("Null values are not allowed in RealmLists containing Realm models");
                }
                rowPointers[i] = ((UncheckedRow)item.realmGet$proxyState().getRow$realm()).getNativePtr();
            }
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnKey, rowPointers);
        } else {
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnKey, new long[0]);
        }
    }

    public void addStringList(long columnKey, RealmList<String> list) {
        this.addListItem(this.builderPtr, columnKey, list, stringItemCallback);
    }

    public void addByteList(long columnKey, RealmList<Byte> list) {
        this.addListItem(this.builderPtr, columnKey, list, byteItemCallback);
    }

    public void addShortList(long columnKey, RealmList<Short> list) {
        this.addListItem(this.builderPtr, columnKey, list, shortItemCallback);
    }

    public void addIntegerList(long columnKey, RealmList<Integer> list) {
        this.addListItem(this.builderPtr, columnKey, list, integerItemCallback);
    }

    public void addLongList(long columnKey, RealmList<Long> list) {
        this.addListItem(this.builderPtr, columnKey, list, longItemCallback);
    }

    public void addBooleanList(long columnKey, RealmList<Boolean> list) {
        this.addListItem(this.builderPtr, columnKey, list, booleanItemCallback);
    }

    public void addFloatList(long columnKey, RealmList<Float> list) {
        this.addListItem(this.builderPtr, columnKey, list, floatItemCallback);
    }

    public void addDoubleList(long columnKey, RealmList<Double> list) {
        this.addListItem(this.builderPtr, columnKey, list, doubleItemCallback);
    }

    public void addDateList(long columnKey, RealmList<Date> list) {
        this.addListItem(this.builderPtr, columnKey, list, dateItemCallback);
    }

    public void addByteArrayList(long columnKey, RealmList<byte[]> list) {
        this.addListItem(this.builderPtr, columnKey, list, byteArrayItemCallback);
    }

    public void addMutableRealmIntegerList(long columnKey, RealmList<MutableRealmInteger> list) {
        this.addListItem(this.builderPtr, columnKey, list, mutableRealmIntegerItemCallback);
    }

    public void addDecimal128List(long columnKey, RealmList<Decimal128> list) {
        this.addListItem(this.builderPtr, columnKey, list, decimal128ItemCallback);
    }

    public void addObjectIdList(long columnKey, RealmList<ObjectId> list) {
        this.addListItem(this.builderPtr, columnKey, list, objectIdItemCallback);
    }

    private void addEmptyList(long columnKey) {
        long listPtr = OsObjectBuilder.nativeStartList(0L);
        OsObjectBuilder.nativeStopList(this.builderPtr, columnKey, listPtr);
    }

    public void updateExistingTopLevelObject() {
        try {
            OsObjectBuilder.nativeCreateOrUpdateTopLevelObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, true, this.ignoreFieldsWithSameValue);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExistingEmbeddedObject(RealmObjectProxy embeddedObject) {
        try {
            long objKey = embeddedObject.realmGet$proxyState().getRow$realm().getObjectKey();
            OsObjectBuilder.nativeUpdateEmbeddedObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, objKey, this.ignoreFieldsWithSameValue);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UncheckedRow createNewObject() {
        UncheckedRow row;
        try {
            long rowPtr = OsObjectBuilder.nativeCreateOrUpdateTopLevelObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, false, false);
            row = new UncheckedRow(this.context, this.table, rowPtr);
        }
        finally {
            this.close();
        }
        return row;
    }

    public long getNativePtr() {
        return this.builderPtr;
    }

    @Override
    public void close() {
        OsObjectBuilder.nativeDestroyBuilder(this.builderPtr);
    }

    private static native long nativeCreateBuilder();

    private static native void nativeDestroyBuilder(long var0);

    private static native long nativeCreateOrUpdateTopLevelObject(long var0, long var2, long var4, boolean var6, boolean var7);

    private static native long nativeUpdateEmbeddedObject(long var0, long var2, long var4, long var6, boolean var8);

    private static native void nativeAddNull(long var0, long var2);

    private static native void nativeAddInteger(long var0, long var2, long var4);

    private static native void nativeAddString(long var0, long var2, String var4);

    private static native void nativeAddFloat(long var0, long var2, float var4);

    private static native void nativeAddDouble(long var0, long var2, double var4);

    private static native void nativeAddBoolean(long var0, long var2, boolean var4);

    private static native void nativeAddByteArray(long var0, long var2, byte[] var4);

    private static native void nativeAddDate(long var0, long var2, long var4);

    private static native void nativeAddObject(long var0, long var2, long var4);

    private static native void nativeAddDecimal128(long var0, long var2, long var4, long var6);

    private static native void nativeAddObjectId(long var0, long var2, String var4);

    private static native long nativeStartList(long var0);

    private static native void nativeStopList(long var0, long var2, long var4);

    private static native void nativeAddNullListItem(long var0);

    private static native void nativeAddIntegerListItem(long var0, long var2);

    private static native void nativeAddStringListItem(long var0, String var2);

    private static native void nativeAddFloatListItem(long var0, float var2);

    private static native void nativeAddDoubleListItem(long var0, double var2);

    private static native void nativeAddBooleanListItem(long var0, boolean var2);

    private static native void nativeAddByteArrayListItem(long var0, byte[] var2);

    private static native void nativeAddDateListItem(long var0, long var2);

    private static native void nativeAddDecimal128ListItem(long var0, long var2, long var4);

    private static native void nativeAddObjectIdListItem(long var0, String var2);

    private static native void nativeAddObjectListItem(long var0, long var2);

    private static native void nativeAddObjectList(long var0, long var2, long[] var4);

    private static interface ItemCallback<T> {
        public void handleItem(long var1, T var3);
    }
}

