/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import java.util.Locale;

public class Property
implements NativeObject {
    public static final boolean PRIMARY_KEY = true;
    public static final boolean REQUIRED = true;
    public static final boolean INDEXED = true;
    public static final int TYPE_INT = 0;
    public static final int TYPE_BOOL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_DATA = 3;
    public static final int TYPE_DATE = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_OBJECT = 7;
    public static final int TYPE_LINKING_OBJECTS = 8;
    public static final int TYPE_DECIMAL128 = 11;
    public static final int TYPE_OBJECT_ID = 10;
    public static final int TYPE_REQUIRED = 0;
    public static final int TYPE_NULLABLE = 64;
    public static final int TYPE_ARRAY = 128;
    private long nativePtr;
    private static final long nativeFinalizerPtr = Property.nativeGetFinalizerPtr();

    Property(long nativePtr) {
        this.nativePtr = nativePtr;
        NativeContext.dummyContext.addReference(this);
    }

    static int convertFromRealmFieldType(RealmFieldType fieldType, boolean isRequired) {
        int type;
        switch (fieldType) {
            case OBJECT: {
                int type2 = 71;
                return type2;
            }
            case LIST: {
                int type3 = 135;
                return type3;
            }
            case LINKING_OBJECTS: {
                int type4 = 136;
                return type4;
            }
            case INTEGER: {
                type = 0;
                break;
            }
            case BOOLEAN: {
                type = 1;
                break;
            }
            case STRING: {
                type = 2;
                break;
            }
            case BINARY: {
                type = 3;
                break;
            }
            case DATE: {
                type = 4;
                break;
            }
            case FLOAT: {
                type = 5;
                break;
            }
            case DECIMAL128: {
                type = 11;
                break;
            }
            case OBJECT_ID: {
                type = 10;
                break;
            }
            case DOUBLE: {
                type = 6;
                break;
            }
            case INTEGER_LIST: {
                type = 128;
                break;
            }
            case BOOLEAN_LIST: {
                type = 129;
                break;
            }
            case STRING_LIST: {
                type = 130;
                break;
            }
            case BINARY_LIST: {
                type = 131;
                break;
            }
            case DATE_LIST: {
                type = 132;
                break;
            }
            case FLOAT_LIST: {
                type = 133;
                break;
            }
            case DECIMAL128_LIST: {
                type = 139;
                break;
            }
            case OBJECT_ID_LIST: {
                type = 138;
                break;
            }
            case DOUBLE_LIST: {
                type = 134;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.US, "Unsupported filed type: '%s'.", fieldType.name()));
            }
        }
        int requiredFlag = isRequired ? 0 : 64;
        return type | requiredFlag;
    }

    private static RealmFieldType convertToRealmFieldType(int propertyType) {
        switch (propertyType & 0xFFFFFFBF) {
            case 7: {
                return RealmFieldType.OBJECT;
            }
            case 135: {
                return RealmFieldType.LIST;
            }
            case 136: {
                return RealmFieldType.LINKING_OBJECTS;
            }
            case 0: {
                return RealmFieldType.INTEGER;
            }
            case 1: {
                return RealmFieldType.BOOLEAN;
            }
            case 2: {
                return RealmFieldType.STRING;
            }
            case 3: {
                return RealmFieldType.BINARY;
            }
            case 4: {
                return RealmFieldType.DATE;
            }
            case 5: {
                return RealmFieldType.FLOAT;
            }
            case 6: {
                return RealmFieldType.DOUBLE;
            }
            case 11: {
                return RealmFieldType.DECIMAL128;
            }
            case 10: {
                return RealmFieldType.OBJECT_ID;
            }
            case 128: {
                return RealmFieldType.INTEGER_LIST;
            }
            case 129: {
                return RealmFieldType.BOOLEAN_LIST;
            }
            case 130: {
                return RealmFieldType.STRING_LIST;
            }
            case 131: {
                return RealmFieldType.BINARY_LIST;
            }
            case 132: {
                return RealmFieldType.DATE_LIST;
            }
            case 133: {
                return RealmFieldType.FLOAT_LIST;
            }
            case 134: {
                return RealmFieldType.DOUBLE_LIST;
            }
            case 139: {
                return RealmFieldType.DECIMAL128_LIST;
            }
            case 138: {
                return RealmFieldType.OBJECT_ID_LIST;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, "Unsupported property type: '%d'", propertyType));
    }

    public RealmFieldType getType() {
        return Property.convertToRealmFieldType(Property.nativeGetType(this.nativePtr));
    }

    public String getLinkedObjectName() {
        return Property.nativeGetLinkedObjectName(this.nativePtr);
    }

    public long getColumnKey() {
        return Property.nativeGetColumnKey(this.nativePtr);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    private static native long nativeGetFinalizerPtr();

    static native long nativeCreatePersistedProperty(String var0, String var1, int var2, boolean var3, boolean var4);

    static native long nativeCreatePersistedLinkProperty(String var0, String var1, int var2, String var3);

    static native long nativeCreateComputedLinkProperty(String var0, String var1, String var2);

    private static native int nativeGetType(long var0);

    private static native long nativeGetColumnKey(long var0);

    private static native String nativeGetLinkedObjectName(long var0);
}

