/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.Property;
import javax.annotation.Nullable;

public class OsObjectSchemaInfo
implements NativeObject {
    private long nativePtr;
    private static final long nativeFinalizerPtr = OsObjectSchemaInfo.nativeGetFinalizerPtr();

    private OsObjectSchemaInfo(String publicClassName, String className, boolean embedded) {
        this(OsObjectSchemaInfo.nativeCreateRealmObjectSchema(publicClassName, className, embedded));
    }

    OsObjectSchemaInfo(long nativePtr) {
        this.nativePtr = nativePtr;
        NativeContext.dummyContext.addReference(this);
    }

    public String getClassName() {
        return OsObjectSchemaInfo.nativeGetClassName(this.nativePtr);
    }

    public Property getProperty(String propertyName) {
        return new Property(OsObjectSchemaInfo.nativeGetProperty(this.nativePtr, propertyName));
    }

    @Nullable
    public Property getPrimaryKeyProperty() {
        long propertyPtr = OsObjectSchemaInfo.nativeGetPrimaryKeyProperty(this.nativePtr);
        return propertyPtr == 0L ? null : new Property(OsObjectSchemaInfo.nativeGetPrimaryKeyProperty(this.nativePtr));
    }

    public boolean isEmbedded() {
        return OsObjectSchemaInfo.nativeIsEmbedded(this.nativePtr);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    private static native long nativeCreateRealmObjectSchema(String var0, String var1, boolean var2);

    private static native long nativeGetFinalizerPtr();

    private static native void nativeAddProperties(long var0, long[] var2, long[] var3);

    private static native String nativeGetClassName(long var0);

    private static native long nativeGetProperty(long var0, String var2);

    private static native long nativeGetPrimaryKeyProperty(long var0);

    private static native boolean nativeIsEmbedded(long var0);

    public static class Builder {
        private final String internalClassName;
        private final String publicClassName;
        private final long[] persistedPropertyPtrArray;
        private final boolean embedded;
        private int persistedPropertyPtrCurPos = 0;
        private final long[] computedPropertyPtrArray;
        private int computedPropertyPtrCurPos = 0;

        public Builder(String internalClassName, boolean embedded, int persistedPropertyCapacity, int computedPropertyCapacity) {
            this.publicClassName = "";
            this.internalClassName = internalClassName;
            this.embedded = embedded;
            this.persistedPropertyPtrArray = new long[persistedPropertyCapacity];
            this.computedPropertyPtrArray = new long[computedPropertyCapacity];
        }

        public Builder(String publicClassName, String internalClassName, boolean embedded, int persistedPropertyCapacity, int computedPropertyCapacity) {
            this.publicClassName = publicClassName;
            this.internalClassName = internalClassName;
            this.embedded = embedded;
            this.persistedPropertyPtrArray = new long[persistedPropertyCapacity];
            this.computedPropertyPtrArray = new long[computedPropertyCapacity];
        }

        public Builder addPersistedProperty(String publicName, String internalName, RealmFieldType type, boolean isPrimaryKey, boolean isIndexed, boolean isRequired) {
            long propertyPtr;
            this.persistedPropertyPtrArray[this.persistedPropertyPtrCurPos] = propertyPtr = Property.nativeCreatePersistedProperty(internalName, publicName, Property.convertFromRealmFieldType(type, isRequired), isPrimaryKey, isIndexed);
            ++this.persistedPropertyPtrCurPos;
            return this;
        }

        public Builder addPersistedValueListProperty(String publicName, String internalName, RealmFieldType type, boolean isRequired) {
            long propertyPtr;
            this.persistedPropertyPtrArray[this.persistedPropertyPtrCurPos] = propertyPtr = Property.nativeCreatePersistedProperty(internalName, publicName, Property.convertFromRealmFieldType(type, isRequired), false, false);
            ++this.persistedPropertyPtrCurPos;
            return this;
        }

        public Builder addPersistedLinkProperty(String publicName, String internalName, RealmFieldType type, String linkedClassName) {
            long propertyPtr;
            this.persistedPropertyPtrArray[this.persistedPropertyPtrCurPos] = propertyPtr = Property.nativeCreatePersistedLinkProperty(internalName, publicName, Property.convertFromRealmFieldType(type, false), linkedClassName);
            ++this.persistedPropertyPtrCurPos;
            return this;
        }

        public Builder addComputedLinkProperty(String name, String sourceClass, String sourceClassName) {
            long propertyPtr;
            this.computedPropertyPtrArray[this.computedPropertyPtrCurPos] = propertyPtr = Property.nativeCreateComputedLinkProperty(name, sourceClass, sourceClassName);
            ++this.computedPropertyPtrCurPos;
            return this;
        }

        public OsObjectSchemaInfo build() {
            if (this.persistedPropertyPtrCurPos == -1 || this.computedPropertyPtrCurPos == -1) {
                throw new IllegalStateException("'OsObjectSchemaInfo.build()' has been called before on this object.");
            }
            OsObjectSchemaInfo info = new OsObjectSchemaInfo(this.publicClassName, this.internalClassName, this.embedded);
            OsObjectSchemaInfo.nativeAddProperties(info.nativePtr, this.persistedPropertyPtrArray, this.computedPropertyPtrArray);
            this.persistedPropertyPtrCurPos = -1;
            this.computedPropertyPtrCurPos = -1;
            return info;
        }
    }
}

