/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.RealmFieldType;
import io.realm.Sort;
import io.realm.internal.Keep;
import io.realm.internal.Table;
import io.realm.internal.fields.FieldDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

@Keep
public class QueryDescriptor {
    public static final Set<RealmFieldType> SORT_VALID_FIELD_TYPES = Collections.unmodifiableSet(new HashSet<RealmFieldType>(Arrays.asList(RealmFieldType.BOOLEAN, RealmFieldType.INTEGER, RealmFieldType.FLOAT, RealmFieldType.DOUBLE, RealmFieldType.STRING, RealmFieldType.DATE, RealmFieldType.DECIMAL128, RealmFieldType.OBJECT_ID)));
    public static final Set<RealmFieldType> DISTINCT_VALID_FIELD_TYPES = Collections.unmodifiableSet(new HashSet<RealmFieldType>(Arrays.asList(RealmFieldType.BOOLEAN, RealmFieldType.INTEGER, RealmFieldType.STRING, RealmFieldType.BINARY, RealmFieldType.DATE, RealmFieldType.FLOAT, RealmFieldType.DOUBLE, RealmFieldType.DECIMAL128, RealmFieldType.OBJECT_ID, RealmFieldType.OBJECT, RealmFieldType.LINKING_OBJECTS)));
    public static final Set<RealmFieldType> DISTINCT_VALID_LINK_FIELD_TYPES = Collections.unmodifiableSet(new HashSet<RealmFieldType>(Arrays.asList(RealmFieldType.OBJECT, RealmFieldType.LINKING_OBJECTS)));
    private final Table table;
    private final long[][] columnKeys;
    private final boolean[] ascendings;

    public static QueryDescriptor getInstanceForSort(FieldDescriptor.SchemaProxy proxy, Table table, String fieldDescription, Sort sortOrder) {
        return QueryDescriptor.getInstanceForSort(proxy, table, new String[]{fieldDescription}, new Sort[]{sortOrder});
    }

    public static QueryDescriptor getInstanceForSort(FieldDescriptor.SchemaProxy proxy, Table table, String[] fieldDescriptions, Sort[] sortOrders) {
        if (sortOrders == null || sortOrders.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sort order.");
        }
        if (fieldDescriptions.length != sortOrders.length) {
            throw new IllegalArgumentException("Number of fields and sort orders do not match.");
        }
        return QueryDescriptor.getInstance(proxy, table, fieldDescriptions, sortOrders, FieldDescriptor.OBJECT_LINK_FIELD_TYPE, SORT_VALID_FIELD_TYPES, "Sort is not supported");
    }

    public static QueryDescriptor getInstanceForDistinct(FieldDescriptor.SchemaProxy proxy, Table table, String fieldDescription) {
        return QueryDescriptor.getInstanceForDistinct(proxy, table, new String[]{fieldDescription});
    }

    public static QueryDescriptor getInstanceForDistinct(FieldDescriptor.SchemaProxy proxy, Table table, String[] fieldDescriptions) {
        return QueryDescriptor.getInstance(proxy, table, fieldDescriptions, null, DISTINCT_VALID_LINK_FIELD_TYPES, DISTINCT_VALID_FIELD_TYPES, "Distinct is not supported");
    }

    private static QueryDescriptor getInstance(FieldDescriptor.SchemaProxy proxy, Table table, String[] fieldDescriptions, @Nullable Sort[] sortOrders, Set<RealmFieldType> legalInternalTypes, Set<RealmFieldType> legalTerminalTypes, String message) {
        if (fieldDescriptions == null || fieldDescriptions.length == 0) {
            throw new IllegalArgumentException("You must provide at least one field name.");
        }
        long[][] columnKeys = new long[fieldDescriptions.length][];
        for (int i = 0; i < fieldDescriptions.length; ++i) {
            FieldDescriptor descriptor = FieldDescriptor.createFieldDescriptor(proxy, table, fieldDescriptions[i], legalInternalTypes, null);
            QueryDescriptor.checkFieldType(descriptor, legalTerminalTypes, message, fieldDescriptions[i]);
            columnKeys[i] = descriptor.getColumnKeys();
        }
        return new QueryDescriptor(table, columnKeys, sortOrders);
    }

    public static QueryDescriptor getTestInstance(Table table, long[] columnIndices) {
        return new QueryDescriptor(table, new long[][]{columnIndices}, null);
    }

    private static void checkFieldType(FieldDescriptor descriptor, Set<RealmFieldType> legalTerminalTypes, String message, String fieldDescriptions) {
        if (!legalTerminalTypes.contains((Object)descriptor.getFinalColumnType())) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s on '%s' field '%s' in '%s'.", new Object[]{message, descriptor.getFinalColumnType(), descriptor.getFinalColumnName(), fieldDescriptions}));
        }
    }

    private QueryDescriptor(Table table, long[][] columnKeys, @Nullable Sort[] sortOrders) {
        this.table = table;
        this.columnKeys = columnKeys;
        if (sortOrders != null) {
            this.ascendings = new boolean[sortOrders.length];
            for (int i = 0; i < sortOrders.length; ++i) {
                this.ascendings[i] = sortOrders[i].getValue();
            }
        } else {
            this.ascendings = null;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public long[][] getColumnKeys() {
        return this.columnKeys;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public boolean[] getAscendings() {
        return this.ascendings;
    }

    private long getTablePtr() {
        return this.table.getNativePtr();
    }
}

