/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class FloatListOperator
extends ManagedListOperator<Float> {
    FloatListOperator(BaseRealm realm, OsList osList, Class<Float> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public Float get(int index) {
        return (Float)this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.Number", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addFloat(((Number)value).floatValue());
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertFloat(index, ((Number)value).floatValue());
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setFloat(index, ((Number)value).floatValue());
    }
}

