/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.SelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.RealmObjectProxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

class LinkSelectorForMap<K, V extends RealmModel>
extends SelectorForMap<K, V> {
    LinkSelectorForMap(BaseRealm baseRealm, OsMap osMap, Class<K> keyClass, Class<V> valueClass) {
        super(baseRealm, osMap, keyClass, valueClass);
    }

    @Override
    public V getRealmModel(BaseRealm baseRealm, long realmModelKey) {
        return (V)baseRealm.get(this.valueClass, null, realmModelKey);
    }

    @Override
    public V putRealmModel(BaseRealm baseRealm, OsMap osMap, K key, @Nullable V value) {
        long rowModelKey = osMap.getModelRowKey(key);
        if (value == null) {
            osMap.put(key, null);
        } else {
            boolean isEmbedded = baseRealm.getSchema().getSchemaForClass(this.valueClass).isEmbedded();
            if (isEmbedded) {
                long objKey = osMap.createAndPutEmbeddedObject(key);
                CollectionUtils.updateEmbeddedObject((Realm)baseRealm, value, objKey);
            } else {
                boolean copyObject = CollectionUtils.checkCanObjectBeCopied(baseRealm, value, this.valueClass.getSimpleName(), "dictionary");
                RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? CollectionUtils.copyToRealm(baseRealm, value) : value);
                osMap.putRow(key, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
            }
        }
        if (rowModelKey == -1L) {
            return null;
        }
        return (V)baseRealm.get(this.valueClass, rowModelKey, false, new ArrayList<String>());
    }

    @Override
    public Map.Entry<K, V> getModelEntry(BaseRealm baseRealm, long objRow, K key) {
        Object realmModel = baseRealm.get(this.valueClass, null, objRow);
        return new AbstractMap.SimpleImmutableEntry(key, realmModel);
    }
}

