/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import io.realm.ImportFlag;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.internal.OsList;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ProxyUtils {
    ProxyUtils() {
    }

    static <E> void setRealmListWithJsonObject(Realm realm, RealmList<E> realmList, JSONObject jsonObject, String fieldName, boolean update) throws JSONException {
        if (!jsonObject.has(fieldName)) {
            return;
        }
        OsList osList = realmList.getOsList();
        if (jsonObject.isNull(fieldName)) {
            osList.removeAll();
            return;
        }
        JSONArray jsonArray = jsonObject.getJSONArray(fieldName);
        osList.removeAll();
        int arraySize = jsonArray.length();
        if (realmList.clazz == Boolean.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addBoolean(jsonArray.getBoolean(i));
            }
        } else if (realmList.clazz == Float.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addFloat((float)jsonArray.getDouble(i));
            }
        } else if (realmList.clazz == Double.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addDouble(jsonArray.getDouble(i));
            }
        } else if (realmList.clazz == String.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addString(jsonArray.getString(i));
            }
        } else if (realmList.clazz == byte[].class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addBinary(JsonUtils.stringToBytes(jsonArray.getString(i)));
            }
        } else if (realmList.clazz == Date.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object timestamp = jsonArray.get(i);
                if (timestamp instanceof String) {
                    osList.addDate(JsonUtils.stringToDate((String)timestamp));
                    continue;
                }
                osList.addDate(new Date(jsonArray.getLong(i)));
            }
        } else if (realmList.clazz == ObjectId.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object id = jsonArray.get(i);
                if (id instanceof String) {
                    osList.addObjectId(new ObjectId((String)id));
                    continue;
                }
                osList.addObjectId((ObjectId)id);
            }
        } else if (realmList.clazz == Decimal128.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object decimal = jsonArray.get(i);
                if (decimal instanceof Decimal128) {
                    osList.addDecimal128((Decimal128)decimal);
                    continue;
                }
                if (decimal instanceof String) {
                    osList.addDecimal128(Decimal128.parse((String)((String)decimal)));
                    continue;
                }
                if (decimal instanceof Integer) {
                    osList.addDecimal128(new Decimal128((long)((Integer)decimal).intValue()));
                    continue;
                }
                if (decimal instanceof Long) {
                    osList.addDecimal128(new Decimal128(((Long)decimal).longValue()));
                    continue;
                }
                if (decimal instanceof Double) {
                    osList.addDecimal128(new Decimal128(new BigDecimal((Double)decimal)));
                    continue;
                }
                osList.addDecimal128((Decimal128)decimal);
            }
        } else if (realmList.clazz == UUID.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object uuid = jsonArray.get(i);
                if (uuid instanceof UUID) {
                    osList.addUUID((UUID)uuid);
                    continue;
                }
                osList.addUUID(UUID.fromString((String)uuid));
            }
        } else if (realmList.clazz == RealmAny.class) {
            for (int i = 0; i < arraySize; ++i) {
                RealmAny realmAny;
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                Object value = jsonArray.get(i);
                if (value instanceof String) {
                    realmAny = RealmAny.valueOf((String)value);
                } else if (value instanceof Integer) {
                    realmAny = RealmAny.valueOf((Integer)value);
                } else if (value instanceof Long) {
                    realmAny = RealmAny.valueOf((Long)value);
                } else if (value instanceof Double) {
                    realmAny = RealmAny.valueOf((Double)value);
                } else if (value instanceof Boolean) {
                    realmAny = RealmAny.valueOf((Boolean)value);
                } else if (value instanceof RealmAny) {
                    realmAny = (RealmAny)value;
                    realmAny = ProxyUtils.copyOrUpdate(realmAny, realm, update, new HashMap<RealmModel, RealmObjectProxy>(), new HashSet<ImportFlag>());
                } else {
                    throw new IllegalArgumentException(String.format("Unsupported JSON type: %s", value.getClass().getSimpleName()));
                }
                osList.addRealmAny(realmAny.getNativePtr());
            }
        } else if (realmList.clazz == Long.class || realmList.clazz == Integer.class || realmList.clazz == Short.class || realmList.clazz == Byte.class) {
            for (int i = 0; i < arraySize; ++i) {
                if (jsonArray.isNull(i)) {
                    osList.addNull();
                    continue;
                }
                osList.addLong(jsonArray.getLong(i));
            }
        } else {
            ProxyUtils.throwWrongElementType(realmList.clazz);
        }
    }

    @TargetApi(value=11)
    static <E> RealmList<E> createRealmListWithJsonStream(Class<E> elementClass, JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == null) {
            jsonReader.skipValue();
            return null;
        }
        jsonReader.beginArray();
        RealmList<Object> realmList = new RealmList<Object>();
        if (elementClass == Boolean.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextBoolean());
            }
        } else if (elementClass == Float.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(Float.valueOf((float)jsonReader.nextDouble()));
            }
        } else if (elementClass == Double.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextDouble());
            }
        } else if (elementClass == String.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextString());
            }
        } else if (elementClass == byte[].class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(JsonUtils.stringToBytes(jsonReader.nextString()));
            }
        } else if (elementClass == Date.class) {
            while (jsonReader.hasNext()) {
                JsonToken token = jsonReader.peek();
                if (token == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                if (token == JsonToken.NUMBER) {
                    realmList.add(new Date(jsonReader.nextLong()));
                    continue;
                }
                realmList.add(JsonUtils.stringToDate(jsonReader.nextString()));
            }
        } else if (elementClass == Long.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(jsonReader.nextLong());
            }
        } else if (elementClass == Integer.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((int)jsonReader.nextLong());
            }
        } else if (elementClass == Short.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((short)jsonReader.nextLong());
            }
        } else if (elementClass == Byte.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add((byte)jsonReader.nextLong());
            }
        } else if (elementClass == ObjectId.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(new ObjectId(jsonReader.nextString()));
            }
        } else if (elementClass == Decimal128.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(Decimal128.parse((String)jsonReader.nextString()));
            }
        } else if (elementClass == UUID.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(UUID.fromString(jsonReader.nextString()));
            }
        } else if (elementClass == RealmAny.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(RealmAny.nullValue());
                    continue;
                }
                if (jsonReader.peek() == JsonToken.STRING) {
                    realmList.add(RealmAny.valueOf(jsonReader.nextString()));
                    continue;
                }
                if (jsonReader.peek() == JsonToken.NUMBER) {
                    String value = jsonReader.nextString();
                    if (value.contains(".")) {
                        realmList.add(RealmAny.valueOf(Double.parseDouble(value)));
                        continue;
                    }
                    realmList.add(RealmAny.valueOf(Long.parseLong(value)));
                    continue;
                }
                if (jsonReader.peek() != JsonToken.BOOLEAN) continue;
                realmList.add(RealmAny.valueOf(jsonReader.nextBoolean()));
            }
        } else if (elementClass == ObjectId.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(new ObjectId(jsonReader.nextString()));
            }
        } else if (elementClass == Decimal128.class) {
            while (jsonReader.hasNext()) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.skipValue();
                    realmList.add(null);
                    continue;
                }
                realmList.add(Decimal128.parse((String)jsonReader.nextString()));
            }
        } else {
            ProxyUtils.throwWrongElementType(elementClass);
        }
        jsonReader.endArray();
        return realmList;
    }

    private static void throwWrongElementType(@Nullable Class clazz) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Element type '%s' is not handled.", clazz));
    }

    @Nullable
    static <T extends RealmModel> RealmAny copyToRealmIfNeeded(ProxyState<T> proxyState, @Nullable RealmAny value) {
        Realm realm = (Realm)proxyState.getRealm$realm();
        if (value == null) {
            return RealmAny.nullValue();
        }
        if (value.getType() == RealmAny.Type.OBJECT) {
            RealmModel realmAnyRealmModel = value.asRealmModel(RealmModel.class);
            if (realm.getSchema().getSchemaForClass(realmAnyRealmModel.getClass()).isEmbedded()) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmAny.");
            }
            if (!RealmObject.isManaged(realmAnyRealmModel)) {
                value = realm.hasPrimaryKey(realmAnyRealmModel.getClass()) ? RealmAny.valueOf(realm.copyToRealmOrUpdate(realmAnyRealmModel, new ImportFlag[0])) : RealmAny.valueOf(realm.copyToRealm(realmAnyRealmModel, new ImportFlag[0]));
            } else {
                proxyState.checkValidObject(realmAnyRealmModel);
            }
        }
        return value;
    }

    static RealmAny copyOrUpdate(RealmAny realmAny, @Nonnull Realm realm, boolean update, @Nonnull Map<RealmModel, RealmObjectProxy> cache, @Nonnull Set<ImportFlag> flags) {
        if (realmAny == null) {
            return RealmAny.nullValue();
        }
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> realmAnyValueClass = realmAny.getValueClass();
            Object realmAnyRealmObject = realmAny.asRealmModel(realmAnyValueClass);
            RealmObjectProxy cacheRealmObject = cache.get(realmAnyRealmObject);
            if (cacheRealmObject != null) {
                realmAny = RealmAny.valueOf(cacheRealmObject);
            } else {
                Object managedRealmAnyRealmObject = realm.getConfiguration().getSchemaMediator().copyOrUpdate(realm, realmAnyRealmObject, update, cache, flags);
                realmAny = RealmAny.valueOf(managedRealmAnyRealmObject);
            }
        }
        return realmAny;
    }

    static RealmAny insert(RealmAny realmAny, @Nonnull Realm realm, @Nonnull Map<RealmModel, Long> cache) {
        if (realmAny == null) {
            return RealmAny.nullValue();
        }
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> realmAnyValueClass = realmAny.getValueClass();
            Object realmAnyRealmObject = realmAny.asRealmModel(realmAnyValueClass);
            Long cacheRealmObject = cache.get(realmAnyRealmObject);
            if (cacheRealmObject != null) {
                realmAny = RealmAny.valueOf(cacheRealmObject);
            } else {
                long index = realm.getConfiguration().getSchemaMediator().insert(realm, (RealmModel)realmAnyRealmObject, cache);
                Object realmModel = realm.get(realmAnyValueClass, null, index);
                realmAny = RealmAny.valueOf(realmModel);
            }
        }
        return realmAny;
    }

    static RealmAny insertOrUpdate(RealmAny realmAny, @Nonnull Realm realm, @Nonnull Map<RealmModel, Long> cache) {
        if (realmAny == null) {
            return RealmAny.nullValue();
        }
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> realmAnyValueClass = realmAny.getValueClass();
            Object realmAnyRealmObject = realmAny.asRealmModel(realmAnyValueClass);
            Long cacheRealmObject = cache.get(realmAnyRealmObject);
            if (cacheRealmObject != null) {
                realmAny = RealmAny.valueOf(cacheRealmObject);
            } else {
                long index = realm.getConfiguration().getSchemaMediator().insertOrUpdate(realm, (RealmModel)realmAnyRealmObject, cache);
                realmAny = RealmAny.valueOf(realm.get(realmAnyValueClass, null, index));
            }
        }
        return realmAny;
    }

    static RealmAny createDetachedCopy(RealmAny realmAny, @Nonnull Realm realm, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        if (currentDepth > maxDepth || realmAny == null) {
            return RealmAny.nullValue();
        }
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> realmAnyValueClass = realmAny.getValueClass();
            Object realmAnyRealmObject = realmAny.asRealmModel(realmAnyValueClass);
            Object detachedCopy = realm.getConfiguration().getSchemaMediator().createDetachedCopy(realmAnyRealmObject, maxDepth - 1, cache);
            realmAny = RealmAny.valueOf(detachedCopy);
        }
        return realmAny;
    }

    static RealmAny createOrUpdateUsingJsonObject(RealmAny realmAny, @Nonnull Realm realm, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        if (currentDepth > maxDepth || realmAny == null) {
            return RealmAny.nullValue();
        }
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> realmAnyValueClass = realmAny.getValueClass();
            Object realmAnyRealmObject = realmAny.asRealmModel(realmAnyValueClass);
            Object detachedCopy = realm.getConfiguration().getSchemaMediator().createDetachedCopy(realmAnyRealmObject, maxDepth - 1, cache);
            realmAny = RealmAny.valueOf(detachedCopy);
        }
        return realmAny;
    }
}

