/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;

class UUIDOperator
extends SetValueOperator<UUID> {
    UUIDOperator(BaseRealm baseRealm, OsSet osSet, Class<UUID> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(@Nullable UUID value) {
        return this.osSet.add(value);
    }

    @Override
    boolean containsInternal(@Nullable Object o) {
        UUID value = o == null ? null : (UUID)o;
        return this.osSet.contains(value);
    }

    @Override
    boolean removeInternal(@Nullable Object o) {
        return this.osSet.remove((UUID)o);
    }

    @Override
    boolean containsAllInternal(Collection<?> c) {
        Collection<?> uuidCollection = c;
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newUUIDCollection(uuidCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends UUID> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newUUIDCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newUUIDCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newUUIDCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }
}

