/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import io.realm.ImportFlag;
import io.realm.MutableRealmInteger;
import io.realm.RealmAny;
import io.realm.RealmAnyNativeFunctionsImpl;
import io.realm.RealmDictionary;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmSet;
import io.realm.internal.NativeContext;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmAnyNativeFunctions;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import java.io.Closeable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class OsObjectBuilder
implements Closeable {
    private final Table table;
    private final long sharedRealmPtr;
    private final long builderPtr;
    private final long tablePtr;
    private final NativeContext context;
    private static ItemCallback<? extends RealmModel> objectItemCallback = new ItemCallback<RealmModel>(){

        @Override
        public void handleItem(long containerPtr, RealmModel item) {
            RealmObjectProxy proxyItem = (RealmObjectProxy)item;
            OsObjectBuilder.nativeAddIntegerListItem(containerPtr, ((UncheckedRow)proxyItem.realmGet$proxyState().getRow$realm()).getNativePtr());
        }
    };
    private static ItemCallback<String> stringItemCallback = new ItemCallback<String>(){

        @Override
        public void handleItem(long containerPtr, String item) {
            OsObjectBuilder.nativeAddStringListItem(containerPtr, item);
        }
    };
    private static ItemCallback<Byte> byteItemCallback = new ItemCallback<Byte>(){

        @Override
        public void handleItem(long containerPtr, Byte item) {
            OsObjectBuilder.nativeAddIntegerListItem(containerPtr, item.longValue());
        }
    };
    private static ItemCallback<Short> shortItemCallback = new ItemCallback<Short>(){

        @Override
        public void handleItem(long containerPtr, Short item) {
            OsObjectBuilder.nativeAddIntegerListItem(containerPtr, item.shortValue());
        }
    };
    private static ItemCallback<Integer> integerItemCallback = new ItemCallback<Integer>(){

        @Override
        public void handleItem(long containerPtr, Integer item) {
            OsObjectBuilder.nativeAddIntegerListItem(containerPtr, item.intValue());
        }
    };
    private static ItemCallback<Long> longItemCallback = new ItemCallback<Long>(){

        @Override
        public void handleItem(long containerPtr, Long item) {
            OsObjectBuilder.nativeAddIntegerListItem(containerPtr, item);
        }
    };
    private static ItemCallback<Boolean> booleanItemCallback = new ItemCallback<Boolean>(){

        @Override
        public void handleItem(long containerPtr, Boolean item) {
            OsObjectBuilder.nativeAddBooleanListItem(containerPtr, item);
        }
    };
    private static ItemCallback<Float> floatItemCallback = new ItemCallback<Float>(){

        @Override
        public void handleItem(long containerPtr, Float item) {
            OsObjectBuilder.nativeAddFloatListItem(containerPtr, item.floatValue());
        }
    };
    private static ItemCallback<Double> doubleItemCallback = new ItemCallback<Double>(){

        @Override
        public void handleItem(long containerPtr, Double item) {
            OsObjectBuilder.nativeAddDoubleListItem(containerPtr, item);
        }
    };
    private static ItemCallback<Date> dateItemCallback = new ItemCallback<Date>(){

        @Override
        public void handleItem(long containerPtr, Date item) {
            OsObjectBuilder.nativeAddDateListItem(containerPtr, item.getTime());
        }
    };
    private static ItemCallback<byte[]> byteArrayItemCallback = new ItemCallback<byte[]>(){

        @Override
        public void handleItem(long containerPtr, byte[] item) {
            OsObjectBuilder.nativeAddByteArrayListItem(containerPtr, item);
        }
    };
    private static ItemCallback<MutableRealmInteger> mutableRealmIntegerItemCallback = new ItemCallback<MutableRealmInteger>(){

        @Override
        public void handleItem(long containerPtr, MutableRealmInteger item) {
            Long value = item.get();
            if (value == null) {
                OsObjectBuilder.nativeAddNullListItem(containerPtr);
            } else {
                OsObjectBuilder.nativeAddIntegerListItem(containerPtr, value);
            }
        }
    };
    private static ItemCallback<Decimal128> decimal128ItemCallback = new ItemCallback<Decimal128>(){

        @Override
        public void handleItem(long containerPtr, Decimal128 item) {
            OsObjectBuilder.nativeAddDecimal128ListItem(containerPtr, item.getLow(), item.getHigh());
        }
    };
    private static ItemCallback<ObjectId> objectIdItemCallback = new ItemCallback<ObjectId>(){

        @Override
        public void handleItem(long containerPtr, ObjectId item) {
            OsObjectBuilder.nativeAddObjectIdListItem(containerPtr, item.toString());
        }
    };
    private static ItemCallback<UUID> uuidItemCallback = new ItemCallback<UUID>(){

        @Override
        public void handleItem(long containerPtr, UUID item) {
            OsObjectBuilder.nativeAddUUIDListItem(containerPtr, item.toString());
        }
    };
    private static ItemCallback<Map.Entry<String, Boolean>> booleanMapItemCallback = new ItemCallback<Map.Entry<String, Boolean>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Boolean> item) {
            OsObjectBuilder.nativeAddBooleanDictionaryEntry(containerPtr, item.getKey(), item.getValue());
        }
    };
    private static ItemCallback<Map.Entry<String, String>> stringMapItemCallback = new ItemCallback<Map.Entry<String, String>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, String> item) {
            OsObjectBuilder.nativeAddStringDictionaryEntry(containerPtr, item.getKey(), item.getValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Integer>> integerMapItemCallback = new ItemCallback<Map.Entry<String, Integer>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Integer> item) {
            OsObjectBuilder.nativeAddIntegerDictionaryEntry(containerPtr, item.getKey(), item.getValue().intValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Float>> floatMapItemCallback = new ItemCallback<Map.Entry<String, Float>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Float> item) {
            OsObjectBuilder.nativeAddFloatDictionaryEntry(containerPtr, item.getKey(), item.getValue().floatValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Long>> longMapItemCallback = new ItemCallback<Map.Entry<String, Long>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Long> item) {
            OsObjectBuilder.nativeAddIntegerDictionaryEntry(containerPtr, item.getKey(), item.getValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Short>> shortMapItemCallback = new ItemCallback<Map.Entry<String, Short>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Short> item) {
            OsObjectBuilder.nativeAddIntegerDictionaryEntry(containerPtr, item.getKey(), item.getValue().shortValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Byte>> byteMapItemCallback = new ItemCallback<Map.Entry<String, Byte>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Byte> item) {
            OsObjectBuilder.nativeAddIntegerDictionaryEntry(containerPtr, item.getKey(), item.getValue().byteValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Double>> doubleMapItemCallback = new ItemCallback<Map.Entry<String, Double>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Double> item) {
            OsObjectBuilder.nativeAddDoubleDictionaryEntry(containerPtr, item.getKey(), item.getValue());
        }
    };
    private static ItemCallback<Map.Entry<String, byte[]>> binaryMapItemCallback = new ItemCallback<Map.Entry<String, byte[]>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, byte[]> item) {
            OsObjectBuilder.nativeAddBinaryDictionaryEntry(containerPtr, item.getKey(), item.getValue());
        }
    };
    private static ItemCallback<Map.Entry<String, Date>> dateMapItemCallback = new ItemCallback<Map.Entry<String, Date>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Date> item) {
            OsObjectBuilder.nativeAddDateDictionaryEntry(containerPtr, item.getKey(), item.getValue().getTime());
        }
    };
    private static ItemCallback<Map.Entry<String, Decimal128>> decimal128MapItemCallback = new ItemCallback<Map.Entry<String, Decimal128>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, Decimal128> item) {
            OsObjectBuilder.nativeAddDecimal128DictionaryEntry(containerPtr, item.getKey(), item.getValue().getHigh(), item.getValue().getLow());
        }
    };
    private static ItemCallback<Map.Entry<String, ObjectId>> objectIdMapItemCallback = new ItemCallback<Map.Entry<String, ObjectId>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, ObjectId> item) {
            OsObjectBuilder.nativeAddObjectIdDictionaryEntry(containerPtr, item.getKey(), item.getValue().toString());
        }
    };
    private static ItemCallback<Map.Entry<String, UUID>> uuidMapItemCallback = new ItemCallback<Map.Entry<String, UUID>>(){

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, UUID> item) {
            OsObjectBuilder.nativeAddUUIDDictionaryEntry(containerPtr, item.getKey(), item.getValue().toString());
        }
    };
    private static ItemCallback<Map.Entry<String, RealmAny>> realmAnyMapItemCallback = new ItemCallback<Map.Entry<String, RealmAny>>(){
        private final RealmAnyNativeFunctions realmAnyNativeFunctions = new RealmAnyNativeFunctionsImpl();

        @Override
        public void handleItem(long containerPtr, Map.Entry<String, RealmAny> item) {
            this.realmAnyNativeFunctions.handleItem(containerPtr, item);
        }
    };
    private static ItemCallback<RealmAny> realmAnyItemCallback = new ItemCallback<RealmAny>(){
        private final RealmAnyNativeFunctions realmAnyNativeFunctions = new RealmAnyNativeFunctionsImpl();

        @Override
        public void handleItem(long listPtr, RealmAny realmAny) {
            this.realmAnyNativeFunctions.handleItem(listPtr, realmAny);
        }
    };
    private final boolean ignoreFieldsWithSameValue;
    private static ItemCallback<String> stringSetItemCallback = new ItemCallback<String>(){

        @Override
        public void handleItem(long containerPtr, String item) {
            OsObjectBuilder.nativeAddStringSetItem(containerPtr, item);
        }
    };
    private static ItemCallback<Boolean> booleanSetItemCallback = new ItemCallback<Boolean>(){

        @Override
        public void handleItem(long containerPtr, Boolean item) {
            OsObjectBuilder.nativeAddBooleanSetItem(containerPtr, item);
        }
    };
    private static ItemCallback<Integer> integerSetItemCallback = new ItemCallback<Integer>(){

        @Override
        public void handleItem(long containerPtr, Integer item) {
            OsObjectBuilder.nativeAddIntegerSetItem(containerPtr, item.intValue());
        }
    };
    private static ItemCallback<Long> longSetItemCallback = new ItemCallback<Long>(){

        @Override
        public void handleItem(long containerPtr, Long item) {
            OsObjectBuilder.nativeAddIntegerSetItem(containerPtr, item);
        }
    };
    private static ItemCallback<Short> shortSetItemCallback = new ItemCallback<Short>(){

        @Override
        public void handleItem(long containerPtr, Short item) {
            OsObjectBuilder.nativeAddIntegerSetItem(containerPtr, item.shortValue());
        }
    };
    private static ItemCallback<Byte> byteSetItemCallback = new ItemCallback<Byte>(){

        @Override
        public void handleItem(long containerPtr, Byte item) {
            OsObjectBuilder.nativeAddIntegerSetItem(containerPtr, item.byteValue());
        }
    };
    private static ItemCallback<Float> floatSetItemCallback = new ItemCallback<Float>(){

        @Override
        public void handleItem(long containerPtr, Float item) {
            OsObjectBuilder.nativeAddFloatSetItem(containerPtr, item.floatValue());
        }
    };
    private static ItemCallback<Double> doubleSetItemCallback = new ItemCallback<Double>(){

        @Override
        public void handleItem(long containerPtr, Double item) {
            OsObjectBuilder.nativeAddDoubleSetItem(containerPtr, item);
        }
    };
    private static ItemCallback<byte[]> binarySetItemCallback = new ItemCallback<byte[]>(){

        @Override
        public void handleItem(long containerPtr, byte[] item) {
            OsObjectBuilder.nativeAddByteArraySetItem(containerPtr, item);
        }
    };
    private static ItemCallback<Date> dateSetItemCallback = new ItemCallback<Date>(){

        @Override
        public void handleItem(long containerPtr, Date item) {
            OsObjectBuilder.nativeAddDateSetItem(containerPtr, item.getTime());
        }
    };
    private static ItemCallback<Decimal128> decimal128SetItemCallback = new ItemCallback<Decimal128>(){

        @Override
        public void handleItem(long containerPtr, Decimal128 item) {
            OsObjectBuilder.nativeAddDecimal128SetItem(containerPtr, item.getLow(), item.getHigh());
        }
    };
    private static ItemCallback<ObjectId> objectIdSetItemCallback = new ItemCallback<ObjectId>(){

        @Override
        public void handleItem(long containerPtr, ObjectId item) {
            OsObjectBuilder.nativeAddObjectIdSetItem(containerPtr, item.toString());
        }
    };
    private static ItemCallback<UUID> uuidSetItemCallback = new ItemCallback<UUID>(){

        @Override
        public void handleItem(long containerPtr, UUID item) {
            OsObjectBuilder.nativeAddUUIDSetItem(containerPtr, item.toString());
        }
    };
    private static ItemCallback<RealmAny> realmAnySetItemCallback = new ItemCallback<RealmAny>(){
        private final RealmAnyNativeFunctions realmAnyNativeFunctions = new RealmAnyNativeFunctionsImpl();

        @Override
        public void handleItem(long containerPtr, RealmAny item) {
            this.realmAnyNativeFunctions.handleItem(containerPtr, item);
        }
    };

    public OsObjectBuilder(Table table, Set<ImportFlag> flags) {
        OsSharedRealm sharedRealm = table.getSharedRealm();
        this.sharedRealmPtr = sharedRealm.getNativePtr();
        this.table = table;
        this.table.getColumnNames();
        this.tablePtr = table.getNativePtr();
        this.builderPtr = OsObjectBuilder.nativeCreateBuilder();
        this.context = sharedRealm.context;
        this.ignoreFieldsWithSameValue = flags.contains((Object)ImportFlag.CHECK_SAME_VALUES_BEFORE_SET);
    }

    public void addInteger(long columnKey, @Nullable Byte val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.byteValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Short val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.shortValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Integer val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.intValue());
        }
    }

    public void addInteger(long columnKey, @Nullable Long val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val);
        }
    }

    public void addMutableRealmInteger(long columnKey, @Nullable MutableRealmInteger val) {
        if (val == null || val.get() == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddInteger(this.builderPtr, columnKey, val.get());
        }
    }

    public void addRealmAny(long columnKey, long realmAnyPtr) {
        OsObjectBuilder.nativeAddRealmAny(this.builderPtr, columnKey, realmAnyPtr);
    }

    public void addString(long columnKey, @Nullable String val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddString(this.builderPtr, columnKey, val);
        }
    }

    public void addFloat(long columnKey, @Nullable Float val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddFloat(this.builderPtr, columnKey, val.floatValue());
        }
    }

    public void addDouble(long columnKey, @Nullable Double val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDouble(this.builderPtr, columnKey, val);
        }
    }

    public void addBoolean(long columnKey, @Nullable Boolean val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddBoolean(this.builderPtr, columnKey, val);
        }
    }

    public void addDate(long columnKey, @Nullable Date val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDate(this.builderPtr, columnKey, val.getTime());
        }
    }

    public void addByteArray(long columnKey, @Nullable byte[] val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddByteArray(this.builderPtr, columnKey, val);
        }
    }

    public void addDecimal128(long columnKey, @Nullable Decimal128 val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddDecimal128(this.builderPtr, columnKey, val.getLow(), val.getHigh());
        }
    }

    public void addObjectId(long columnKey, @Nullable ObjectId val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddObjectId(this.builderPtr, columnKey, val.toString());
        }
    }

    public void addUUID(long columnKey, @Nullable UUID val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            OsObjectBuilder.nativeAddUUID(this.builderPtr, columnKey, val.toString());
        }
    }

    public void addNull(long columnKey) {
        OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
    }

    public void addObject(long columnKey, @Nullable RealmModel val) {
        if (val == null) {
            OsObjectBuilder.nativeAddNull(this.builderPtr, columnKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)val;
            UncheckedRow row = (UncheckedRow)proxy.realmGet$proxyState().getRow$realm();
            OsObjectBuilder.nativeAddObject(this.builderPtr, columnKey, row.getNativePtr());
        }
    }

    private <T> void addListItem(long builderPtr, long columnKey, @Nullable List<T> list, ItemCallback<T> itemCallback) {
        if (list != null) {
            long listPtr = OsObjectBuilder.nativeStartList(list.size());
            boolean isNullable = columnKey == 0L || this.table.isColumnNullable(columnKey);
            for (int i = 0; i < list.size(); ++i) {
                T item = list.get(i);
                if (item == null) {
                    if (!isNullable) {
                        throw new IllegalArgumentException("This 'RealmList' is not nullable. A non-null value is expected.");
                    }
                    OsObjectBuilder.nativeAddNullListItem(listPtr);
                    continue;
                }
                itemCallback.handleItem(listPtr, item);
            }
            OsObjectBuilder.nativeStopList(builderPtr, columnKey, listPtr);
        } else {
            this.addEmptyList(columnKey);
        }
    }

    public <T extends RealmModel> void addObjectList(long columnKey, @Nullable RealmList<T> list) {
        if (list != null) {
            long[] rowPointers = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                RealmObjectProxy item = (RealmObjectProxy)list.get(i);
                if (item == null) {
                    throw new IllegalArgumentException("Null values are not allowed in RealmLists containing Realm models");
                }
                rowPointers[i] = ((UncheckedRow)item.realmGet$proxyState().getRow$realm()).getNativePtr();
            }
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnKey, rowPointers);
        } else {
            OsObjectBuilder.nativeAddObjectList(this.builderPtr, columnKey, new long[0]);
        }
    }

    public void addStringList(long columnKey, RealmList<String> list) {
        this.addListItem(this.builderPtr, columnKey, list, stringItemCallback);
    }

    public void addByteList(long columnKey, RealmList<Byte> list) {
        this.addListItem(this.builderPtr, columnKey, list, byteItemCallback);
    }

    public void addShortList(long columnKey, RealmList<Short> list) {
        this.addListItem(this.builderPtr, columnKey, list, shortItemCallback);
    }

    public void addIntegerList(long columnKey, RealmList<Integer> list) {
        this.addListItem(this.builderPtr, columnKey, list, integerItemCallback);
    }

    public void addLongList(long columnKey, RealmList<Long> list) {
        this.addListItem(this.builderPtr, columnKey, list, longItemCallback);
    }

    public void addBooleanList(long columnKey, RealmList<Boolean> list) {
        this.addListItem(this.builderPtr, columnKey, list, booleanItemCallback);
    }

    public void addFloatList(long columnKey, RealmList<Float> list) {
        this.addListItem(this.builderPtr, columnKey, list, floatItemCallback);
    }

    public void addDoubleList(long columnKey, RealmList<Double> list) {
        this.addListItem(this.builderPtr, columnKey, list, doubleItemCallback);
    }

    public void addDateList(long columnKey, RealmList<Date> list) {
        this.addListItem(this.builderPtr, columnKey, list, dateItemCallback);
    }

    public void addByteArrayList(long columnKey, RealmList<byte[]> list) {
        this.addListItem(this.builderPtr, columnKey, list, byteArrayItemCallback);
    }

    public void addMutableRealmIntegerList(long columnKey, RealmList<MutableRealmInteger> list) {
        this.addListItem(this.builderPtr, columnKey, list, mutableRealmIntegerItemCallback);
    }

    public void addDecimal128List(long columnKey, RealmList<Decimal128> list) {
        this.addListItem(this.builderPtr, columnKey, list, decimal128ItemCallback);
    }

    public void addObjectIdList(long columnKey, RealmList<ObjectId> list) {
        this.addListItem(this.builderPtr, columnKey, list, objectIdItemCallback);
    }

    public void addUUIDList(long columnKey, RealmList<UUID> list) {
        this.addListItem(this.builderPtr, columnKey, list, uuidItemCallback);
    }

    public void addRealmAnyList(long columnKey, RealmList<RealmAny> list) {
        this.addListItem(this.builderPtr, columnKey, list, realmAnyItemCallback);
    }

    private void addEmptyList(long columnKey) {
        long listPtr = OsObjectBuilder.nativeStartList(0L);
        OsObjectBuilder.nativeStopList(this.builderPtr, columnKey, listPtr);
    }

    public void addBooleanValueDictionary(long columnKey, RealmDictionary<Boolean> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, booleanMapItemCallback);
    }

    public void addIntegerValueDictionary(long columnKey, RealmDictionary<Integer> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, integerMapItemCallback);
    }

    public void addFloatValueDictionary(long columnKey, RealmDictionary<Float> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, floatMapItemCallback);
    }

    public void addLongValueDictionary(long columnKey, RealmDictionary<Long> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, longMapItemCallback);
    }

    public void addShortValueDictionary(long columnKey, RealmDictionary<Short> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, shortMapItemCallback);
    }

    public void addByteValueDictionary(long columnKey, RealmDictionary<Byte> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, byteMapItemCallback);
    }

    public void addDoubleValueDictionary(long columnKey, RealmDictionary<Double> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, doubleMapItemCallback);
    }

    public void addStringValueDictionary(long columnKey, RealmDictionary<String> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, stringMapItemCallback);
    }

    public void addDateValueDictionary(long columnKey, RealmDictionary<Date> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, dateMapItemCallback);
    }

    public void addDecimal128ValueDictionary(long columnKey, RealmDictionary<Decimal128> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, decimal128MapItemCallback);
    }

    public void addBinaryValueDictionary(long columnKey, RealmDictionary<byte[]> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, binaryMapItemCallback);
    }

    public void addObjectIdValueDictionary(long columnKey, RealmDictionary<ObjectId> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, objectIdMapItemCallback);
    }

    public void addUUIDValueDictionary(long columnKey, RealmDictionary<UUID> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, uuidMapItemCallback);
    }

    public void addRealmAnyValueDictionary(long columnKey, RealmDictionary<RealmAny> dictionary) {
        this.addDictionaryItem(this.builderPtr, columnKey, dictionary, realmAnyMapItemCallback);
    }

    public <T extends RealmModel> void addObjectDictionary(long columnKey, @Nullable RealmDictionary<T> dictionary) {
        if (dictionary != null) {
            long dictionaryPtr = OsObjectBuilder.nativeStartDictionary();
            for (Map.Entry entry : dictionary.entrySet()) {
                if (entry.getValue() == null) {
                    OsObjectBuilder.nativeAddNullDictionaryEntry(dictionaryPtr, (String)entry.getKey());
                    continue;
                }
                RealmObjectProxy realmObjectProxy = (RealmObjectProxy)entry.getValue();
                long objectPtr = ((UncheckedRow)realmObjectProxy.realmGet$proxyState().getRow$realm()).getNativePtr();
                OsObjectBuilder.nativeAddObjectDictionaryEntry(dictionaryPtr, (String)entry.getKey(), objectPtr);
            }
            OsObjectBuilder.nativeStopDictionary(this.builderPtr, columnKey, dictionaryPtr);
        } else {
            this.addEmptyDictionary(columnKey);
        }
    }

    private <T> void addDictionaryItem(long builderPtr, long columnKey, @Nullable RealmDictionary<T> dictionary, ItemCallback<Map.Entry<String, T>> mapItemCallback) {
        if (dictionary != null) {
            long dictionaryPtr = OsObjectBuilder.nativeStartDictionary();
            for (Map.Entry entry : dictionary.entrySet()) {
                if (entry.getValue() == null) {
                    OsObjectBuilder.nativeAddNullDictionaryEntry(dictionaryPtr, (String)entry.getKey());
                    continue;
                }
                mapItemCallback.handleItem(dictionaryPtr, entry);
            }
            OsObjectBuilder.nativeStopDictionary(builderPtr, columnKey, dictionaryPtr);
        } else {
            this.addEmptyDictionary(columnKey);
        }
    }

    private void addEmptyDictionary(long columnKey) {
        OsObjectBuilder.nativeStopDictionary(this.builderPtr, columnKey, OsObjectBuilder.nativeStartDictionary());
    }

    private static native long nativeStartSet(long var0);

    private static native void nativeStopSet(long var0, long var2, long var4);

    private static native void nativeAddNullSetItem(long var0);

    private static native void nativeAddStringSetItem(long var0, String var2);

    private static native void nativeAddBooleanSetItem(long var0, boolean var2);

    private static native void nativeAddIntegerSetItem(long var0, long var2);

    private static native void nativeAddFloatSetItem(long var0, float var2);

    private static native void nativeAddDoubleSetItem(long var0, double var2);

    private static native void nativeAddByteArraySetItem(long var0, byte[] var2);

    private static native void nativeAddDateSetItem(long var0, long var2);

    private static native void nativeAddDecimal128SetItem(long var0, long var2, long var4);

    private static native void nativeAddObjectIdSetItem(long var0, String var2);

    private static native void nativeAddUUIDSetItem(long var0, String var2);

    private void addEmptySet(long columnKey) {
        OsObjectBuilder.nativeStopSet(this.builderPtr, columnKey, OsObjectBuilder.nativeStartSet(0L));
    }

    public void addStringSet(long columnKey, RealmSet<String> set) {
        this.addSetItem(this.builderPtr, columnKey, set, stringSetItemCallback);
    }

    public void addBooleanSet(long columnKey, RealmSet<Boolean> set) {
        this.addSetItem(this.builderPtr, columnKey, set, booleanSetItemCallback);
    }

    public void addIntegerSet(long columnKey, RealmSet<Integer> set) {
        this.addSetItem(this.builderPtr, columnKey, set, integerSetItemCallback);
    }

    public void addLongSet(long columnKey, RealmSet<Long> set) {
        this.addSetItem(this.builderPtr, columnKey, set, longSetItemCallback);
    }

    public void addShortSet(long columnKey, RealmSet<Short> set) {
        this.addSetItem(this.builderPtr, columnKey, set, shortSetItemCallback);
    }

    public void addByteSet(long columnKey, RealmSet<Byte> set) {
        this.addSetItem(this.builderPtr, columnKey, set, byteSetItemCallback);
    }

    public void addFloatSet(long columnKey, RealmSet<Float> set) {
        this.addSetItem(this.builderPtr, columnKey, set, floatSetItemCallback);
    }

    public void addDoubleSet(long columnKey, RealmSet<Double> set) {
        this.addSetItem(this.builderPtr, columnKey, set, doubleSetItemCallback);
    }

    public void addBinarySet(long columnKey, RealmSet<byte[]> set) {
        this.addSetItem(this.builderPtr, columnKey, set, binarySetItemCallback);
    }

    public void addDateSet(long columnKey, RealmSet<Date> set) {
        this.addSetItem(this.builderPtr, columnKey, set, dateSetItemCallback);
    }

    public void addDecimal128Set(long columnKey, RealmSet<Decimal128> set) {
        this.addSetItem(this.builderPtr, columnKey, set, decimal128SetItemCallback);
    }

    public void addObjectIdSet(long columnKey, RealmSet<ObjectId> set) {
        this.addSetItem(this.builderPtr, columnKey, set, objectIdSetItemCallback);
    }

    public void addUUIDSet(long columnKey, RealmSet<UUID> set) {
        this.addSetItem(this.builderPtr, columnKey, set, uuidSetItemCallback);
    }

    public void addRealmAnySet(long columnKey, RealmSet<RealmAny> set) {
        this.addSetItem(this.builderPtr, columnKey, set, realmAnySetItemCallback);
    }

    public <T extends RealmModel> void addObjectSet(long columnKey, @Nullable RealmSet<T> set) {
        if (set != null) {
            long setPtr = OsObjectBuilder.nativeStartSet(set.size());
            for (RealmModel entry : set) {
                if (entry == null) {
                    throw new IllegalArgumentException("This 'RealmSet' is not nullable. A non-null value is expected.");
                }
                RealmObjectProxy realmObjectProxy = (RealmObjectProxy)entry;
                long objectPtr = ((UncheckedRow)realmObjectProxy.realmGet$proxyState().getRow$realm()).getNativePtr();
                OsObjectBuilder.nativeAddObjectListItem(setPtr, objectPtr);
            }
            OsObjectBuilder.nativeStopSet(this.builderPtr, columnKey, setPtr);
        } else {
            this.addEmptySet(columnKey);
        }
    }

    private <T> void addSetItem(long builderPtr, long columnKey, @Nullable Set<T> set, ItemCallback<T> itemCallback) {
        if (set != null) {
            long setPtr = OsObjectBuilder.nativeStartSet(set.size());
            boolean isNullable = columnKey == 0L || this.table.isColumnNullable(columnKey);
            for (T item : set) {
                if (item == null) {
                    if (!isNullable) {
                        throw new IllegalArgumentException("This 'RealmSet' is not nullable. A non-null value is expected.");
                    }
                    OsObjectBuilder.nativeAddNullSetItem(setPtr);
                    continue;
                }
                itemCallback.handleItem(setPtr, item);
            }
            OsObjectBuilder.nativeStopSet(builderPtr, columnKey, setPtr);
        } else {
            this.addEmptySet(columnKey);
        }
    }

    public void updateExistingTopLevelObject() {
        try {
            OsObjectBuilder.nativeCreateOrUpdateTopLevelObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, true, this.ignoreFieldsWithSameValue);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExistingEmbeddedObject(RealmObjectProxy embeddedObject) {
        try {
            long objKey = embeddedObject.realmGet$proxyState().getRow$realm().getObjectKey();
            OsObjectBuilder.nativeUpdateEmbeddedObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, objKey, this.ignoreFieldsWithSameValue);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UncheckedRow createNewObject() {
        UncheckedRow row;
        try {
            long rowPtr = OsObjectBuilder.nativeCreateOrUpdateTopLevelObject(this.sharedRealmPtr, this.tablePtr, this.builderPtr, false, false);
            row = new UncheckedRow(this.context, this.table, rowPtr);
        }
        finally {
            this.close();
        }
        return row;
    }

    public long getNativePtr() {
        return this.builderPtr;
    }

    @Override
    public void close() {
        OsObjectBuilder.nativeDestroyBuilder(this.builderPtr);
    }

    private static native long nativeCreateBuilder();

    private static native void nativeDestroyBuilder(long var0);

    private static native long nativeCreateOrUpdateTopLevelObject(long var0, long var2, long var4, boolean var6, boolean var7);

    private static native long nativeUpdateEmbeddedObject(long var0, long var2, long var4, long var6, boolean var8);

    private static native void nativeAddNull(long var0, long var2);

    private static native void nativeAddInteger(long var0, long var2, long var4);

    private static native void nativeAddString(long var0, long var2, String var4);

    private static native void nativeAddFloat(long var0, long var2, float var4);

    private static native void nativeAddDouble(long var0, long var2, double var4);

    private static native void nativeAddBoolean(long var0, long var2, boolean var4);

    private static native void nativeAddByteArray(long var0, long var2, byte[] var4);

    private static native void nativeAddDate(long var0, long var2, long var4);

    private static native void nativeAddObject(long var0, long var2, long var4);

    private static native void nativeAddDecimal128(long var0, long var2, long var4, long var6);

    private static native void nativeAddObjectId(long var0, long var2, String var4);

    private static native void nativeAddUUID(long var0, long var2, String var4);

    private static native void nativeAddRealmAny(long var0, long var2, long var4);

    private static native long nativeStartList(long var0);

    private static native void nativeStopList(long var0, long var2, long var4);

    private static native void nativeAddNullListItem(long var0);

    private static native void nativeAddIntegerListItem(long var0, long var2);

    private static native void nativeAddStringListItem(long var0, String var2);

    private static native void nativeAddFloatListItem(long var0, float var2);

    private static native void nativeAddDoubleListItem(long var0, double var2);

    private static native void nativeAddBooleanListItem(long var0, boolean var2);

    private static native void nativeAddByteArrayListItem(long var0, byte[] var2);

    private static native void nativeAddDateListItem(long var0, long var2);

    private static native void nativeAddDecimal128ListItem(long var0, long var2, long var4);

    private static native void nativeAddObjectIdListItem(long var0, String var2);

    private static native void nativeAddUUIDListItem(long var0, String var2);

    public static native void nativeAddRealmAnyListItem(long var0, long var2);

    private static native void nativeAddObjectListItem(long var0, long var2);

    private static native void nativeAddObjectList(long var0, long var2, long[] var4);

    private static native long nativeStartDictionary();

    private static native void nativeStopDictionary(long var0, long var2, long var4);

    private static native void nativeAddNullDictionaryEntry(long var0, String var2);

    private static native void nativeAddBooleanDictionaryEntry(long var0, String var2, boolean var3);

    private static native void nativeAddStringDictionaryEntry(long var0, String var2, String var3);

    private static native void nativeAddIntegerDictionaryEntry(long var0, String var2, long var3);

    private static native void nativeAddDoubleDictionaryEntry(long var0, String var2, double var3);

    private static native void nativeAddFloatDictionaryEntry(long var0, String var2, float var3);

    private static native void nativeAddBinaryDictionaryEntry(long var0, String var2, byte[] var3);

    private static native void nativeAddDateDictionaryEntry(long var0, String var2, long var3);

    private static native void nativeAddDecimal128DictionaryEntry(long var0, String var2, long var3, long var5);

    private static native void nativeAddObjectIdDictionaryEntry(long var0, String var2, String var3);

    private static native void nativeAddUUIDDictionaryEntry(long var0, String var2, String var3);

    private static native void nativeAddObjectDictionaryEntry(long var0, String var2, long var3);

    public static native void nativeAddRealmAnyDictionaryEntry(long var0, String var2, long var3);

    private static interface ItemCallback<T> {
        public void handleItem(long var1, T var3);
    }
}

