/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.FieldAttribute;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsResults;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.Date;
import java.util.Locale;

class MutableRealmObjectSchema
extends RealmObjectSchema {
    MutableRealmObjectSchema(BaseRealm realm, RealmSchema schema, Table table) {
        super(realm, schema, table, new RealmObjectSchema.DynamicColumnIndices(table));
    }

    @Override
    public RealmObjectSchema setClassName(String className) {
        this.realm.checkNotInSync();
        this.checkEmpty(className);
        String internalTableName = Table.getTableNameForClass(className);
        if (className.length() > Table.CLASS_NAME_MAX_LENGTH) {
            throw new IllegalArgumentException(String.format(Locale.US, "Class name is too long. Limit is %1$d characters: '%2$s' (%3$d)", Table.CLASS_NAME_MAX_LENGTH, className, className.length()));
        }
        if (this.realm.sharedRealm.hasTable(internalTableName)) {
            throw new IllegalArgumentException("Class already exists: " + className);
        }
        String oldTableName = this.table.getName();
        String oldClassName = this.table.getClassName();
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, oldClassName);
        if (pkField != null) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, oldClassName, null);
        }
        this.realm.sharedRealm.renameTable(oldTableName, internalTableName);
        if (pkField != null) {
            try {
                OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, className, pkField);
            }
            catch (Exception e) {
                this.realm.sharedRealm.renameTable(this.table.getName(), oldTableName);
                throw e;
            }
        }
        return this;
    }

    private void checkEmpty(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Null or empty class names are not allowed");
        }
    }

    @Override
    public RealmObjectSchema addField(String fieldName, Class<?> fieldType, FieldAttribute ... attributes) {
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_LIST_SIMPLE_FIELDS.get(fieldType);
        if (metadata == null) {
            if (SUPPORTED_LINKED_FIELDS.containsKey(fieldType)) {
                throw new IllegalArgumentException("Use addRealmObjectField() instead to add fields that link to other RealmObjects: " + fieldName);
            }
            if (RealmModel.class.isAssignableFrom(fieldType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "Use 'addRealmObjectField()' instead to add fields that link to other RealmObjects: %s(%s)", fieldName, fieldType));
            }
            throw new IllegalArgumentException(String.format(Locale.US, "Realm doesn't support this field type: %s(%s)", fieldName, fieldType));
        }
        if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.PRIMARY_KEY)) {
            this.checkAddPrimaryKeyForSync();
            this.checkForObjectStoreInvalidPrimaryKeyTypes(fieldName, fieldType);
        }
        this.checkNewFieldName(fieldName);
        boolean nullable = metadata.defaultNullable;
        if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.REQUIRED)) {
            nullable = false;
        }
        long columnKey = this.table.addColumn(metadata.fieldType, fieldName, nullable);
        try {
            this.addModifiers(fieldName, attributes);
        }
        catch (Exception e) {
            this.table.removeColumn(columnKey);
            throw e;
        }
        return this;
    }

    @Override
    public RealmObjectSchema addRealmObjectField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.OBJECT, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmListField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnLink(RealmFieldType.LIST, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmListField(String fieldName, Class<?> primitiveType) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_LIST_SIMPLE_FIELDS.get(primitiveType);
        if (metadata == null) {
            if (primitiveType.equals(RealmObjectSchema.class) || RealmModel.class.isAssignableFrom(primitiveType)) {
                throw new IllegalArgumentException("Use 'addRealmListField(String name, RealmObjectSchema schema)' instead to add lists that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format(Locale.US, "RealmList does not support lists with this type: %s(%s)", fieldName, primitiveType));
        }
        this.table.addColumn(metadata.collectionType, fieldName, metadata.defaultNullable);
        return this;
    }

    @Override
    public RealmObjectSchema addRealmDictionaryField(String fieldName, Class<?> primitiveType) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_DICTIONARY_SIMPLE_FIELDS.get(primitiveType);
        if (metadata == null) {
            if (primitiveType.equals(RealmObjectSchema.class) || RealmModel.class.isAssignableFrom(primitiveType)) {
                throw new IllegalArgumentException("Use 'addRealmDictionaryField(String name, RealmObjectSchema schema)' instead to add dictionaries that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format(Locale.US, "RealmDictionary does not support dictionaries with this type: %s(%s)", fieldName, primitiveType));
        }
        this.table.addColumn(metadata.collectionType, fieldName, metadata.defaultNullable);
        return this;
    }

    @Override
    public RealmObjectSchema addRealmDictionaryField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnDictionaryLink(RealmFieldType.STRING_TO_LINK_MAP, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmSetField(String fieldName, RealmObjectSchema objectSchema) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        this.table.addColumnSetLink(RealmFieldType.LINK_SET, fieldName, this.realm.sharedRealm.getTable(Table.getTableNameForClass(objectSchema.getClassName())));
        return this;
    }

    @Override
    public RealmObjectSchema addRealmSetField(String fieldName, Class<?> primitiveType) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
        RealmObjectSchema.FieldMetaData metadata = (RealmObjectSchema.FieldMetaData)SUPPORTED_SET_SIMPLE_FIELDS.get(primitiveType);
        if (metadata == null) {
            if (primitiveType.equals(RealmObjectSchema.class) || RealmModel.class.isAssignableFrom(primitiveType)) {
                throw new IllegalArgumentException("Use 'addRealmSetField(String name, RealmObjectSchema schema)' instead to add sets that link to other RealmObjects: " + fieldName);
            }
            throw new IllegalArgumentException(String.format(Locale.US, "RealmSet does not support sets with this type: %s(%s)", fieldName, primitiveType));
        }
        this.table.addColumn(metadata.collectionType, fieldName, metadata.defaultNullable);
        return this;
    }

    @Override
    public RealmObjectSchema removeField(String fieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        if (!this.hasField(fieldName)) {
            throw new IllegalStateException(fieldName + " does not exist.");
        }
        long columnKey = this.getColumnKey(fieldName);
        String className = this.getClassName();
        if (fieldName.equals(OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, className))) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, className, fieldName);
        }
        this.table.removeColumn(columnKey);
        return this;
    }

    @Override
    public RealmObjectSchema renameField(String currentFieldName, String newFieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(currentFieldName);
        this.checkFieldExists(currentFieldName);
        MutableRealmObjectSchema.checkLegalName(newFieldName);
        this.checkFieldNameIsAvailable(newFieldName);
        long columnKey = this.getColumnKey(currentFieldName);
        this.table.renameColumn(columnKey, newFieldName);
        return this;
    }

    @Override
    public RealmObjectSchema addIndex(String fieldName) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnKey = this.getColumnKey(fieldName);
        if (this.table.hasSearchIndex(columnKey)) {
            throw new IllegalStateException(fieldName + " already has an index.");
        }
        this.table.addSearchIndex(columnKey);
        return this;
    }

    @Override
    public RealmObjectSchema removeIndex(String fieldName) {
        this.realm.checkNotInSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        long columnKey = this.getColumnKey(fieldName);
        if (!this.table.hasSearchIndex(columnKey)) {
            throw new IllegalStateException("Field is not indexed: " + fieldName);
        }
        this.table.removeSearchIndex(columnKey);
        return this;
    }

    @Override
    public RealmObjectSchema addPrimaryKey(String fieldName) {
        this.checkAddPrimaryKeyForSync();
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        String currentPKField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (currentPKField != null) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Field '%s' has been already defined as primary key.", currentPKField));
        }
        long columnKey = this.getColumnKey(fieldName);
        RealmFieldType fieldType = this.getFieldType(fieldName);
        this.checkForObjectStoreInvalidPrimaryKeyTypes(fieldName, fieldType);
        if (fieldType != RealmFieldType.STRING && !this.table.hasSearchIndex(columnKey)) {
            this.table.addSearchIndex(columnKey);
        }
        OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), fieldName);
        return this;
    }

    @Override
    public RealmObjectSchema removePrimaryKey() {
        this.realm.checkNotInSync();
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (pkField == null) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        long columnKey = this.table.getColumnKey(pkField);
        if (this.table.hasSearchIndex(columnKey)) {
            this.table.removeSearchIndex(columnKey);
        }
        OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), null);
        return this;
    }

    @Override
    public RealmObjectSchema setRequired(String fieldName, boolean required) {
        long columnKey = this.table.getColumnKey(fieldName);
        boolean currentColumnRequired = this.isRequired(fieldName);
        RealmFieldType type = this.table.getColumnType(columnKey);
        if (type == RealmFieldType.OBJECT) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmObject references: " + fieldName);
        }
        if (type == RealmFieldType.LIST) {
            throw new IllegalArgumentException("Cannot modify the required state for RealmList references: " + fieldName);
        }
        if (required && currentColumnRequired) {
            throw new IllegalStateException("Field is already required: " + fieldName);
        }
        if (!required && !currentColumnRequired) {
            throw new IllegalStateException("Field is already nullable: " + fieldName);
        }
        if (required) {
            try {
                this.table.convertColumnToNotNullable(columnKey);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Attempted to insert null into non-nullable column")) {
                    throw new IllegalStateException(String.format("The primary key field '%s' has 'null' values stored.", fieldName));
                }
                throw e;
            }
        } else {
            this.table.convertColumnToNullable(columnKey);
        }
        return this;
    }

    @Override
    public RealmObjectSchema setNullable(String fieldName, boolean nullable) {
        this.setRequired(fieldName, !nullable);
        return this;
    }

    @Override
    public RealmObjectSchema transform(RealmObjectSchema.Function function) {
        if (function != null) {
            OsResults result = OsResults.createFromQuery(this.realm.sharedRealm, this.table.where()).createSnapshot();
            long original_size = result.size();
            if (original_size > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too many results to iterate: " + original_size);
            }
            int size = (int)result.size();
            for (int i = 0; i < size; ++i) {
                DynamicRealmObject obj = new DynamicRealmObject(this.realm, new CheckedRow(result.getUncheckedRow(i)));
                if (!obj.isValid()) continue;
                function.apply(obj);
            }
        }
        return this;
    }

    @Override
    String getPropertyClassName(String propertyName) {
        String linkedClassName = this.table.getLinkTarget(this.getColumnKey(propertyName)).getClassName();
        if (Util.isEmptyString(linkedClassName)) {
            throw new IllegalArgumentException(String.format("Property '%s' not found.", propertyName));
        }
        return linkedClassName;
    }

    private void addModifiers(String fieldName, FieldAttribute[] attributes) {
        boolean indexAdded = false;
        try {
            if (attributes != null && attributes.length > 0) {
                if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.INDEXED)) {
                    this.addIndex(fieldName);
                    indexAdded = true;
                }
                if (MutableRealmObjectSchema.containsAttribute(attributes, FieldAttribute.PRIMARY_KEY)) {
                    this.addPrimaryKey(fieldName);
                    indexAdded = true;
                }
            }
        }
        catch (Exception e) {
            long columnKey = this.getColumnKey(fieldName);
            if (indexAdded) {
                this.table.removeSearchIndex(columnKey);
            }
            throw (RuntimeException)e;
        }
    }

    static boolean containsAttribute(FieldAttribute[] attributeList, FieldAttribute attribute) {
        if (attributeList == null || attributeList.length == 0) {
            return false;
        }
        for (FieldAttribute anAttributeList : attributeList) {
            if (anAttributeList != attribute) continue;
            return true;
        }
        return false;
    }

    private void checkNewFieldName(String fieldName) {
        MutableRealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldNameIsAvailable(fieldName);
    }

    private void checkFieldNameIsAvailable(String fieldName) {
        if (this.table.getColumnKey(fieldName) != -1L) {
            throw new IllegalArgumentException("Field already exists in '" + this.getClassName() + "': " + fieldName);
        }
    }

    private void checkAddPrimaryKeyForSync() {
        if (this.realm.configuration.isSyncConfiguration()) {
            throw new UnsupportedOperationException("'addPrimaryKey' is not supported by synced Realms.");
        }
    }

    private void checkForObjectStoreInvalidPrimaryKeyTypes(String fieldName, Class<?> fieldType) {
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            this.checkForObjectStoreInvalidPrimaryKeyTypes(fieldName, RealmFieldType.BOOLEAN);
        }
        if (fieldType == Date.class) {
            this.checkForObjectStoreInvalidPrimaryKeyTypes(fieldName, RealmFieldType.DATE);
        }
    }

    private void checkForObjectStoreInvalidPrimaryKeyTypes(String fieldName, RealmFieldType type) {
        switch (type) {
            case BOOLEAN: {
                throw new IllegalArgumentException("Boolean fields cannot be marked as primary keys: " + fieldName);
            }
            case DATE: {
                throw new IllegalArgumentException("Date fields cannot be marked as primary keys: " + fieldName);
            }
        }
    }
}

