/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.Collection;
import javax.annotation.Nullable;

class BinaryOperator
extends SetValueOperator<byte[]> {
    BinaryOperator(BaseRealm baseRealm, OsSet osSet, Class<byte[]> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(@Nullable byte[] value) {
        return this.osSet.add(value);
    }

    @Override
    boolean containsInternal(@Nullable Object o) {
        byte[] value = o == null ? null : (byte[])o;
        return this.osSet.contains(value);
    }

    @Override
    boolean removeInternal(@Nullable Object o) {
        return this.osSet.remove((byte[])o);
    }

    @Override
    boolean containsAllInternal(Collection<?> c) {
        Collection<?> binaryCollection = c;
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newBinaryCollection(binaryCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends byte[]> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newBinaryCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newBinaryCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newBinaryCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }
}

