/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryListOperator;
import io.realm.BooleanListOperator;
import io.realm.DateListOperator;
import io.realm.Decimal128ListOperator;
import io.realm.DoubleListOperator;
import io.realm.DynamicRealm;
import io.realm.FloatListOperator;
import io.realm.LongListOperator;
import io.realm.ManagedListOperator;
import io.realm.ObjectIdListOperator;
import io.realm.ProxyState;
import io.realm.RealmAny;
import io.realm.RealmAnyListOperator;
import io.realm.RealmAnyOperator;
import io.realm.RealmDictionary;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.RealmSchema;
import io.realm.RealmSet;
import io.realm.StringListOperator;
import io.realm.UUIDListOperator;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsList;
import io.realm.internal.OsMap;
import io.realm.internal.OsSet;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import io.realm.internal.core.NativeRealmAny;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class DynamicRealmObject
extends RealmObject
implements RealmObjectProxy {
    static final String MSG_LINK_QUERY_NOT_SUPPORTED = "Queries across relationships are not supported";
    private final ProxyState<DynamicRealmObject> proxyState = new ProxyState<DynamicRealmObject>(this);

    public DynamicRealmObject(RealmModel obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A non-null object must be provided.");
        }
        if (obj instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("The object is already a DynamicRealmObject: " + obj);
        }
        if (!RealmObject.isManaged(obj)) {
            throw new IllegalArgumentException("An object managed by Realm must be provided. This is an unmanaged object.");
        }
        if (!RealmObject.isValid(obj)) {
            throw new IllegalArgumentException("A valid object managed by Realm must be provided. This object was deleted.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)obj;
        Row row = proxy.realmGet$proxyState().getRow$realm();
        this.proxyState.setRealm$realm(proxy.realmGet$proxyState().getRealm$realm());
        this.proxyState.setRow$realm(((UncheckedRow)row).convertToChecked());
        this.proxyState.setConstructionFinished();
    }

    DynamicRealmObject(BaseRealm realm, Row row) {
        this.proxyState.setRealm$realm(realm);
        this.proxyState.setRow$realm(row);
        this.proxyState.setConstructionFinished();
    }

    public <E> E get(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (type) {
            case BOOLEAN: {
                return (E)Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnKey));
            }
            case INTEGER: {
                return (E)Long.valueOf(this.proxyState.getRow$realm().getLong(columnKey));
            }
            case FLOAT: {
                return (E)Float.valueOf(this.proxyState.getRow$realm().getFloat(columnKey));
            }
            case DOUBLE: {
                return (E)Double.valueOf(this.proxyState.getRow$realm().getDouble(columnKey));
            }
            case STRING: {
                return (E)this.proxyState.getRow$realm().getString(columnKey);
            }
            case BINARY: {
                return (E)this.proxyState.getRow$realm().getBinaryByteArray(columnKey);
            }
            case DATE: {
                return (E)this.proxyState.getRow$realm().getDate(columnKey);
            }
            case DECIMAL128: {
                return (E)this.proxyState.getRow$realm().getDecimal128(columnKey);
            }
            case OBJECT_ID: {
                return (E)this.proxyState.getRow$realm().getObjectId(columnKey);
            }
            case MIXED: {
                return (E)this.getRealmAny(columnKey);
            }
            case UUID: {
                return (E)this.proxyState.getRow$realm().getUUID(columnKey);
            }
            case OBJECT: {
                return (E)this.getObject(fieldName);
            }
            case LIST: {
                return (E)this.getList(fieldName);
            }
            case STRING_TO_INTEGER_MAP: {
                return (E)this.getDictionary(fieldName, Integer.class);
            }
            case STRING_TO_BOOLEAN_MAP: {
                return (E)this.getDictionary(fieldName, Boolean.class);
            }
            case STRING_TO_STRING_MAP: {
                return (E)this.getDictionary(fieldName, String.class);
            }
            case STRING_TO_BINARY_MAP: {
                return (E)this.getDictionary(fieldName, byte[].class);
            }
            case STRING_TO_DATE_MAP: {
                return (E)this.getDictionary(fieldName, Date.class);
            }
            case STRING_TO_FLOAT_MAP: {
                return (E)this.getDictionary(fieldName, Float.class);
            }
            case STRING_TO_DOUBLE_MAP: {
                return (E)this.getDictionary(fieldName, Double.class);
            }
            case STRING_TO_DECIMAL128_MAP: {
                return (E)this.getDictionary(fieldName, Decimal128.class);
            }
            case STRING_TO_OBJECT_ID_MAP: {
                return (E)this.getDictionary(fieldName, ObjectId.class);
            }
            case STRING_TO_UUID_MAP: {
                return (E)this.getDictionary(fieldName, UUID.class);
            }
            case STRING_TO_MIXED_MAP: {
                return (E)this.getDictionary(fieldName, RealmAny.class);
            }
            case STRING_TO_LINK_MAP: {
                return (E)this.getDictionary(fieldName);
            }
            case INTEGER_SET: {
                return (E)this.getRealmSet(fieldName, Integer.class);
            }
            case BOOLEAN_SET: {
                return (E)this.getRealmSet(fieldName, Boolean.class);
            }
            case STRING_SET: {
                return (E)this.getRealmSet(fieldName, String.class);
            }
            case BINARY_SET: {
                return (E)this.getRealmSet(fieldName, byte[].class);
            }
            case DATE_SET: {
                return (E)this.getRealmSet(fieldName, Date.class);
            }
            case FLOAT_SET: {
                return (E)this.getRealmSet(fieldName, Float.class);
            }
            case DOUBLE_SET: {
                return (E)this.getRealmSet(fieldName, Double.class);
            }
            case DECIMAL128_SET: {
                return (E)this.getRealmSet(fieldName, Decimal128.class);
            }
            case OBJECT_ID_SET: {
                return (E)this.getRealmSet(fieldName, ObjectId.class);
            }
            case UUID_SET: {
                return (E)this.getRealmSet(fieldName, UUID.class);
            }
            case LINK_SET: {
                return (E)this.getRealmSet(fieldName);
            }
            case MIXED_SET: {
                return (E)this.getRealmSet(fieldName, RealmAny.class);
            }
        }
        throw new IllegalStateException("Field type not supported: " + (Object)((Object)type));
    }

    public boolean getBoolean(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getBoolean(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.BOOLEAN);
            throw e;
        }
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getLong(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.INTEGER);
            throw e;
        }
    }

    public byte getByte(String fieldName) {
        return (byte)this.getLong(fieldName);
    }

    public float getFloat(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getFloat(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.FLOAT);
            throw e;
        }
    }

    public double getDouble(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getDouble(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.DOUBLE);
            throw e;
        }
    }

    public byte[] getBlob(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getBinaryByteArray(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.BINARY);
            throw e;
        }
    }

    public String getString(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getString(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.STRING);
            throw e;
        }
    }

    public Date getDate(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.DATE);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(columnKey);
    }

    public Decimal128 getDecimal128(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.DECIMAL128);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDecimal128(columnKey);
    }

    public ObjectId getObjectId(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.OBJECT_ID);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getObjectId(columnKey);
    }

    public RealmAny getRealmAny(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.MIXED);
        return this.getRealmAny(columnKey);
    }

    public UUID getUUID(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.UUID);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getUUID(columnKey);
    }

    @Nullable
    public DynamicRealmObject getObject(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.OBJECT);
        if (this.proxyState.getRow$realm().isNullLink(columnKey)) {
            return null;
        }
        long linkObjectKey = this.proxyState.getRow$realm().getLink(columnKey);
        CheckedRow linkRow = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getCheckedRow(linkObjectKey);
        return new DynamicRealmObject(this.proxyState.getRealm$realm(), linkRow);
    }

    public RealmList<DynamicRealmObject> getList(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            OsList osList = this.proxyState.getRow$realm().getModelList(columnKey);
            String className = osList.getTargetTable().getClassName();
            return new RealmList<DynamicRealmObject>(className, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.LIST);
            throw e;
        }
    }

    public <E> RealmList<E> getList(String fieldName, Class<E> primitiveType) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (primitiveType == null) {
            throw new IllegalArgumentException("Non-null 'primitiveType' required.");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType realmType = this.primitiveTypeToRealmFieldType(CollectionType.LIST, primitiveType);
        try {
            OsList osList = this.proxyState.getRow$realm().getValueList(columnKey, realmType);
            return new RealmList<E>(primitiveType, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, realmType);
            throw e;
        }
    }

    public RealmDictionary<DynamicRealmObject> getDictionary(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            OsMap osMap = this.proxyState.getRow$realm().getModelMap(columnKey);
            String className = osMap.getTargetTable().getClassName();
            return new RealmDictionary<DynamicRealmObject>(this.proxyState.getRealm$realm(), osMap, className);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.STRING_TO_LINK_MAP);
            throw e;
        }
    }

    public <E> RealmDictionary<E> getDictionary(String fieldName, Class<E> primitiveType) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (primitiveType == null) {
            throw new IllegalArgumentException("Non-null 'primitiveType' required.");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType realmType = this.primitiveTypeToRealmFieldType(CollectionType.DICTIONARY, primitiveType);
        try {
            OsMap osMap = this.proxyState.getRow$realm().getValueMap(columnKey, realmType);
            return new RealmDictionary<E>(this.proxyState.getRealm$realm(), osMap, primitiveType);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, realmType);
            throw e;
        }
    }

    public RealmSet<DynamicRealmObject> getRealmSet(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            OsSet osSet = this.proxyState.getRow$realm().getModelSet(columnKey);
            String className = osSet.getTargetTable().getClassName();
            return new RealmSet<DynamicRealmObject>(this.proxyState.getRealm$realm(), osSet, className);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.LINK_SET);
            throw e;
        }
    }

    public <E> RealmSet<E> getRealmSet(String fieldName, Class<E> primitiveType) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (primitiveType == null) {
            throw new IllegalArgumentException("Non-null 'primitiveType' required.");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType realmType = this.primitiveTypeToRealmFieldType(CollectionType.SET, primitiveType);
        try {
            OsSet osSet = this.proxyState.getRow$realm().getValueSet(columnKey, realmType);
            return new RealmSet<E>(this.proxyState.getRealm$realm(), osSet, primitiveType);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, realmType);
            throw e;
        }
    }

    private <E> RealmFieldType primitiveTypeToRealmFieldType(CollectionType collectionType, Class<E> primitiveType) {
        int nativeValue = this.primitiveTypeToCoreType(primitiveType);
        switch (collectionType) {
            case SET: {
                nativeValue += 256;
                break;
            }
            case DICTIONARY: {
                nativeValue += 512;
                break;
            }
            case LIST: {
                nativeValue += 128;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + (Object)((Object)collectionType));
            }
        }
        return RealmFieldType.fromNativeValue(nativeValue);
    }

    private <E> int primitiveTypeToCoreType(Class<E> primitiveType) {
        if (primitiveType.equals(Integer.class) || primitiveType.equals(Long.class) || primitiveType.equals(Short.class) || primitiveType.equals(Byte.class)) {
            return 0;
        }
        if (primitiveType.equals(Boolean.class)) {
            return 1;
        }
        if (primitiveType.equals(String.class)) {
            return 2;
        }
        if (primitiveType.equals(byte[].class)) {
            return 4;
        }
        if (primitiveType.equals(Date.class)) {
            return 8;
        }
        if (primitiveType.equals(Float.class)) {
            return 9;
        }
        if (primitiveType.equals(Double.class)) {
            return 10;
        }
        if (primitiveType.equals(Decimal128.class)) {
            return 11;
        }
        if (primitiveType.equals(ObjectId.class)) {
            return 15;
        }
        if (primitiveType.equals(UUID.class)) {
            return 17;
        }
        if (primitiveType.equals(RealmAny.class)) {
            return 6;
        }
        throw new IllegalArgumentException("Unsupported element type. Only primitive types supported. Yours was: " + primitiveType);
    }

    public boolean isNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (type) {
            case OBJECT: {
                return this.proxyState.getRow$realm().isNullLink(columnKey);
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case DECIMAL128: 
            case OBJECT_ID: 
            case MIXED: 
            case UUID: {
                return this.proxyState.getRow$realm().isNull(columnKey);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.proxyState.getRow$realm().hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getColumnNames();
    }

    public void set(String fieldName, Object value) {
        this.proxyState.getRealm$realm().checkIfValid();
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                case DECIMAL128: {
                    value = Decimal128.parse((String)strValue);
                    break;
                }
                case OBJECT_ID: {
                    value = new ObjectId(strValue);
                    break;
                }
                case UUID: {
                    value = UUID.fromString(strValue);
                    break;
                }
                case MIXED: {
                    value = RealmAny.valueOf(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.US, "Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if (value == null) {
            this.setNull(fieldName);
        } else {
            this.setValue(fieldName, value);
        }
    }

    private void setValue(String fieldName, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (valueClass == DynamicRealmObject.class) {
            this.setObject(fieldName, (DynamicRealmObject)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else if (valueClass == Decimal128.class) {
            this.setDecimal128(fieldName, (Decimal128)value);
        } else if (valueClass == ObjectId.class) {
            this.setObjectId(fieldName, (ObjectId)value);
        } else if (valueClass == UUID.class) {
            this.setUUID(fieldName, (UUID)value);
        } else if (valueClass == RealmAny.class) {
            this.setRealmAny(fieldName, (RealmAny)value);
        } else {
            throw new IllegalArgumentException("Value is of an type not supported: " + value.getClass());
        }
    }

    public void setBoolean(String fieldName, boolean value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setBoolean(columnKey, value);
    }

    public void setShort(String fieldName, short value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setInt(String fieldName, int value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setLong(String fieldName, long value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setByte(String fieldName, byte value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setFloat(String fieldName, float value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setFloat(columnKey, value);
    }

    public void setDouble(String fieldName, double value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setDouble(columnKey, value);
    }

    public void setString(String fieldName, @Nullable String value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setString(columnKey, value);
    }

    public void setBlob(String fieldName, @Nullable byte[] value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setBinaryByteArray(columnKey, value);
    }

    public void setDate(String fieldName, @Nullable Date value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setDate(columnKey, value);
        }
    }

    public void setDecimal128(String fieldName, @Nullable Decimal128 value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setDecimal128(columnKey, value);
        }
    }

    public void setObjectId(String fieldName, @Nullable ObjectId value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setObjectId(columnKey, value);
        }
    }

    public void setRealmAny(String fieldName, @Nullable RealmAny value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setRealmAny(columnKey, value.getNativePtr());
        }
    }

    public void setUUID(String fieldName, @Nullable UUID value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setUUID(columnKey, value);
        }
    }

    public void setObject(String fieldName, @Nullable DynamicRealmObject value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().nullifyLink(columnKey);
        } else {
            Table inputTable;
            if (value.proxyState.getRealm$realm() == null || value.proxyState.getRow$realm() == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (this.proxyState.getRealm$realm() != value.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Cannot add an object from another Realm instance.");
            }
            Table table = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey);
            if (!table.hasSameSchema(inputTable = value.proxyState.getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.proxyState.getRow$realm().setLink(columnKey, value.proxyState.getRow$realm().getObjectKey());
        }
    }

    public <E> void setList(String fieldName, RealmList<E> list) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (list == null) {
            throw new IllegalArgumentException("Non-null 'list' required");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (columnType) {
            case LIST: {
                E element;
                if (!list.isEmpty() && !((element = list.first()) instanceof DynamicRealmObject) && RealmModel.class.isAssignableFrom(element.getClass())) {
                    throw new IllegalArgumentException("RealmList must contain `DynamicRealmObject's, not Java model classes.");
                }
                this.setModelList(fieldName, list);
                break;
            }
            case INTEGER_LIST: 
            case BOOLEAN_LIST: 
            case STRING_LIST: 
            case BINARY_LIST: 
            case DATE_LIST: 
            case FLOAT_LIST: 
            case DOUBLE_LIST: 
            case DECIMAL128_LIST: 
            case OBJECT_ID_LIST: 
            case UUID_LIST: 
            case MIXED_LIST: {
                this.setValueList(fieldName, list, columnType);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a list but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    private void setModelList(String fieldName, RealmList<DynamicRealmObject> list) {
        int i;
        boolean typeValidated;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsList osList = this.proxyState.getRow$realm().getModelList(columnKey);
        Table linkTargetTable = osList.getTargetTable();
        String linkTargetTableName = linkTargetTable.getClassName();
        if (list.className == null && list.clazz == null) {
            typeValidated = false;
        } else {
            String listType;
            String string = listType = list.className != null ? list.className : this.proxyState.getRealm$realm().getSchema().getTable(list.clazz).getClassName();
            if (!linkTargetTableName.equals(listType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "The elements in the list are not the proper type. Was %s expected %s.", listType, linkTargetTableName));
            }
            typeValidated = true;
        }
        int listLength = list.size();
        long[] indices = new long[listLength];
        for (i = 0; i < listLength; ++i) {
            RealmObjectProxy obj = list.get(i);
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'list' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Element at index %d is not the proper type. Was '%s' expected '%s'.", i, obj.realmGet$proxyState().getRow$realm().getTable().getClassName(), linkTargetTableName));
            }
            indices[i] = obj.realmGet$proxyState().getRow$realm().getObjectKey();
        }
        osList.removeAll();
        for (i = 0; i < listLength; ++i) {
            osList.addRow(indices[i]);
        }
    }

    private <E> void setValueList(String fieldName, RealmList<E> list, RealmFieldType primitiveType) {
        Class elementClass;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsList osList = this.proxyState.getRow$realm().getValueList(columnKey, primitiveType);
        switch (primitiveType) {
            case INTEGER_LIST: {
                elementClass = Long.class;
                break;
            }
            case BOOLEAN_LIST: {
                elementClass = Boolean.class;
                break;
            }
            case STRING_LIST: {
                elementClass = String.class;
                break;
            }
            case BINARY_LIST: {
                elementClass = byte[].class;
                break;
            }
            case DATE_LIST: {
                elementClass = Date.class;
                break;
            }
            case FLOAT_LIST: {
                elementClass = Float.class;
                break;
            }
            case DOUBLE_LIST: {
                elementClass = Double.class;
                break;
            }
            case DECIMAL128_LIST: {
                elementClass = Decimal128.class;
                break;
            }
            case OBJECT_ID_LIST: {
                elementClass = ObjectId.class;
                break;
            }
            case UUID_LIST: {
                elementClass = UUID.class;
                break;
            }
            case MIXED_LIST: {
                elementClass = RealmAny.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)primitiveType));
            }
        }
        ManagedListOperator<Long> operator = this.getOperator(this.proxyState.getRealm$realm(), osList, primitiveType, elementClass);
        if (list.isManaged() && osList.size() == (long)list.size()) {
            int size = list.size();
            Iterator<E> iterator = list.iterator();
            for (int i = 0; i < size; ++i) {
                E value = iterator.next();
                operator.set(i, value);
            }
        } else {
            osList.removeAll();
            for (E value : list) {
                operator.append(value);
            }
        }
    }

    private <E> ManagedListOperator<E> getOperator(BaseRealm realm, OsList osList, RealmFieldType valueListType, Class<E> valueClass) {
        if (valueListType == RealmFieldType.STRING_LIST) {
            return new StringListOperator(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.INTEGER_LIST) {
            return new LongListOperator<String>(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.BOOLEAN_LIST) {
            return new BooleanListOperator(realm, osList, (Class<Boolean>)valueClass);
        }
        if (valueListType == RealmFieldType.BINARY_LIST) {
            return new BinaryListOperator(realm, osList, (Class<byte[]>)valueClass);
        }
        if (valueListType == RealmFieldType.DOUBLE_LIST) {
            return new DoubleListOperator(realm, osList, (Class<Double>)valueClass);
        }
        if (valueListType == RealmFieldType.FLOAT_LIST) {
            return new FloatListOperator(realm, osList, (Class<Float>)valueClass);
        }
        if (valueListType == RealmFieldType.DATE_LIST) {
            return new DateListOperator(realm, osList, (Class<Date>)valueClass);
        }
        if (valueListType == RealmFieldType.DECIMAL128_LIST) {
            return new Decimal128ListOperator(realm, osList, (Class<Decimal128>)valueClass);
        }
        if (valueListType == RealmFieldType.OBJECT_ID_LIST) {
            return new ObjectIdListOperator(realm, osList, (Class<ObjectId>)valueClass);
        }
        if (valueListType == RealmFieldType.UUID_LIST) {
            return new UUIDListOperator(realm, osList, (Class<UUID>)valueClass);
        }
        if (valueListType == RealmFieldType.MIXED_LIST) {
            return new RealmAnyListOperator(realm, osList, (Class<RealmAny>)valueClass);
        }
        throw new IllegalArgumentException("Unexpected list type: " + valueListType.name());
    }

    public <E> void setDictionary(String fieldName, RealmDictionary<E> dictionary) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (dictionary == null) {
            throw new IllegalArgumentException("Non-null 'dictionary' required");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (columnType) {
            case STRING_TO_INTEGER_MAP: 
            case STRING_TO_BOOLEAN_MAP: 
            case STRING_TO_STRING_MAP: 
            case STRING_TO_BINARY_MAP: 
            case STRING_TO_DATE_MAP: 
            case STRING_TO_FLOAT_MAP: 
            case STRING_TO_DOUBLE_MAP: 
            case STRING_TO_DECIMAL128_MAP: 
            case STRING_TO_OBJECT_ID_MAP: 
            case STRING_TO_UUID_MAP: 
            case STRING_TO_MIXED_MAP: {
                this.setValueDictionary(fieldName, dictionary, columnType);
                break;
            }
            case STRING_TO_LINK_MAP: {
                this.setModelDictionary(fieldName, dictionary);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a dictionary but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    private void setModelDictionary(String fieldName, RealmDictionary<DynamicRealmObject> sourceDictionary) {
        boolean typeValidated;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsMap osMap = this.proxyState.getRow$realm().getModelMap(columnKey);
        Table linkTargetTable = osMap.getTargetTable();
        String linkTargetTableName = linkTargetTable.getClassName();
        if (!sourceDictionary.isManaged()) {
            typeValidated = false;
        } else {
            String dictType;
            String string = dictType = sourceDictionary.getValueClassName() != null ? sourceDictionary.getValueClassName() : this.proxyState.getRealm$realm().getSchema().getTable(sourceDictionary.getValueClass()).getClassName();
            if (!linkTargetTableName.equals(dictType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "The elements in the dictionary are not the proper type. Was %s expected %s.", dictType, linkTargetTableName));
            }
            typeValidated = true;
        }
        RealmDictionary<Long> auxiliaryDictionary = new RealmDictionary<Long>();
        for (Map.Entry entry : sourceDictionary.entrySet()) {
            RealmObjectProxy obj = (RealmObjectProxy)entry.getValue();
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'dictionary' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Element with key %s is not the proper type. Was '%s' expected '%s'.", entry.getKey(), obj.realmGet$proxyState().getRow$realm().getTable().getClassName(), linkTargetTableName));
            }
            long row = obj.realmGet$proxyState().getRow$realm().getObjectKey();
            auxiliaryDictionary.put((String)entry.getKey(), row);
        }
        osMap.clear();
        for (Map.Entry entry : auxiliaryDictionary.entrySet()) {
            osMap.putRow(entry.getKey(), (Long)entry.getValue());
        }
    }

    private <E> void setValueDictionary(String fieldName, RealmDictionary<E> sourceDictionary, RealmFieldType primitiveType) {
        Class elementClass;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsMap osMap = this.proxyState.getRow$realm().getValueMap(columnKey, primitiveType);
        switch (primitiveType) {
            case STRING_TO_INTEGER_MAP: {
                elementClass = Long.class;
                break;
            }
            case STRING_TO_BOOLEAN_MAP: {
                elementClass = Boolean.class;
                break;
            }
            case STRING_TO_STRING_MAP: {
                elementClass = String.class;
                break;
            }
            case STRING_TO_BINARY_MAP: {
                elementClass = byte[].class;
                break;
            }
            case STRING_TO_DATE_MAP: {
                elementClass = Date.class;
                break;
            }
            case STRING_TO_FLOAT_MAP: {
                elementClass = Float.class;
                break;
            }
            case STRING_TO_DOUBLE_MAP: {
                elementClass = Double.class;
                break;
            }
            case STRING_TO_DECIMAL128_MAP: {
                elementClass = Decimal128.class;
                break;
            }
            case STRING_TO_OBJECT_ID_MAP: {
                elementClass = ObjectId.class;
                break;
            }
            case STRING_TO_UUID_MAP: {
                elementClass = UUID.class;
                break;
            }
            case STRING_TO_MIXED_MAP: {
                elementClass = RealmAny.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)primitiveType));
            }
        }
        RealmDictionary<Long> targetDictionary = new RealmDictionary<Long>(this.proxyState.getRealm$realm(), osMap, elementClass);
        RealmDictionary auxiliaryDictionary = new RealmDictionary();
        for (Map.Entry entry : sourceDictionary.entrySet()) {
            auxiliaryDictionary.put((String)entry.getKey(), entry.getValue());
        }
        osMap.clear();
        for (Map.Entry entry : auxiliaryDictionary.entrySet()) {
            targetDictionary.put((String)entry.getKey(), (Long)entry.getValue());
        }
    }

    public <E> void setRealmSet(String fieldName, RealmSet<E> set) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (set == null) {
            throw new IllegalArgumentException("Non-null 'set' required");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (columnType) {
            case INTEGER_SET: 
            case BOOLEAN_SET: 
            case STRING_SET: 
            case BINARY_SET: 
            case DATE_SET: 
            case FLOAT_SET: 
            case DOUBLE_SET: 
            case DECIMAL128_SET: 
            case OBJECT_ID_SET: 
            case UUID_SET: 
            case MIXED_SET: {
                this.setValueSet(fieldName, set, columnType);
                break;
            }
            case LINK_SET: {
                this.setModelSet(fieldName, set);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a set but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    private void setModelSet(String fieldName, RealmSet<DynamicRealmObject> sourceSet) {
        boolean typeValidated;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsSet osSet = this.proxyState.getRow$realm().getModelSet(columnKey);
        Table linkTargetTable = osSet.getTargetTable();
        String linkTargetTableName = linkTargetTable.getClassName();
        if (!sourceSet.isManaged()) {
            typeValidated = false;
        } else {
            String setType;
            String string = setType = sourceSet.getValueClassName() != null ? sourceSet.getValueClassName() : this.proxyState.getRealm$realm().getSchema().getTable(sourceSet.getValueClass()).getClassName();
            if (!linkTargetTableName.equals(setType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "The elements in the set are not the proper type. Was %s expected %s.", setType, linkTargetTableName));
            }
            typeValidated = true;
        }
        RealmSet<Long> auxiliarySet = new RealmSet<Long>();
        for (DynamicRealmObject obj : sourceSet) {
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'set' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Set contains an element with not the proper type. Was '%s' expected '%s'.", obj.realmGet$proxyState().getRow$realm().getTable().getClassName(), linkTargetTableName));
            }
            long row = obj.realmGet$proxyState().getRow$realm().getObjectKey();
            auxiliarySet.add(row);
        }
        osSet.clear();
        for (Long row : auxiliarySet) {
            osSet.addRow(row);
        }
    }

    private <E> void setValueSet(String fieldName, RealmSet<E> sourceSet, RealmFieldType primitiveType) {
        Class elementClass;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsSet osSet = this.proxyState.getRow$realm().getValueSet(columnKey, primitiveType);
        switch (primitiveType) {
            case INTEGER_SET: {
                elementClass = Number.class;
                break;
            }
            case BOOLEAN_SET: {
                elementClass = Boolean.class;
                break;
            }
            case STRING_SET: {
                elementClass = String.class;
                break;
            }
            case BINARY_SET: {
                elementClass = byte[].class;
                break;
            }
            case DATE_SET: {
                elementClass = Date.class;
                break;
            }
            case FLOAT_SET: {
                elementClass = Float.class;
                break;
            }
            case DOUBLE_SET: {
                elementClass = Double.class;
                break;
            }
            case DECIMAL128_SET: {
                elementClass = Decimal128.class;
                break;
            }
            case OBJECT_ID_SET: {
                elementClass = ObjectId.class;
                break;
            }
            case UUID_SET: {
                elementClass = UUID.class;
                break;
            }
            case MIXED_SET: {
                elementClass = RealmAny.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)primitiveType));
            }
        }
        RealmSet<Number> targetSet = new RealmSet<Number>(this.proxyState.getRealm$realm(), osSet, elementClass);
        RealmSet<E> auxiliarySet = new RealmSet<E>();
        auxiliarySet.addAll(sourceSet);
        osSet.clear();
        targetSet.addAll(auxiliarySet);
    }

    public void setNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        if (type == RealmFieldType.OBJECT) {
            this.proxyState.getRow$realm().nullifyLink(columnKey);
        } else {
            this.checkIsPrimaryKey(fieldName);
            this.proxyState.getRow$realm().setNull(columnKey);
        }
    }

    public String getType() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getTable().getClassName();
    }

    public RealmFieldType getFieldType(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        return this.proxyState.getRow$realm().getColumnType(columnKey);
    }

    private void checkFieldType(String fieldName, long columnIndex, RealmFieldType expectedType) {
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (columnType != expectedType) {
            String expectedIndefiniteVowel = "";
            if (expectedType == RealmFieldType.INTEGER || expectedType == RealmFieldType.OBJECT) {
                expectedIndefiniteVowel = "n";
            }
            String columnTypeIndefiniteVowel = "";
            if (columnType == RealmFieldType.INTEGER || columnType == RealmFieldType.OBJECT) {
                columnTypeIndefiniteVowel = "n";
            }
            throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a%s '%s', but a%s '%s'.", new Object[]{fieldName, expectedIndefiniteVowel, expectedType, columnTypeIndefiniteVowel, columnType}));
        }
    }

    public int hashCode() {
        this.proxyState.getRealm$realm().checkIfValid();
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getObjectKey();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = other.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = other.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getObjectKey() == other.proxyState.getRow$realm().getObjectKey();
    }

    public String toString() {
        String[] fields;
        this.proxyState.getRealm$realm().checkIfValid();
        if (!this.proxyState.getRow$realm().isValid()) {
            return "Invalid object";
        }
        String className = this.proxyState.getRow$realm().getTable().getClassName();
        StringBuilder sb = new StringBuilder(className + " = dynamic[");
        for (String field : fields = this.getFieldNames()) {
            long columnKey = this.proxyState.getRow$realm().getColumnKey(field);
            RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
            sb.append("{");
            sb.append(field).append(":");
            switch (type) {
                case BOOLEAN: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnKey)));
                    break;
                }
                case INTEGER: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Long.valueOf(this.proxyState.getRow$realm().getLong(columnKey)));
                    break;
                }
                case FLOAT: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Float.valueOf(this.proxyState.getRow$realm().getFloat(columnKey)));
                    break;
                }
                case DOUBLE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Double.valueOf(this.proxyState.getRow$realm().getDouble(columnKey)));
                    break;
                }
                case STRING: {
                    sb.append(this.proxyState.getRow$realm().getString(columnKey));
                    break;
                }
                case BINARY: {
                    sb.append(Arrays.toString(this.proxyState.getRow$realm().getBinaryByteArray(columnKey)));
                    break;
                }
                case DATE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getDate(columnKey));
                    break;
                }
                case DECIMAL128: {
                    sb.append((Object)(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getDecimal128(columnKey)));
                    break;
                }
                case OBJECT_ID: {
                    sb.append((Object)(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getObjectId(columnKey)));
                    break;
                }
                case UUID: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getUUID(columnKey));
                    break;
                }
                case MIXED: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.getRealmAny(columnKey));
                    break;
                }
                case OBJECT: {
                    sb.append(this.proxyState.getRow$realm().isNullLink(columnKey) ? "null" : this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName());
                    break;
                }
                case LIST: {
                    String targetClassName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName();
                    sb.append(String.format(Locale.US, "RealmList<%s>[%s]", targetClassName, this.proxyState.getRow$realm().getModelList(columnKey).size()));
                    break;
                }
                case INTEGER_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Long>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case BOOLEAN_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Boolean>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case STRING_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<String>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case BINARY_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<byte[]>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DATE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Date>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case FLOAT_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Float>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DOUBLE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Double>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DECIMAL128_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Decimal128>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case OBJECT_ID_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<ObjectId>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case UUID_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<UUID>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case MIXED_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<RealmAny>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case STRING_TO_INTEGER_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Long>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_BOOLEAN_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Boolean>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_STRING_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<String>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_BINARY_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<byte[]>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_DATE_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Date>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_FLOAT_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Float>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_DOUBLE_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Double>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_DECIMAL128_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<Decimal128>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_OBJECT_ID_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<ObjectId>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_UUID_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<UUID>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_MIXED_MAP: {
                    sb.append(String.format(Locale.US, "RealmDictionary<RealmAny>[%s]", this.proxyState.getRow$realm().getValueMap(columnKey, type).size()));
                    break;
                }
                case STRING_TO_LINK_MAP: {
                    String targetClassName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName();
                    sb.append(String.format(Locale.US, "RealmDictionary<%s>[%s]", targetClassName, this.proxyState.getRow$realm().getModelMap(columnKey).size()));
                    break;
                }
                case INTEGER_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Long>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case BOOLEAN_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Boolean>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case STRING_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<String>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case BINARY_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<byte[]>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case DATE_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Date>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case FLOAT_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Float>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case DOUBLE_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Double>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case DECIMAL128_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<Decimal128>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case OBJECT_ID_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<ObjectId>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case UUID_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<UUID>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case MIXED_SET: {
                    sb.append(String.format(Locale.US, "RealmSet<RealmAny>[%s]", this.proxyState.getRow$realm().getValueSet(columnKey, type).size()));
                    break;
                }
                case LINK_SET: {
                    String targetClassName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName();
                    sb.append(String.format(Locale.US, "RealmSet<%s>[%s]", targetClassName, this.proxyState.getRow$realm().getModelSet(columnKey).size()));
                    break;
                }
                default: {
                    sb.append("?");
                }
            }
            sb.append("},");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }

    private RealmAny getRealmAny(long columnKey) {
        NativeRealmAny nativeRealmAny = this.proxyState.getRow$realm().getNativeRealmAny(columnKey);
        return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.proxyState.getRealm$realm(), nativeRealmAny));
    }

    public RealmResults<DynamicRealmObject> linkingObjects(String srcClassName, String srcFieldName) {
        DynamicRealm realm = (DynamicRealm)this.proxyState.getRealm$realm();
        realm.checkIfValid();
        this.proxyState.getRow$realm().checkIfAttached();
        RealmSchema schema = realm.getSchema();
        RealmObjectSchema realmObjectSchema = schema.get(srcClassName);
        if (realmObjectSchema == null) {
            throw new IllegalArgumentException("Class not found: " + srcClassName);
        }
        if (srcFieldName == null) {
            throw new IllegalArgumentException("Non-null 'srcFieldName' required.");
        }
        if (srcFieldName.contains(".")) {
            throw new IllegalArgumentException(MSG_LINK_QUERY_NOT_SUPPORTED);
        }
        RealmFieldType fieldType = realmObjectSchema.getFieldType(srcFieldName);
        if (fieldType != RealmFieldType.OBJECT && fieldType != RealmFieldType.LIST) {
            throw new IllegalArgumentException(String.format(Locale.US, "Unexpected field type: %1$s. Field type should be either %2$s.%3$s or %2$s.%4$s.", fieldType.name(), RealmFieldType.class.getSimpleName(), RealmFieldType.OBJECT.name(), RealmFieldType.LIST.name()));
        }
        return RealmResults.createDynamicBacklinkResults(realm, (UncheckedRow)this.proxyState.getRow$realm(), realmObjectSchema.getTable(), srcFieldName);
    }

    public DynamicRealm getDynamicRealm() {
        BaseRealm realm = this.realmGet$proxyState().getRealm$realm();
        realm.checkIfValid();
        if (!this.isValid()) {
            throw new IllegalStateException("the object is already deleted.");
        }
        return (DynamicRealm)realm;
    }

    @Override
    public void realm$injectObjectContext() {
    }

    @Override
    public ProxyState realmGet$proxyState() {
        return this.proxyState;
    }

    private void checkIsPrimaryKey(String fieldName) {
        RealmObjectSchema objectSchema = this.proxyState.getRealm$realm().getSchema().getSchemaForClass(this.getType());
        if (objectSchema.hasPrimaryKey() && objectSchema.getPrimaryKey().equals(fieldName)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Primary key field '%s' cannot be changed after object was created.", fieldName));
        }
    }

    private static enum CollectionType {
        LIST,
        DICTIONARY,
        SET;

    }
}

