/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.EqualsHelper;
import io.realm.GenericEquals;
import io.realm.MapValueOperator;
import io.realm.RealmMapEntrySet;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class GenericPrimitiveValueOperator<K, V>
extends MapValueOperator<K, V> {
    private final EqualsHelper<K, V> equalsHelper;

    GenericPrimitiveValueOperator(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap, TypeSelectorForMap<K, V> typeSelectorForMap, RealmMapEntrySet.IteratorType iteratorType) {
        this(valueClass, baseRealm, osMap, typeSelectorForMap, iteratorType, new GenericEquals());
    }

    GenericPrimitiveValueOperator(Class<V> valueClass, BaseRealm baseRealm, OsMap osMap, TypeSelectorForMap<K, V> typeSelectorForMap, RealmMapEntrySet.IteratorType iteratorType, EqualsHelper<K, V> equalsHelper) {
        super(valueClass, baseRealm, osMap, typeSelectorForMap, iteratorType);
        this.equalsHelper = equalsHelper;
    }

    @Override
    @Nullable
    V get(Object key) {
        Object value = this.osMap.get(key);
        if (value == null) {
            return null;
        }
        return this.processValue(value);
    }

    @Override
    @Nullable
    V put(K key, @Nullable V value) {
        V original = this.get((Object)key);
        this.osMap.put(key, value);
        return original;
    }

    @Override
    Set<Map.Entry<K, V>> entrySet() {
        return new RealmMapEntrySet<K, V>(this.baseRealm, this.osMap, this.iteratorType, this.equalsHelper, null);
    }

    @Override
    boolean containsValueInternal(@Nullable Object value) {
        return this.osMap.containsPrimitiveValue(value);
    }

    @Nullable
    V processValue(Object value) {
        return (V)value;
    }
}

