/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.ManagedListOperator;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.internal.OsList;
import io.realm.internal.core.NativeRealmAny;
import java.util.Locale;
import javax.annotation.Nullable;

final class RealmAnyListOperator
extends ManagedListOperator<RealmAny> {
    RealmAnyListOperator(BaseRealm realm, OsList osList, Class<RealmAny> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    public RealmAny get(int index) {
        NativeRealmAny nativeRealmAny = (NativeRealmAny)this.osList.getValue(index);
        nativeRealmAny = nativeRealmAny == null ? new NativeRealmAny() : nativeRealmAny;
        return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.realm, nativeRealmAny));
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof RealmAny)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.util.RealmAny", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        RealmAny realmAny = (RealmAny)value;
        realmAny = CollectionUtils.copyToRealmIfNeeded(this.realm, realmAny);
        this.osList.addRealmAny(realmAny.getNativePtr());
    }

    @Override
    public void insertValue(int index, Object value) {
        this.checkInsertIndex(index);
        RealmAny realmAny = (RealmAny)value;
        realmAny = CollectionUtils.copyToRealmIfNeeded(this.realm, realmAny);
        this.osList.insertRealmAny(index, realmAny.getNativePtr());
    }

    @Override
    protected void setValue(int index, Object value) {
        RealmAny realmAny = (RealmAny)value;
        realmAny = CollectionUtils.copyToRealmIfNeeded(this.realm, realmAny);
        this.osList.setRealmAny(index, realmAny.getNativePtr());
    }
}

