/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.Case;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.internal.OsCollection;
import io.realm.internal.OsList;
import io.realm.internal.OsResults;
import io.realm.internal.OsSet;
import io.realm.internal.PendingRow;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.Util;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmQuery<E> {
    private final Table table;
    private final BaseRealm realm;
    private final TableQuery query;
    private final RealmObjectSchema schema;
    private Class<E> clazz;
    private String className;
    private final boolean forValues;
    private final OsCollection osCollection;
    private static final String PRIMITIVE_LISTS_NOT_SUPPORTED_ERROR_MESSAGE = "Queries on primitive lists are not yet supported";
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    private static final String EMPTY_VALUES = "Non-empty 'values' must be provided.";
    private static final String ASYNC_QUERY_WRONG_THREAD_MESSAGE = "Async query cannot be created on current thread.";

    static <E extends RealmModel> RealmQuery<E> createQuery(Realm realm, Class<E> clazz) {
        return new RealmQuery<E>(realm, clazz);
    }

    static <E extends RealmModel> RealmQuery<E> createDynamicQuery(DynamicRealm realm, String className) {
        return new RealmQuery<E>(realm, className);
    }

    static <E> RealmQuery<E> createQueryFromResult(RealmResults<E> queryResults) {
        return queryResults.classSpec == null ? new RealmQuery<E>(queryResults, queryResults.className) : new RealmQuery<DynamicRealmObject>(queryResults, queryResults.classSpec);
    }

    static <E> RealmQuery<E> createQueryFromList(RealmList<E> list) {
        return list.clazz == null ? new RealmQuery<E>(list.baseRealm, list.getOsList(), list.className) : new RealmQuery(list.baseRealm, list.getOsList(), list.clazz);
    }

    private static boolean isClassForRealmModel(Class<?> clazz) {
        return RealmModel.class.isAssignableFrom(clazz);
    }

    private RealmQuery(Realm realm, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            throw new UnsupportedOperationException(PRIMITIVE_LISTS_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        this.schema = realm.getSchema().getSchemaForClass(clazz);
        this.table = this.schema.getTable();
        this.osCollection = null;
        this.query = this.table.where();
    }

    private RealmQuery(RealmResults<E> queryResults, Class<E> clazz) {
        this.realm = queryResults.baseRealm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            throw new UnsupportedOperationException(PRIMITIVE_LISTS_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        this.schema = this.realm.getSchema().getSchemaForClass(clazz);
        this.table = queryResults.getTable();
        this.osCollection = null;
        this.query = queryResults.getOsResults().where();
    }

    private RealmQuery(BaseRealm realm, OsList osList, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            throw new UnsupportedOperationException(PRIMITIVE_LISTS_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        this.schema = realm.getSchema().getSchemaForClass(clazz);
        this.table = this.schema.getTable();
        this.osCollection = osList;
        this.query = osList.getQuery();
    }

    RealmQuery(BaseRealm realm, OsSet osSet, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            throw new UnsupportedOperationException(PRIMITIVE_LISTS_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        this.schema = realm.getSchema().getSchemaForClass(clazz);
        this.table = this.schema.getTable();
        this.osCollection = osSet;
        this.query = osSet.getQuery();
    }

    private RealmQuery(BaseRealm realm, String className) {
        this.realm = realm;
        this.className = className;
        this.forValues = false;
        this.schema = realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = this.table.where();
        this.osCollection = null;
    }

    private RealmQuery(RealmResults<DynamicRealmObject> queryResults, String className) {
        this.realm = queryResults.baseRealm;
        this.className = className;
        this.forValues = false;
        this.schema = this.realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = queryResults.getOsResults().where();
        this.osCollection = null;
    }

    private RealmQuery(BaseRealm realm, OsList osList, String className) {
        this.realm = realm;
        this.className = className;
        this.forValues = false;
        this.schema = realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = osList.getQuery();
        this.osCollection = osList;
    }

    public boolean isValid() {
        if (this.realm == null || this.realm.isClosed()) {
            return false;
        }
        if (this.osCollection != null) {
            return this.osCollection.isValid();
        }
        return this.table != null && this.table.isValid();
    }

    public RealmQuery<E> isNull(String fieldName) {
        this.realm.checkIfValid();
        this.query.isNull(this.realm.getSchema().getKeyPathMapping(), fieldName);
        return this;
    }

    public RealmQuery<E> isNotNull(String fieldName) {
        this.realm.checkIfValid();
        this.query.isNotNull(this.realm.getSchema().getKeyPathMapping(), fieldName);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable String value) {
        return this.equalTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable String value, Case casing) {
        this.realm.checkIfValid();
        this.equalTo(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.equalToInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Decimal128 value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable ObjectId value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable UUID value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Byte value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable byte[] value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Short value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Integer value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Long value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Double value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Float value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Boolean value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Date value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.equalTo(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable String[] values) {
        return this.in(fieldName, values, Case.SENSITIVE);
    }

    public RealmQuery<E> in(String fieldName, @Nullable String[] values, Case casing) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = values[i] != null ? RealmAny.valueOf(values[i]) : null;
            }
            if (casing == Case.SENSITIVE) {
                this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
            } else {
                this.query.inInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
            }
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Byte[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Short[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Integer[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Long[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Double[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Float[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Boolean[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable Date[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = RealmAny.valueOf(values[i]);
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> in(String fieldName, RealmAny[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
        } else {
            RealmAny[] realmAnyValues = new RealmAny[values.length];
            for (int i = 0; i < values.length; ++i) {
                realmAnyValues[i] = values[i] == null ? RealmAny.nullValue() : values[i];
            }
            this.query.in(this.realm.getSchema().getKeyPathMapping(), fieldName, realmAnyValues);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable String value) {
        return this.notEqualTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable String value, Case casing) {
        this.realm.checkIfValid();
        this.notEqualTo(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.notEqualToInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Decimal128 value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, ObjectId value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, UUID value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.notEqualTo(fieldName, value, Case.SENSITIVE);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Byte value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable byte[] value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Short value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Integer value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Long value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Double value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Float value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Boolean value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Date value) {
        this.realm.checkIfValid();
        this.query.notEqualTo(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, int value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, long value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, double value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, float value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(Float.valueOf(value)));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Date value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Decimal128 value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, ObjectId value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, UUID value) {
        this.realm.checkIfValid();
        this.query.greaterThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, int value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, long value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, double value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, float value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(Float.valueOf(value)));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Date value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Decimal128 value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, ObjectId value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, UUID value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.greaterThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, int value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, long value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Decimal128 value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, ObjectId value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, UUID value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, double value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, float value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(Float.valueOf(value)));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Date value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.lessThan(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, int value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, long value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Decimal128 value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, ObjectId value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, UUID value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, double value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, float value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(Float.valueOf(value)));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Date value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.lessThanOrEqual(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> between(String fieldName, int from2, int to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(from2), RealmAny.valueOf(to));
        return this;
    }

    public RealmQuery<E> between(String fieldName, long from2, long to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(from2), RealmAny.valueOf(to));
        return this;
    }

    public RealmQuery<E> between(String fieldName, double from2, double to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(from2), RealmAny.valueOf(to));
        return this;
    }

    public RealmQuery<E> between(String fieldName, float from2, float to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(Float.valueOf(from2)), RealmAny.valueOf(Float.valueOf(to)));
        return this;
    }

    public RealmQuery<E> between(String fieldName, Date from2, Date to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(from2), RealmAny.valueOf(to));
        return this;
    }

    public RealmQuery<E> between(String fieldName, RealmAny from2, RealmAny to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, from2, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, Decimal128 from2, Decimal128 to) {
        this.realm.checkIfValid();
        this.query.between(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(from2), RealmAny.valueOf(to));
        return this;
    }

    public RealmQuery<E> contains(String fieldName, String value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> contains(String fieldName, RealmAny value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> contains(String fieldName, String value, Case casing) {
        Util.checkNull(value, "value");
        this.realm.checkIfValid();
        this.contains(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> contains(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.contains(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.containsInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, String value) {
        return this.beginsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> beginsWith(String fieldName, RealmAny value) {
        return this.beginsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> beginsWith(String fieldName, String value, Case casing) {
        Util.checkNull(value, "value");
        this.realm.checkIfValid();
        this.beginsWith(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.beginsWith(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.beginsWithInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> endsWith(String fieldName, RealmAny value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> endsWith(String fieldName, String value, Case casing) {
        Util.checkNull(value, "value");
        this.realm.checkIfValid();
        this.endsWith(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.endsWith(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.endsWithInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> like(String fieldName, String value) {
        return this.like(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> like(String fieldName, RealmAny value) {
        return this.like(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> like(String fieldName, String value, Case casing) {
        Util.checkNull(value, "value");
        this.realm.checkIfValid();
        this.like(fieldName, RealmAny.valueOf(value), casing);
        return this;
    }

    public RealmQuery<E> like(String fieldName, RealmAny value, Case casing) {
        this.realm.checkIfValid();
        if (casing == Case.SENSITIVE) {
            this.query.like(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        } else {
            this.query.likeInsensitive(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        }
        return this;
    }

    public RealmQuery<E> beginGroup() {
        this.realm.checkIfValid();
        this.query.beginGroup();
        return this;
    }

    public RealmQuery<E> endGroup() {
        this.realm.checkIfValid();
        this.query.endGroup();
        return this;
    }

    public RealmQuery<E> or() {
        this.realm.checkIfValid();
        this.query.or();
        return this;
    }

    public RealmQuery<E> and() {
        this.realm.checkIfValid();
        return this;
    }

    public RealmQuery<E> not() {
        this.realm.checkIfValid();
        this.query.not();
        return this;
    }

    public RealmQuery<E> isEmpty(String fieldName) {
        this.realm.checkIfValid();
        this.query.isEmpty(this.realm.getSchema().getKeyPathMapping(), fieldName);
        return this;
    }

    public RealmQuery<E> isNotEmpty(String fieldName) {
        this.realm.checkIfValid();
        this.query.isNotEmpty(this.realm.getSchema().getKeyPathMapping(), fieldName);
        return this;
    }

    public RealmQuery<E> containsKey(String fieldName, @Nullable String key) {
        this.realm.checkIfValid();
        this.query.containsKey(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(key));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Boolean value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Byte value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Short value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Integer value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Long value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Double value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Float value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable String value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable byte[] value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Date value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable Decimal128 value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable ObjectId value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, @Nullable UUID value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, RealmAny value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, value);
        return this;
    }

    public RealmQuery<E> containsValue(String fieldName, RealmModel value) {
        this.realm.checkIfValid();
        this.query.containsValue(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(value));
        return this;
    }

    public RealmQuery<E> containsEntry(String fieldName, Map.Entry<String, ?> entry) {
        Util.checkNull(entry, "entry");
        this.realm.checkIfValid();
        this.query.containsEntry(this.realm.getSchema().getKeyPathMapping(), fieldName, RealmAny.valueOf(entry.getKey()), RealmAny.valueOf(entry.getValue()));
        return this;
    }

    public Number sum(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnKey = this.schema.getAndCheckFieldColumnKey(fieldName);
        switch (this.table.getColumnType(columnKey)) {
            case INTEGER: {
                return this.query.sumInt(columnKey);
            }
            case FLOAT: {
                return this.query.sumFloat(columnKey);
            }
            case DOUBLE: {
                return this.query.sumDouble(columnKey);
            }
            case DECIMAL128: {
                return this.query.sumDecimal128(columnKey);
            }
            case MIXED: {
                return this.query.sumRealmAny(columnKey);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public double average(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.averageInt(columnIndex);
            }
            case DOUBLE: {
                return this.query.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.query.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double. For Decimal128 use `averageDecimal128` method."));
    }

    @Nullable
    public Decimal128 averageDecimal128(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return this.query.averageDecimal128(columnIndex);
    }

    @Nullable
    public Decimal128 averageRealmAny(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return this.query.averageRealmAny(columnIndex);
    }

    @Nullable
    public Number min(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.minimumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.minimumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.minimumDouble(columnIndex);
            }
            case DECIMAL128: {
                return this.query.minimumDecimal128(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Nullable
    public Date minimumDate(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return this.query.minimumDate(columnIndex);
    }

    public RealmAny minRealmAny(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.realm, this.query.minimumRealmAny(columnIndex)));
    }

    @Nullable
    public Number max(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.maximumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.maximumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.maximumDouble(columnIndex);
            }
            case DECIMAL128: {
                return this.query.maximumDecimal128(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Nullable
    public Date maximumDate(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return this.query.maximumDate(columnIndex);
    }

    public RealmAny maxRealmAny(String fieldName) {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        long columnIndex = this.schema.getAndCheckFieldColumnKey(fieldName);
        return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.realm, this.query.maximumRealmAny(columnIndex)));
    }

    public long count() {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        return this.lazyFindAll().size();
    }

    public RealmResults<E> findAll() {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        return this.createRealmResults(this.query, true);
    }

    private OsResults lazyFindAll() {
        this.realm.checkIfValid();
        return this.createRealmResults((TableQuery)this.query, (boolean)false).osResults;
    }

    public RealmResults<E> findAllAsync() {
        this.realm.checkIfValid();
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification(ASYNC_QUERY_WRONG_THREAD_MESSAGE);
        return this.createRealmResults(this.query, false);
    }

    public RealmQuery<E> sort(String fieldName) {
        this.realm.checkIfValid();
        return this.sort(fieldName, Sort.ASCENDING);
    }

    public RealmQuery<E> sort(String fieldName, Sort sortOrder) {
        this.realm.checkIfValid();
        return this.sort(new String[]{fieldName}, new Sort[]{sortOrder});
    }

    public RealmQuery<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        this.realm.checkIfValid();
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public RealmQuery<E> sort(String[] fieldNames, Sort[] sortOrders) {
        if (sortOrders == null || sortOrders.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sort order.");
        }
        if (fieldNames.length != sortOrders.length) {
            throw new IllegalArgumentException("Number of fields and sort orders do not match.");
        }
        this.realm.checkIfValid();
        this.query.sort(this.realm.getSchema().getKeyPathMapping(), fieldNames, sortOrders);
        return this;
    }

    public RealmQuery<E> distinct(String firstFieldName, String ... remainingFieldNames) {
        this.realm.checkIfValid();
        String[] fieldNames = new String[1 + remainingFieldNames.length];
        fieldNames[0] = firstFieldName;
        for (int i = 0; i < remainingFieldNames.length; ++i) {
            fieldNames[1 + i] = remainingFieldNames[0];
        }
        this.query.distinct(this.realm.getSchema().getKeyPathMapping(), fieldNames);
        return this;
    }

    public RealmQuery<E> limit(long limit) {
        this.realm.checkIfValid();
        this.query.limit(limit);
        return this;
    }

    public RealmQuery<E> alwaysTrue() {
        this.realm.checkIfValid();
        this.query.alwaysTrue();
        return this;
    }

    public RealmQuery<E> alwaysFalse() {
        this.realm.checkIfValid();
        this.query.alwaysFalse();
        return this;
    }

    public RealmQuery<E> rawPredicate(String predicate, Object ... arguments) {
        this.realm.checkIfValid();
        if (Util.isEmptyString(predicate)) {
            throw new IllegalArgumentException("Non-null 'predicate' required.");
        }
        RealmAny[] realmAnyArgs = new RealmAny[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            realmAnyArgs[i] = RealmAny.valueOf(arguments[i]);
        }
        this.query.rawPredicate(this.realm.getSchema().getKeyPathMapping(), predicate, realmAnyArgs);
        return this;
    }

    public Realm getRealm() {
        if (this.realm == null) {
            return null;
        }
        this.realm.checkIfValid();
        if (!(this.realm instanceof Realm)) {
            throw new IllegalStateException("This method is only available for typed Realms");
        }
        return (Realm)this.realm;
    }

    public String getDescription() {
        this.query.validateQuery();
        return RealmQuery.nativeSerializeQuery(this.query.getNativePtr());
    }

    public String getTypeQueried() {
        return this.table.getClassName();
    }

    private boolean isDynamicQuery() {
        return this.className != null;
    }

    @Nullable
    public E findFirst() {
        this.realm.checkIfValid();
        this.realm.checkAllowQueriesOnUiThread();
        if (this.forValues) {
            return null;
        }
        long tableRowIndex = this.getSourceRowIndexForFirstObject();
        return tableRowIndex < 0L ? null : (E)this.realm.get(this.clazz, this.className, tableRowIndex);
    }

    public E findFirstAsync() {
        DynamicRealmObject result;
        this.realm.checkIfValid();
        if (this.forValues) {
            throw new UnsupportedOperationException("findFirstAsync() available only when type parameter 'E' is implementing RealmModel.");
        }
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification(ASYNC_QUERY_WRONG_THREAD_MESSAGE);
        Row row = this.realm.isInTransaction() ? OsResults.createFromQuery(this.realm.sharedRealm, this.query).firstUncheckedRow() : new PendingRow(this.realm.sharedRealm, this.query, this.isDynamicQuery());
        if (this.isDynamicQuery()) {
            result = new DynamicRealmObject(this.realm, row);
        } else {
            Class<E> modelClass = this.clazz;
            result = this.realm.getConfiguration().getSchemaMediator().newInstance(modelClass, this.realm, row, this.realm.getSchema().getColumnInfo(modelClass), false, Collections.emptyList());
        }
        if (row instanceof PendingRow) {
            RealmObjectProxy proxy = result;
            ((PendingRow)row).setFrontEnd(proxy.realmGet$proxyState());
        }
        return (E)result;
    }

    private RealmResults<E> createRealmResults(TableQuery query, boolean loadResults) {
        OsResults osResults = OsResults.createFromQuery(this.realm.sharedRealm, query);
        RealmResults results = this.isDynamicQuery() ? new RealmResults(this.realm, osResults, this.className) : new RealmResults<E>(this.realm, osResults, this.clazz);
        if (loadResults) {
            results.load();
        }
        return results;
    }

    private long getSourceRowIndexForFirstObject() {
        return this.query.find();
    }

    private static native String nativeSerializeQuery(long var0);
}

