/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.MapChangeListener;
import io.realm.MapChangeSet;
import io.realm.RealmChangeListener;
import io.realm.RealmMap;
import io.realm.internal.Keep;
import io.realm.internal.ObserverPairList;
import org.jetbrains.annotations.Nullable;

@Keep
public interface ObservableMap {
    public void notifyChangeListeners(long var1);

    public static class Callback<K, V>
    implements ObserverPairList.Callback<MapObserverPair<K, V>> {
        private final MapChangeSet<K> changeSet;

        public Callback(MapChangeSet<K> changeSet) {
            this.changeSet = changeSet;
        }

        @Override
        public void onCalled(MapObserverPair<K, V> pair, Object observer) {
            pair.onChange(observer, this.changeSet);
        }
    }

    public static class RealmChangeListenerWrapper<K, V>
    implements MapChangeListener<K, V> {
        private final RealmChangeListener<RealmMap<K, V>> listener;

        public RealmChangeListenerWrapper(RealmChangeListener<RealmMap<K, V>> listener2) {
            this.listener = listener2;
        }

        @Override
        public void onChange(RealmMap<K, V> map, @Nullable MapChangeSet<K> changes) {
            this.listener.onChange(map);
        }

        public boolean equals(Object o) {
            return o instanceof RealmChangeListenerWrapper && this.listener == ((RealmChangeListenerWrapper)o).listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    public static class MapObserverPair<K, V>
    extends ObserverPairList.ObserverPair<RealmMap<K, V>, Object> {
        public MapObserverPair(RealmMap<K, V> observer, MapChangeListener<K, V> listener2) {
            super(observer, listener2);
        }

        public void onChange(Object observer, MapChangeSet<K> changes) {
            ((MapChangeListener)this.listener).onChange((RealmMap)observer, changes);
        }
    }
}

