/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmConfiguration;
import io.realm.RealmFieldType;
import io.realm.internal.Capabilities;
import io.realm.internal.IOException;
import io.realm.internal.Keep;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.OsResults;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.PendingRow;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Table;
import io.realm.internal.Util;
import io.realm.internal.android.AndroidCapabilities;
import io.realm.internal.android.AndroidRealmNotifier;
import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

@Keep
public final class OsSharedRealm
implements Closeable,
NativeObject {
    public static final byte FILE_EXCEPTION_KIND_ACCESS_ERROR = 0;
    public static final byte FILE_EXCEPTION_KIND_BAD_HISTORY = 1;
    public static final byte FILE_EXCEPTION_KIND_PERMISSION_DENIED = 2;
    public static final byte FILE_EXCEPTION_KIND_EXISTS = 3;
    public static final byte FILE_EXCEPTION_KIND_NOT_FOUND = 4;
    public static final byte FILE_EXCEPTION_KIND_INCOMPATIBLE_LOCK_FILE = 5;
    public static final byte FILE_EXCEPTION_KIND_FORMAT_UPGRADE_REQUIRED = 6;
    public static final byte FILE_EXCEPTION_INCOMPATIBLE_SYNC_FILE = 7;
    private static final long nativeFinalizerPtr = OsSharedRealm.nativeGetFinalizerPtr();
    private final long nativePtr;
    private final OsRealmConfig osRealmConfig;
    public final NativeContext context;
    private final OsSchemaInfo schemaInfo;
    private static volatile File temporaryDirectory;
    public final RealmNotifier realmNotifier;
    public final Capabilities capabilities;
    private static final List<OsSharedRealm> sharedRealmsUnderConstruction;
    private final List<OsSharedRealm> tempSharedRealmsForCallback = new ArrayList<OsSharedRealm>();
    private final List<WeakReference<PendingRow>> pendingRows = new CopyOnWriteArrayList<WeakReference<PendingRow>>();
    final List<WeakReference<OsResults.Iterator>> iterators = new ArrayList<WeakReference<OsResults.Iterator>>();

    private OsSharedRealm(OsRealmConfig osRealmConfig, VersionID version) {
        AndroidCapabilities capabilities = new AndroidCapabilities();
        AndroidRealmNotifier realmNotifier = new AndroidRealmNotifier(this, capabilities);
        this.context = osRealmConfig.getContext();
        sharedRealmsUnderConstruction.add(this);
        try {
            this.nativePtr = OsSharedRealm.nativeGetSharedRealm(osRealmConfig.getNativePtr(), version.version, version.index, realmNotifier);
        }
        catch (Throwable t) {
            for (OsSharedRealm sharedRealm : this.tempSharedRealmsForCallback) {
                if (sharedRealm.isClosed()) continue;
                sharedRealm.close();
            }
            throw t;
        }
        finally {
            this.tempSharedRealmsForCallback.clear();
            sharedRealmsUnderConstruction.remove(this);
        }
        this.osRealmConfig = osRealmConfig;
        this.schemaInfo = new OsSchemaInfo(OsSharedRealm.nativeGetSchemaInfo(this.nativePtr), this);
        this.context.addReference(this);
        this.capabilities = capabilities;
        this.realmNotifier = realmNotifier;
        if (version.equals(VersionID.LIVE)) {
            OsSharedRealm.nativeSetAutoRefresh(this.nativePtr, capabilities.canDeliverNotification());
        }
    }

    private OsSharedRealm(long nativeSharedRealmPtr, OsRealmConfig osRealmConfig) {
        this.nativePtr = nativeSharedRealmPtr;
        this.osRealmConfig = osRealmConfig;
        this.schemaInfo = new OsSchemaInfo(OsSharedRealm.nativeGetSchemaInfo(this.nativePtr), this);
        this.context = osRealmConfig.getContext();
        this.context.addReference(this);
        this.capabilities = new AndroidCapabilities();
        this.realmNotifier = null;
        OsSharedRealm.nativeSetAutoRefresh(this.nativePtr, false);
        boolean foundParentSharedRealm = false;
        for (OsSharedRealm sharedRealm : sharedRealmsUnderConstruction) {
            if (sharedRealm.context != osRealmConfig.getContext()) continue;
            foundParentSharedRealm = true;
            sharedRealm.tempSharedRealmsForCallback.add(this);
            break;
        }
        if (!foundParentSharedRealm) {
            throw new IllegalStateException("Cannot find the parent 'OsSharedRealm' which is under construction.");
        }
    }

    public static OsSharedRealm getInstance(RealmConfiguration config, VersionID version) {
        OsRealmConfig.Builder builder = new OsRealmConfig.Builder(config);
        return OsSharedRealm.getInstance(builder, version);
    }

    public static OsSharedRealm getInstance(OsRealmConfig.Builder configBuilder, VersionID version) {
        OsRealmConfig osRealmConfig = configBuilder.build();
        ObjectServerFacade.getSyncFacadeIfPossible().wrapObjectStoreSessionIfRequired(osRealmConfig);
        return new OsSharedRealm(osRealmConfig, version);
    }

    public static void initialize(File tempDirectory) {
        if (temporaryDirectory != null) {
            return;
        }
        String temporaryDirectoryPath = tempDirectory.getAbsolutePath();
        if (!(tempDirectory.isDirectory() || tempDirectory.mkdirs() || tempDirectory.isDirectory())) {
            throw new IOException("failed to create temporary directory: " + temporaryDirectoryPath);
        }
        if (!temporaryDirectoryPath.endsWith("/")) {
            temporaryDirectoryPath = temporaryDirectoryPath + "/";
        }
        OsSharedRealm.nativeInit(temporaryDirectoryPath);
        temporaryDirectory = tempDirectory;
    }

    public static File getTemporaryDirectory() {
        return temporaryDirectory;
    }

    public void beginTransaction() {
        this.detachIterators();
        this.executePendingRowQueries();
        OsSharedRealm.nativeBeginTransaction(this.nativePtr);
    }

    public void commitTransaction() {
        OsSharedRealm.nativeCommitTransaction(this.nativePtr);
    }

    public void cancelTransaction() {
        OsSharedRealm.nativeCancelTransaction(this.nativePtr);
    }

    public boolean isInTransaction() {
        return OsSharedRealm.nativeIsInTransaction(this.nativePtr);
    }

    public boolean hasTable(String name) {
        return OsSharedRealm.nativeHasTable(this.nativePtr, name);
    }

    public Table getTable(String name) {
        long tableRefPtr = OsSharedRealm.nativeGetTableRef(this.nativePtr, name);
        return new Table(this, tableRefPtr);
    }

    public Table createTable(String name) {
        return new Table(this, OsSharedRealm.nativeCreateTable(this.nativePtr, name));
    }

    public Table createTableWithPrimaryKey(String tableName, String primaryKeyFieldName, RealmFieldType primaryKeyFieldType, boolean isNullable) {
        return new Table(this, OsSharedRealm.nativeCreateTableWithPrimaryKeyField(this.nativePtr, tableName, primaryKeyFieldName, primaryKeyFieldType.getNativeValue(), isNullable));
    }

    public void renameTable(String oldName, String newName) {
        OsSharedRealm.nativeRenameTable(this.nativePtr, oldName, newName);
    }

    public String[] getTablesNames() {
        String[] names = OsSharedRealm.nativeGetTablesName(this.nativePtr);
        return names != null ? names : new String[]{};
    }

    public long size() {
        return OsSharedRealm.nativeSize(this.nativePtr);
    }

    public String getPath() {
        return this.osRealmConfig.getRealmConfiguration().getPath();
    }

    public boolean isEmpty() {
        return OsSharedRealm.nativeIsEmpty(this.nativePtr);
    }

    public void refresh() {
        if (this.isFrozen()) {
            throw new IllegalStateException("It is not possible to refresh frozen Realms.");
        }
        OsSharedRealm.nativeRefresh(this.nativePtr);
    }

    public VersionID getVersionID() {
        long[] versionId = OsSharedRealm.nativeGetVersionID(this.nativePtr);
        if (versionId == null) {
            throw new IllegalStateException("Cannot get versionId, this could be related to a non existing read/write transaction");
        }
        return new VersionID(versionId[0], versionId[1]);
    }

    public boolean isClosed() {
        return OsSharedRealm.nativeIsClosed(this.nativePtr);
    }

    public void writeCopy(File file, @Nullable byte[] key) {
        if (file.isFile() && file.exists()) {
            throw new IllegalArgumentException("The destination file must not exist");
        }
        if (this.isSyncRealm()) {
            Util.checkNotOnMainThread("writeCopyTo() cannot be called from the main thread when using synchronized Realms.");
        }
        try {
            OsSharedRealm.nativeWriteCopy(this.nativePtr, file.getAbsolutePath(), key);
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            if (msg.contains("Could not write file as not all client changes are integrated in server")) {
                throw new IllegalStateException(msg);
            }
            throw e;
        }
    }

    public boolean compact() {
        return OsSharedRealm.nativeCompact(this.nativePtr);
    }

    public void setAutoRefresh(boolean enabled) {
        this.capabilities.checkCanDeliverNotification(null);
        OsSharedRealm.nativeSetAutoRefresh(this.nativePtr, enabled);
    }

    public boolean waitForChange() {
        return OsSharedRealm.nativeWaitForChange(this.nativePtr);
    }

    public void stopWaitForChange() {
        OsSharedRealm.nativeStopWaitForChange(this.nativePtr);
    }

    public boolean isAutoRefresh() {
        return OsSharedRealm.nativeIsAutoRefresh(this.nativePtr);
    }

    public RealmConfiguration getConfiguration() {
        return this.osRealmConfig.getRealmConfiguration();
    }

    public long getNumberOfVersions() {
        return OsSharedRealm.nativeNumberOfVersions(this.nativePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.realmNotifier != null) {
            this.realmNotifier.close();
        }
        NativeContext nativeContext = this.context;
        synchronized (nativeContext) {
            OsSharedRealm.nativeCloseSharedRealm(this.nativePtr);
        }
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public OsSchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void registerSchemaChangedCallback(SchemaChangedCallback callback) {
        OsSharedRealm.nativeRegisterSchemaChangedCallback(this.nativePtr, callback);
    }

    public boolean isSyncRealm() {
        return this.osRealmConfig.getResolvedRealmURI() != null;
    }

    public boolean isFrozen() {
        return OsSharedRealm.nativeIsFrozen(this.nativePtr);
    }

    public OsSharedRealm freeze() {
        return new OsSharedRealm(this.osRealmConfig, this.getVersionID());
    }

    void addIterator(OsResults.Iterator iterator) {
        this.iterators.add(new WeakReference<OsResults.Iterator>(iterator));
    }

    private void detachIterators() {
        for (WeakReference<OsResults.Iterator> iteratorRef : this.iterators) {
            OsResults.Iterator iterator = (OsResults.Iterator)iteratorRef.get();
            if (iterator == null) continue;
            iterator.detach();
        }
        this.iterators.clear();
    }

    void invalidateIterators() {
        for (WeakReference<OsResults.Iterator> iteratorRef : this.iterators) {
            OsResults.Iterator iterator = (OsResults.Iterator)iteratorRef.get();
            if (iterator == null) continue;
            iterator.invalidate();
        }
        this.iterators.clear();
    }

    void addPendingRow(PendingRow pendingRow) {
        this.pendingRows.add(new WeakReference<PendingRow>(pendingRow));
    }

    void removePendingRow(PendingRow pendingRow) {
        for (WeakReference<PendingRow> ref : this.pendingRows) {
            PendingRow row = (PendingRow)ref.get();
            if (row != null && row != pendingRow) continue;
            this.pendingRows.remove(ref);
        }
    }

    private void executePendingRowQueries() {
        for (WeakReference<PendingRow> ref : this.pendingRows) {
            PendingRow row = (PendingRow)ref.get();
            if (row == null) continue;
            row.executeQuery();
        }
        this.pendingRows.clear();
    }

    private static void runMigrationCallback(long nativeSharedRealmPtr, OsRealmConfig osRealmConfig, MigrationCallback callback, long oldVersion) {
        callback.onMigrationNeeded(new OsSharedRealm(nativeSharedRealmPtr, osRealmConfig), oldVersion, osRealmConfig.getRealmConfiguration().getSchemaVersion());
    }

    private static void runInitializationCallback(long nativeSharedRealmPtr, OsRealmConfig osRealmConfig, InitializationCallback callback) {
        callback.onInit(new OsSharedRealm(nativeSharedRealmPtr, osRealmConfig));
    }

    private static native void nativeInit(String var0);

    private static native long nativeGetSharedRealm(long var0, long var2, long var4, RealmNotifier var6);

    private static native void nativeCloseSharedRealm(long var0);

    private static native boolean nativeIsClosed(long var0);

    private static native void nativeBeginTransaction(long var0);

    private static native void nativeCommitTransaction(long var0);

    private static native void nativeCancelTransaction(long var0);

    private static native boolean nativeIsInTransaction(long var0);

    private static native boolean nativeIsEmpty(long var0);

    private static native void nativeRefresh(long var0);

    private static native long[] nativeGetVersionID(long var0);

    private static native long nativeGetTableRef(long var0, String var2);

    private static native long nativeCreateTable(long var0, String var2);

    private static native long nativeCreateTableWithPrimaryKeyField(long var0, String var2, String var3, int var4, boolean var5);

    private static native String[] nativeGetTablesName(long var0);

    private static native boolean nativeHasTable(long var0, String var2);

    private static native void nativeRenameTable(long var0, String var2, String var3);

    private static native long nativeSize(long var0);

    private static native void nativeWriteCopy(long var0, String var2, @Nullable byte[] var3);

    private static native boolean nativeWaitForChange(long var0);

    private static native void nativeStopWaitForChange(long var0);

    private static native boolean nativeCompact(long var0);

    private static native void nativeSetAutoRefresh(long var0, boolean var2);

    private static native boolean nativeIsAutoRefresh(long var0);

    private static native long nativeGetFinalizerPtr();

    private static native long nativeGetSchemaInfo(long var0);

    private static native void nativeRegisterSchemaChangedCallback(long var0, SchemaChangedCallback var2);

    private static native boolean nativeIsFrozen(long var0);

    private static native long nativeFreeze(long var0);

    private static native long nativeNumberOfVersions(long var0);

    static {
        sharedRealmsUnderConstruction = new CopyOnWriteArrayList<OsSharedRealm>();
    }

    @Keep
    public static interface SchemaChangedCallback {
        public void onSchemaChanged();
    }

    @Keep
    public static interface InitializationCallback {
        public void onInit(OsSharedRealm var1);
    }

    @Keep
    public static interface MigrationCallback {
        public void onMigrationNeeded(OsSharedRealm var1, long var2, long var4);
    }

    public static class VersionID
    implements Comparable<VersionID> {
        public static final VersionID LIVE = new VersionID(-1L, -1L);
        public final long version;
        public final long index;

        VersionID(long version, long index) {
            this.version = version;
            this.index = index;
        }

        @Override
        public int compareTo(VersionID another) {
            if (another == null) {
                throw new IllegalArgumentException("Version cannot be compared to a null value.");
            }
            if (this.version > another.version) {
                return 1;
            }
            if (this.version < another.version) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "VersionID{version=" + this.version + ", index=" + this.index + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            VersionID versionID = (VersionID)object;
            return this.version == versionID.version && this.index == versionID.index;
        }

        public int hashCode() {
            int result = (int)(this.version ^ this.version >>> 32);
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            return result;
        }
    }
}

