/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import io.realm.annotations.RealmClass;
import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.IncrementalBuild;
import io.realm.transformer.ext.CtClassExtKt;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.work.FileChange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0014J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0014J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0016R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/realm/transformer/build/IncrementalBuild;", "Lio/realm/transformer/build/BuildTemplate;", "metadata", "Lio/realm/transformer/ProjectMetaData;", "fileChanges", "", "Lorg/gradle/work/FileChange;", "inputJars", "", "Lorg/gradle/api/file/RegularFile;", "inputDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Ljava/nio/file/FileSystem;", "(Lio/realm/transformer/ProjectMetaData;Ljava/lang/Iterable;Ljava/util/List;Lorg/gradle/api/file/ConfigurableFileCollection;Ljava/nio/file/FileSystem;)V", "fileChangeMap", "", "", "filterForModelClasses", "", "outputClassNames", "", "outputReferencedClassNames", "findModelClasses", "Ljavassist/CtClass;", "classNames", "prepareOutputClasses", "processDeltas", "removeDeletedEntries", "transformDirectAccessToModelFields", "shouldCategorize", "", "Ljava/io/File;", "realm-transformer"})
public final class IncrementalBuild
extends BuildTemplate {
    @NotNull
    private final Iterable<FileChange> fileChanges;
    private Map<String, ? extends FileChange> fileChangeMap;

    public IncrementalBuild(@NotNull ProjectMetaData metadata, @NotNull Iterable<? extends FileChange> fileChanges, @NotNull List<? extends RegularFile> inputJars, @NotNull ConfigurableFileCollection inputDirectories, @NotNull FileSystem output) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(fileChanges, (String)"fileChanges");
        Intrinsics.checkNotNullParameter(inputJars, (String)"inputJars");
        Intrinsics.checkNotNullParameter((Object)inputDirectories, (String)"inputDirectories");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(metadata, inputJars, output, inputDirectories);
        this.fileChanges = fileChanges;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeDeletedEntries() {
        Iterable $this$forEach$iv = (Iterable)this.getInputs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            String dirPath;
            File directory = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)directory.getAbsolutePath(), (String)"directory.absolutePath");
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(this.fileChanges), (Function1)removeDeletedEntries.1.1.INSTANCE), (Function1)removeDeletedEntries.1.2.INSTANCE), (Function1)removeDeletedEntries.1.3.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(dirPath){
                final /* synthetic */ String $dirPath;
                {
                    this.$dirPath = $dirPath;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(File file) {
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    return FilesKt.startsWith((File)file, (String)this.$dirPath);
                }
            })), (Function1)((Function1)new Function1<File, String>(this, dirPath){
                final /* synthetic */ IncrementalBuild this$0;
                final /* synthetic */ String $dirPath;
                {
                    this.this$0 = $receiver;
                    this.$dirPath = $dirPath;
                    super(1);
                }

                @NotNull
                public final String invoke(File it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return this.this$0.categorize(it, this.$dirPath);
                }
            }));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String path = (String)element$iv2;
                boolean bl2 = false;
                String zipEntryPath = StringsKt.replace$default((String)path, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
                RealmTransformerKt.getLogger().debug("Deleting output entry: " + zipEntryPath);
                Path path2 = this.getOutput().getPath(zipEntryPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"output.getPath(zipEntryPath)");
                Files.deleteIfExists(path2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processDeltas() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Sequence sequence = CollectionsKt.asSequence(this.fileChanges);
        IncrementalBuild incrementalBuild = this;
        boolean $i$f$associateBy = false;
        void var3_4 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void details;
            FileChange fileChange = (FileChange)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = details.getFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"details.file.absolutePath");
            map.put(string, element$iv$iv);
        }
        incrementalBuild.fileChangeMap = destination$iv$iv;
        this.removeDeletedEntries();
    }

    @Override
    public void prepareOutputClasses() {
        this.processDeltas();
        this.setOutputClassNames(this.categorizeClassNames());
        RealmTransformerKt.getLogger().debug("Incremental build. Files being processed: " + this.getOutputClassNames().size() + ".");
        RealmTransformerKt.getLogger().debug("Incremental files: " + CollectionsKt.joinToString$default((Iterable)this.getOutputClassNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
    }

    @Override
    public boolean shouldCategorize(@NotNull File $this$shouldCategorize) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldCategorize, (String)"<this>");
        Map<String, ? extends FileChange> map = this.fileChangeMap;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileChangeMap");
            map = null;
        }
        Map<String, ? extends FileChange> map2 = map;
        return map2.containsKey($this$shouldCategorize.getAbsolutePath());
    }

    @Override
    protected void filterForModelClasses(@NotNull Set<String> outputClassNames, @NotNull Set<String> outputReferencedClassNames) {
        Intrinsics.checkNotNullParameter(outputClassNames, (String)"outputClassNames");
        Intrinsics.checkNotNullParameter(outputReferencedClassNames, (String)"outputReferencedClassNames");
        this.setOutputModelClasses(this.findModelClasses(outputClassNames));
    }

    @Override
    public void transformDirectAccessToModelFields() {
        Iterable $this$forEach$iv = this.getOutputClassNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass ctClass;
            String className = (String)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug("Modify accessors in class: " + className);
            Intrinsics.checkNotNullExpressionValue((Object)this.getClassPool().getCtClass(className), (String)"classPool.getCtClass(className)");
            BytecodeModifier.Companion.useRealmAccessors$default(BytecodeModifier.Companion, this.getClassPool(), ctClass, null, 4, null);
            this.getProcessedClasses().put(className, ctClass);
        }
    }

    @Override
    @NotNull
    protected List<CtClass> findModelClasses(@NotNull Set<String> classNames) {
        Iterable $this$filterTo$iv$iv;
        CtClass it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmObjectProxy");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026ternal.RealmObjectProxy\")");
        CtClass realmObjectProxyInterface = ctClass;
        Iterable $this$map$iv = classNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getClassPool().getCtClass((String)it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!(it.hasAnnotation(RealmClass.class) || CtClassExtKt.hasRealmClassAnnotation(it.getSuperclass()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!(!CtClassExtKt.safeSubtypeOf(it, realmObjectProxyInterface))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!(!it.getName().equals("io.realm.RealmObject"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

