/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageColorMatrixFilter
extends GPUImageFilter {
    public static final String COLOR_MATRIX_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform lowp mat4 colorMatrix;\nuniform lowp float intensity;\n\nvoid main()\n{\n    lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n    lowp vec4 outputColor = textureColor * colorMatrix;\n    \n    gl_FragColor = (intensity * outputColor) + ((1.0 - intensity) * textureColor);\n}";
    private float intensity;
    private float[] colorMatrix;
    private int colorMatrixLocation;
    private int intensityLocation;

    public GPUImageColorMatrixFilter() {
        this(1.0f, new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    public GPUImageColorMatrixFilter(float intensity, float[] colorMatrix) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", COLOR_MATRIX_FRAGMENT_SHADER);
        this.intensity = intensity;
        this.colorMatrix = colorMatrix;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.colorMatrixLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"colorMatrix");
        this.intensityLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"intensity");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setIntensity(this.intensity);
        this.setColorMatrix(this.colorMatrix);
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.setFloat(this.intensityLocation, intensity);
    }

    public void setColorMatrix(float[] colorMatrix) {
        this.colorMatrix = colorMatrix;
        this.setUniformMatrix4f(this.colorMatrixLocation, colorMatrix);
    }
}

