/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.core.wrapper.RecordWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class RecordHandler
implements IRecordHandler {
    protected final String TAG = CommonUtil.getClassName(this);
    @Deprecated
    private File mConfigFile;
    private TaskRecord mTaskRecord;
    private AbsTaskWrapper mTaskWrapper;
    private AbsNormalEntity mEntity;
    protected String mFilePath;
    protected long mFileSize;

    public RecordHandler(AbsTaskWrapper wrapper) {
        this.mTaskWrapper = wrapper;
        this.mEntity = (AbsNormalEntity)this.mTaskWrapper.getEntity();
    }

    public AbsTaskWrapper getWrapper() {
        return this.mTaskWrapper;
    }

    public AbsNormalEntity getEntity() {
        return this.mEntity;
    }

    @Override
    public void onPre() {
    }

    @Override
    public TaskRecord getRecord(long fileSize) {
        this.mFileSize = fileSize;
        this.mConfigFile = new File(CommonUtil.getFileConfigPath(false, this.mEntity.getFileName()));
        if (this.mConfigFile.exists()) {
            this.convertDb();
        } else {
            this.onPre();
            this.mTaskRecord = DbDataHelper.getTaskRecord(this.getFilePath(), this.mEntity.getTaskType());
            if (this.mTaskRecord == null) {
                this.initRecord(true);
            } else if (this.mTaskRecord.threadRecords == null || this.mTaskRecord.threadRecords.size() == 0) {
                if (this.mTaskRecord.threadRecords == null) {
                    this.mTaskRecord.threadRecords = new ArrayList<ThreadRecord>();
                }
                this.initRecord(false);
            }
            this.handlerTaskRecord(this.mTaskRecord);
        }
        this.saveRecord();
        return this.mTaskRecord;
    }

    private void convertDb() {
        List<RecordWrapper> records = DbEntity.findRelationData(RecordWrapper.class, "TaskRecord.filePath=?", this.getFilePath());
        if (records == null || records.size() == 0) {
            Properties pro = FileUtil.loadConfig(this.mConfigFile);
            if (pro.isEmpty()) {
                ALog.d(this.TAG, "\u8001\u7248\u672c\u7684\u7ebf\u7a0b\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4efb\u52a1\u4e3a\u65b0\u4efb\u52a1");
                this.initRecord(true);
                return;
            }
            Set<Object> keys = pro.keySet();
            HashSet<Integer> set = new HashSet<Integer>();
            for (Object key : keys) {
                String str = String.valueOf(key);
                int i = Integer.parseInt(str.substring(str.length() - 1));
                set.add(i);
            }
            int threadNum = set.size();
            if (threadNum == 0) {
                ALog.d(this.TAG, "\u7ebf\u7a0b\u6570\u4e3a\u7a7a\uff0c\u4efb\u52a1\u4e3a\u65b0\u4efb\u52a1");
                this.initRecord(true);
                return;
            }
            this.mTaskWrapper.setNewTask(false);
            this.mTaskRecord = this.createTaskRecord(threadNum);
            this.mTaskRecord.isBlock = false;
            File tempFile = new File(this.getFilePath());
            for (int i = 0; i < threadNum; ++i) {
                long temp;
                ThreadRecord tRecord = new ThreadRecord();
                tRecord.taskKey = this.mTaskRecord.filePath;
                String state = pro.getProperty(tempFile.getName() + "_state_" + i);
                String record = pro.getProperty(tempFile.getName() + "_record_" + i);
                if (state != null && Integer.parseInt(String.valueOf(state)) == 1) {
                    tRecord.isComplete = true;
                    continue;
                }
                tRecord.startLocation = record != null ? ((temp = Long.parseLong(String.valueOf(record))) > 0L ? temp : 0L) : 0L;
                this.mTaskRecord.threadRecords.add(tRecord);
            }
            FileUtil.deleteFile(this.mConfigFile);
        }
    }

    private void initRecord(boolean newRecord) {
        if (newRecord) {
            this.mTaskRecord = this.createTaskRecord(this.initTaskThreadNum());
        }
        this.mTaskWrapper.setNewTask(true);
        int requestType = this.mTaskWrapper.getRequestType();
        if (requestType == 8) {
            return;
        }
        long blockSize = this.getFileSize() / (long)this.mTaskRecord.threadNum;
        for (int i = 0; i < this.mTaskRecord.threadNum; ++i) {
            long startL = (long)i * blockSize;
            long endL = (long)(i + 1) * blockSize;
            ThreadRecord tr = this.createThreadRecord(this.mTaskRecord, i, startL, endL);
            this.mTaskRecord.threadRecords.add(tr);
        }
    }

    private void saveRecord() {
        this.mTaskRecord.threadNum = this.mTaskRecord.threadRecords.size();
        this.mTaskRecord.save();
        if (this.mTaskRecord.threadRecords != null && !this.mTaskRecord.threadRecords.isEmpty()) {
            DbEntity.saveAll(this.mTaskRecord.threadRecords);
        }
        ALog.d(this.TAG, String.format("\u4fdd\u5b58\u8bb0\u5f55\uff0c\u7ebf\u7a0b\u8bb0\u5f55\u6570\uff1a%s", this.mTaskRecord.threadRecords.size()));
    }

    protected long getFileSize() {
        return this.mFileSize;
    }

    private String getFilePath() {
        if (this.mEntity instanceof DownloadEntity) {
            return ((DownloadEntity)this.mTaskWrapper.getEntity()).getFilePath();
        }
        return ((UploadEntity)this.mTaskWrapper.getEntity()).getFilePath();
    }

    @Override
    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent(this);
    }

    @Override
    public boolean checkTaskCompleted() {
        if (this.mTaskRecord == null || this.mTaskRecord.threadRecords == null || this.mTaskRecord.threadRecords.isEmpty()) {
            return false;
        }
        int completeNum = 0;
        for (ThreadRecord tr : this.mTaskRecord.threadRecords) {
            if (!tr.isComplete) continue;
            ++completeNum;
        }
        return completeNum != 0 && completeNum == this.mTaskRecord.threadNum;
    }
}

