/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.BufferedRandomAccessFile;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class RecordHelper {
    private String TAG = CommonUtil.getClassName(this.getClass());
    private AbsTaskWrapper mWrapper;
    protected TaskRecord mTaskRecord;

    public RecordHelper(AbsTaskWrapper wrapper, TaskRecord record) {
        this.mWrapper = wrapper;
        this.mTaskRecord = record;
    }

    public void handleMultiRecord() {
        long blockSize = ((AbsEntity)this.mWrapper.getEntity()).getFileSize() / (long)this.mTaskRecord.threadRecords.size();
        File temp = new File(this.mTaskRecord.filePath);
        boolean fileExists = false;
        if (!temp.exists()) {
            this.createPlaceHolderFile(temp);
        } else {
            if (temp.length() != ((AbsEntity)this.mWrapper.getEntity()).getFileSize()) {
                FileUtil.deleteFile(temp);
                this.createPlaceHolderFile(temp);
            }
            fileExists = true;
        }
        if (!fileExists) {
            ALog.w(this.TAG, String.format("\u6587\u4ef6\u3010%s\u3011\u88ab\u5220\u9664\uff0c\u91cd\u65b0\u5206\u914d\u7ebf\u7a0b\u533a\u95f4", this.mTaskRecord.filePath));
            for (int i = 0; i < this.mTaskRecord.threadNum; ++i) {
                long startL = (long)i * blockSize;
                long endL = (long)(i + 1) * blockSize;
                ThreadRecord tr = this.mTaskRecord.threadRecords.get(i);
                tr.startLocation = startL;
                tr.isComplete = false;
                if (tr.threadId == this.mTaskRecord.threadNum - 1) {
                    endL = ((AbsEntity)this.mWrapper.getEntity()).getFileSize();
                }
                tr.endLocation = endL;
            }
        }
    }

    private void createPlaceHolderFile(File temp) {
        try {
            BufferedRandomAccessFile tempFile = new BufferedRandomAccessFile(temp, "rw");
            tempFile.setLength(((AbsEntity)this.mWrapper.getEntity()).getFileSize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleBlockRecord() {
        long normalRectLen = ((AbsEntity)this.mWrapper.getEntity()).getFileSize() / (long)this.mTaskRecord.threadRecords.size();
        for (ThreadRecord tr : this.mTaskRecord.threadRecords) {
            long threadRect = tr.blockLen;
            File temp = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, tr.threadId));
            if (!temp.exists()) {
                ALog.i(this.TAG, String.format("\u5206\u5757\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8be5\u5206\u5757\u5c06\u91cd\u65b0\u5f00\u59cb", temp.getPath()));
                tr.isComplete = false;
                tr.startLocation = (long)tr.threadId * normalRectLen;
                continue;
            }
            if (!tr.isComplete) {
                ALog.i(this.TAG, String.format("startLocation = %s; endLocation = %s; block = %s; tempLen = %s; threadId = %s", tr.startLocation, tr.endLocation, threadRect, temp.length(), tr.threadId));
                long blockFileLen = temp.length();
                if (blockFileLen > threadRect) {
                    ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u9519\u8bef\uff0c\u5206\u5757\u957f\u5ea6\u3010%s\u3011 > \u7ebf\u7a0b\u533a\u95f4\u957f\u5ea6\u3010%s\u3011\uff0c\u5c06\u91cd\u65b0\u5f00\u59cb\u8be5\u5206\u5757", tr.threadId, blockFileLen, threadRect));
                    temp.delete();
                    tr.startLocation = (long)tr.threadId * threadRect;
                    continue;
                }
                long realLocation = (long)tr.threadId * normalRectLen + blockFileLen;
                if (blockFileLen == threadRect && blockFileLen != 0L) {
                    ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u5df2\u5b8c\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55", temp.getPath()));
                    tr.startLocation = blockFileLen;
                    tr.isComplete = true;
                    continue;
                }
                if (tr.startLocation != realLocation) {
                    ALog.i(this.TAG, String.format("\u4fee\u6b63\u5206\u5757\u3010%s\u3011\u7684\u8fdb\u5ea6\u8bb0\u5f55\u4e3a\uff1a%s", temp.getPath(), realLocation));
                    tr.startLocation = realLocation;
                    continue;
                }
                ALog.i(this.TAG, String.format("\u4fee\u6b63\u5206\u5757\u3010%s\u3011\u7684\u8fdb\u5ea6\u8bb0\u5f55\u4e3a\uff1a%s", temp.getPath(), realLocation));
                tr.startLocation = realLocation;
                tr.isComplete = false;
                continue;
            }
            ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u5df2\u5b8c\u6210", temp.getPath()));
        }
    }

    public void handleSingleThreadRecord() {
        File file = new File(this.mTaskRecord.isBlock ? String.format("%s.%s.part", this.mTaskRecord.filePath, 0) : this.mTaskRecord.filePath);
        ThreadRecord tr = this.mTaskRecord.threadRecords.get(0);
        if (!file.exists()) {
            File targetFile = new File(this.mTaskRecord.filePath);
            if (tr.isComplete && targetFile.exists() && targetFile.length() != 0L && targetFile.length() == ((AbsEntity)this.mWrapper.getEntity()).getFileSize()) {
                tr.isComplete = true;
            } else {
                ALog.w(this.TAG, String.format("\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1\u5c06\u91cd\u65b0\u5f00\u59cb", file.getPath()));
                tr.startLocation = 0L;
                tr.isComplete = false;
                tr.endLocation = ((AbsEntity)this.mWrapper.getEntity()).getFileSize();
            }
        } else if (file.length() > ((AbsEntity)this.mWrapper.getEntity()).getFileSize()) {
            ALog.i(this.TAG, String.format("\u6587\u4ef6\u3010%s\u3011\u9519\u8bef\uff0c\u4efb\u52a1\u91cd\u65b0\u5f00\u59cb", file.getPath()));
            FileUtil.deleteFile(file);
            tr.startLocation = 0L;
            tr.isComplete = false;
            tr.endLocation = ((AbsEntity)this.mWrapper.getEntity()).getFileSize();
        } else if (file.length() != 0L && file.length() == ((AbsEntity)this.mWrapper.getEntity()).getFileSize()) {
            ALog.d(this.TAG, "\u6587\u4ef6\u957f\u5ea6\u4e00\u81f4\uff0c\u7ebf\u7a0b\u5b8c\u6210");
            tr.isComplete = true;
        } else if (file.length() != tr.startLocation) {
            ALog.i(this.TAG, String.format("\u4fee\u6b63\u3010%s\u3011\u7684\u8fdb\u5ea6\u8bb0\u5f55\u4e3a\uff1a%s", file.getPath(), file.length()));
            tr.startLocation = file.length();
            tr.isComplete = false;
        }
    }

    public void handleNoSupportBPRecord() {
        ThreadRecord tr = this.mTaskRecord.threadRecords.get(0);
        tr.startLocation = 0L;
        tr.endLocation = ((AbsEntity)this.mWrapper.getEntity()).getFileSize();
        tr.taskKey = this.mTaskRecord.filePath;
        tr.blockLen = tr.endLocation;
        tr.isComplete = false;
    }
}

