/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.config;

import com.arialyy.aria.core.config.BaseConfig;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.AriaCrashHandler;
import java.io.Serializable;

public class AppConfig
extends BaseConfig
implements Serializable {
    boolean useAriaCrashHandler;
    int logLevel;
    boolean netCheck = true;
    boolean useBroadcast = false;
    boolean notNetRetry = false;

    public boolean isNotNetRetry() {
        return this.notNetRetry;
    }

    public AppConfig setNotNetRetry(boolean notNetRetry) {
        this.notNetRetry = notNetRetry;
        this.save();
        return this;
    }

    public boolean isUseBroadcast() {
        return this.useBroadcast;
    }

    public AppConfig setUseBroadcast(boolean useBroadcast) {
        this.useBroadcast = useBroadcast;
        this.save();
        return this;
    }

    public boolean isNetCheck() {
        return this.netCheck;
    }

    public AppConfig setNetCheck(boolean netCheck) {
        this.netCheck = netCheck;
        this.save();
        return this;
    }

    public AppConfig setLogLevel(int level) {
        this.logLevel = level;
        ALog.LOG_LEVEL = level;
        this.save();
        return this;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean getUseAriaCrashHandler() {
        return this.useAriaCrashHandler;
    }

    public AppConfig setUseAriaCrashHandler(boolean useAriaCrashHandler) {
        this.useAriaCrashHandler = useAriaCrashHandler;
        if (useAriaCrashHandler) {
            Thread.setDefaultUncaughtExceptionHandler(new AriaCrashHandler());
        } else {
            Thread.setDefaultUncaughtExceptionHandler(null);
        }
        this.save();
        return this;
    }

    @Override
    int getType() {
        return 3;
    }
}

