/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.config;

import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.Serializable;

abstract class BaseConfig
implements Serializable {
    private static final String TAG = "BaseConfig";
    static final int TYPE_DOWNLOAD = 1;
    static final int TYPE_UPLOAD = 2;
    static final int TYPE_APP = 3;
    static final int TYPE_DGROUP = 4;

    BaseConfig() {
    }

    abstract int getType();

    void save() {
        String basePath = AriaConfig.getInstance().getAPP().getFilesDir().getPath();
        String path = null;
        switch (this.getType()) {
            case 1: {
                path = "/Aria/AriaDownload.cfg";
                break;
            }
            case 2: {
                path = "/Aria/AriaUpload.cfg";
                break;
            }
            case 3: {
                path = "/Aria/AriaApp.cfg";
                break;
            }
            case 4: {
                path = "/Aria/AriaDGroup.cfg";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            String tempPath = String.format("%s%s", basePath, path);
            FileUtil.deleteFile(tempPath);
            FileUtil.writeObjToFile(tempPath, this);
        } else {
            ALog.e(TAG, String.format("\u4fdd\u5b58\u914d\u7f6e\u5931\u8d25\uff0c\u914d\u7f6e\u7c7b\u578b\uff1a%s\uff0c\u539f\u56e0\uff1a\u8def\u5f84\u9519\u8bef", this.getType()));
        }
    }
}

