/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.config;

import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.config.BaseTaskConfig;
import com.arialyy.aria.core.config.DownloadConfig;
import com.arialyy.aria.core.event.DGMaxNumEvent;
import com.arialyy.aria.core.event.DSpeedEvent;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.util.ALog;
import java.io.Serializable;

public class DGroupConfig
extends BaseTaskConfig
implements Serializable {
    int subMaxTaskNum = 3;
    private boolean subFailAsStop = true;
    int subReTryNum = 5;
    int subReTryInterval = 2000;
    private DownloadConfig subConfig;

    DGroupConfig() {
        this.getSubConfig();
    }

    @Override
    int getType() {
        return 4;
    }

    @Override
    public DGroupConfig setMaxSpeed(int maxSpeed) {
        super.setMaxSpeed(maxSpeed);
        EventMsgUtil.getDefault().post(new DSpeedEvent(maxSpeed));
        return this;
    }

    public DownloadConfig getSubConfig() {
        this.subConfig = AriaConfig.getInstance().getDConfig();
        return this.subConfig;
    }

    @Override
    public DGroupConfig setMaxTaskNum(int maxTaskNum) {
        if (maxTaskNum <= 0) {
            ALog.e(this.TAG, "\u7ec4\u5408\u4efb\u52a1\u6700\u5927\u4efb\u52a1\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
            return this;
        }
        super.setMaxTaskNum(maxTaskNum);
        EventMsgUtil.getDefault().post(new DGMaxNumEvent(maxTaskNum));
        return this;
    }

    public int getSubMaxTaskNum() {
        return this.subMaxTaskNum;
    }

    public DGroupConfig setSubMaxTaskNum(int subMaxTaskNum) {
        this.subMaxTaskNum = subMaxTaskNum;
        this.save();
        return this;
    }

    public int getSubReTryNum() {
        return this.subReTryNum;
    }

    public DGroupConfig setSubReTryNum(int subReTryNum) {
        this.subReTryNum = subReTryNum;
        this.subConfig.reTryNum = subReTryNum;
        this.save();
        return this;
    }

    public int getSubReTryInterval() {
        return this.subReTryInterval;
    }

    public DGroupConfig setSubReTryInterval(int subReTryInterval) {
        this.subReTryInterval = subReTryInterval;
        this.subConfig.reTryInterval = subReTryInterval;
        this.save();
        return this;
    }

    public boolean isSubFailAsStop() {
        return this.subFailAsStop;
    }

    public DGroupConfig setSubFailAsStop(boolean subFailAsStop) {
        this.subFailAsStop = subFailAsStop;
        this.save();
        return this;
    }
}

