/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.config;

import android.text.TextUtils;
import com.arialyy.aria.core.config.AppConfig;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.config.DGroupConfig;
import com.arialyy.aria.core.config.DownloadConfig;
import com.arialyy.aria.core.config.UploadConfig;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReader
extends DefaultHandler {
    private final String TAG = CommonUtil.getClassName(this);
    private DownloadConfig mDownloadConfig;
    private UploadConfig mUploadConfig;
    private AppConfig mAppConfig;
    private DGroupConfig mDGroupConfig;
    private int mType;

    public XMLReader() {
        this.mDownloadConfig = Configuration.getInstance().downloadCfg;
        this.mUploadConfig = Configuration.getInstance().uploadCfg;
        this.mAppConfig = Configuration.getInstance().appCfg;
        this.mDGroupConfig = Configuration.getInstance().dGroupCfg;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        super.startElement(uri, localName, qName, attributes);
        switch (qName) {
            case "download": {
                this.mType = 1;
                break;
            }
            case "upload": {
                this.mType = 2;
                break;
            }
            case "app": {
                this.mType = 3;
                break;
            }
            case "dGroup": {
                this.mType = 4;
            }
        }
        if (this.mType == 1 || this.mType == 2 || this.mType == 4) {
            value = attributes.getValue("value");
            switch (qName) {
                case "threadNum": {
                    int threadNum;
                    int n = threadNum = this.checkInt(value) ? Integer.parseInt(value) : 3;
                    if (threadNum < 1) {
                        ALog.w(this.TAG, "\u4e0b\u8f7d\u7ebf\u7a0b\u6570\u4e0d\u80fd\u5c0f\u4e8e 1");
                        threadNum = 1;
                    }
                    this.setField("threadNum", threadNum, 1);
                    break;
                }
                case "maxTaskNum": {
                    int maxTaskNum;
                    int n = maxTaskNum = this.checkInt(value) ? Integer.parseInt(value) : 2;
                    if (maxTaskNum < 1) {
                        ALog.w(this.TAG, "\u4efb\u52a1\u961f\u5217\u6570\u4e0d\u80fd\u5c0f\u4e8e 1");
                        maxTaskNum = 2;
                    }
                    this.setField("maxTaskNum", maxTaskNum, this.mType);
                    break;
                }
                case "reTryNum": {
                    this.setField("reTryNum", this.checkInt(value) ? Integer.parseInt(value) : 0, this.mType);
                    break;
                }
                case "connectTimeOut": {
                    this.setField("connectTimeOut", this.checkInt(value) ? Integer.parseInt(value) : 5000, this.mType);
                    break;
                }
                case "iOTimeOut": {
                    int iOTimeOut;
                    int n = iOTimeOut = this.checkInt(value) ? Integer.parseInt(value) : 10000;
                    if (iOTimeOut < 10000) {
                        iOTimeOut = 10000;
                    }
                    this.setField("iOTimeOut", iOTimeOut, this.mType);
                    break;
                }
                case "reTryInterval": {
                    int reTryInterval;
                    int n = reTryInterval = this.checkInt(value) ? Integer.parseInt(value) : 2000;
                    if (reTryInterval < 2000) {
                        reTryInterval = 2000;
                    }
                    this.setField("reTryInterval", reTryInterval, this.mType);
                    break;
                }
                case "buffSize": {
                    int buffSize;
                    int n = buffSize = this.checkInt(value) ? Integer.parseInt(value) : 8192;
                    if (buffSize < 2048) {
                        buffSize = 2048;
                    }
                    this.setField("buffSize", buffSize, this.mType);
                    break;
                }
                case "ca": {
                    String caName = attributes.getValue("name");
                    String caPath = attributes.getValue("path");
                    this.setField("caName", caName, this.mType);
                    this.setField("caPath", caPath, this.mType);
                    break;
                }
                case "convertSpeed": {
                    this.setField("isConvertSpeed", !this.checkBoolean(value) || Boolean.parseBoolean(value), this.mType);
                    break;
                }
                case "maxSpeed": {
                    int maxSpeed = this.checkInt(value) ? Integer.parseInt(value) : 0;
                    this.setField("maxSpeed", maxSpeed, this.mType);
                    break;
                }
                case "queueMod": {
                    String mod = "now";
                    if (!TextUtils.isEmpty((CharSequence)value) && (value.equalsIgnoreCase("now") || value.equalsIgnoreCase("wait"))) {
                        mod = value;
                    }
                    this.setField("queueMod", mod, this.mType);
                    break;
                }
                case "updateInterval": {
                    this.setField("updateInterval", this.checkLong(value) ? Long.parseLong(value) : 1000L, this.mType);
                    break;
                }
                case "useBlock": {
                    this.setField("useBlock", this.checkBoolean(value) ? Boolean.valueOf(value) : false, 1);
                    break;
                }
                case "subMaxTaskNum": {
                    int subMaxTaskNum = this.checkInt(value) ? Integer.parseInt(value) : 3;
                    this.setField("subMaxTaskNum", subMaxTaskNum, 4);
                    break;
                }
                case "subFailAsStop": {
                    this.setField("subFailAsStop", this.checkBoolean(value) ? Boolean.valueOf(value) : false, 4);
                    break;
                }
                case "subReTryNum": {
                    int subReTryNum = this.checkInt(value) ? Integer.parseInt(value) : 5;
                    this.setField("subReTryNum", subReTryNum, 4);
                    break;
                }
                case "subReTryInterval": {
                    int subReTryInterval = this.checkInt(value) ? Integer.parseInt(value) : 2000;
                    this.setField("subReTryInterval", subReTryInterval, 4);
                    break;
                }
                case "useHeadRequest": {
                    boolean useHeadRequest = this.checkBoolean(value) ? Boolean.valueOf(value) : false;
                    this.setField("useHeadRequest", useHeadRequest, 1);
                }
            }
        } else if (this.mType == 3) {
            value = attributes.getValue("value");
            switch (qName) {
                case "useAriaCrashHandler": {
                    this.setField("useAriaCrashHandler", this.checkBoolean(value) ? Boolean.valueOf(value) : true, 3);
                    break;
                }
                case "logLevel": {
                    int level;
                    int n = level = this.checkInt(value) ? Integer.parseInt(value) : 2;
                    if (level < 2 || level > 8) {
                        ALog.w(this.TAG, "level\u3010" + level + "\u3011\u9519\u8bef");
                        level = 2;
                    }
                    this.setField("logLevel", level, 3);
                    break;
                }
                case "netCheck": {
                    this.setField("netCheck", this.checkBoolean(value) ? Boolean.valueOf(value) : false, 3);
                    break;
                }
                case "useBroadcast": {
                    this.setField("useBroadcast", this.checkBoolean(value) ? Boolean.valueOf(value) : false, 3);
                    break;
                }
                case "notNetRetry": {
                    this.setField("notNetRetry", this.checkBoolean(value) ? Boolean.valueOf(value) : false, 3);
                }
            }
        }
    }

    private void setField(String key, Object value, int type) {
        if (type == 1) {
            this.setField(DownloadConfig.class, this.mDownloadConfig, key, value);
        } else if (type == 2) {
            this.setField(UploadConfig.class, this.mUploadConfig, key, value);
        } else if (type == 3) {
            this.setField(AppConfig.class, this.mAppConfig, key, value);
        } else if (type == 4) {
            this.setField(DGroupConfig.class, this.mDGroupConfig, key, value);
        }
    }

    private void setField(Class clazz, Object target, String key, Object value) {
        Field field = CommonUtil.getField(clazz, key);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean checkInt(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        try {
            int l = Integer.parseInt(value);
            return l >= 0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkLong(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        try {
            Long l = Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkBoolean(String value) {
        return !TextUtils.isEmpty((CharSequence)value) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.mDownloadConfig.save();
        this.mUploadConfig.save();
        this.mAppConfig.save();
        this.mDGroupConfig.save();
    }
}

