/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.annotation.Ignore;
import com.arialyy.aria.orm.annotation.Unique;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;

public class DownloadEntity
extends AbsNormalEntity
implements Parcelable,
Cloneable {
    @Unique
    private String downloadPath;
    private String groupHash;
    private String md5Code;
    private String disposition;
    private String serverFileName;
    @Ignore
    private M3U8Entity m3U8Entity;
    public static final Parcelable.Creator<DownloadEntity> CREATOR = new Parcelable.Creator<DownloadEntity>(){

        public DownloadEntity createFromParcel(Parcel source) {
            return new DownloadEntity(source);
        }

        public DownloadEntity[] newArray(int size) {
            return new DownloadEntity[size];
        }
    };

    public M3U8Entity getM3U8Entity() {
        if (TextUtils.isEmpty((CharSequence)this.downloadPath)) {
            ALog.e("DownloadEntity", "\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\u4e3a\u7a7a\uff0c\u83b7\u53d6m3u8\u5b9e\u4f53\u4e4b\u524d\u9700\u8981\u8bbe\u7f6e\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84");
            return null;
        }
        if (this.m3U8Entity == null) {
            this.m3U8Entity = DbEntity.findFirst(M3U8Entity.class, "filePath=?", this.downloadPath);
        }
        return this.m3U8Entity;
    }

    @Override
    public String getKey() {
        return this.getUrl();
    }

    public String getRealUrl() {
        return this.isRedirect() ? this.getRedirectUrl() : this.getUrl();
    }

    @Override
    public int getTaskType() {
        M3U8Entity temp;
        int type = this.getUrl() == null ? 0 : (this.getUrl().startsWith("http") ? ((temp = this.getM3U8Entity()) == null ? 1 : (temp.isLive() ? 8 : 7)) : (this.getUrl().startsWith("ftp") ? 3 : (this.getUrl().startsWith("sftp") ? 12 : 0)));
        return type;
    }

    public DownloadEntity() {
    }

    public String getMd5Code() {
        return this.md5Code;
    }

    public void setMd5Code(String md5Code) {
        this.md5Code = md5Code;
    }

    public String getDisposition() {
        return TextUtils.isEmpty((CharSequence)this.disposition) ? "" : CommonUtil.decryptBASE64(this.disposition);
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getServerFileName() {
        return this.serverFileName;
    }

    public void setServerFileName(String serverFileName) {
        this.serverFileName = serverFileName;
    }

    public String getGroupHash() {
        return this.groupHash;
    }

    public void setGroupHash(String groupHash) {
        this.groupHash = groupHash;
    }

    @Override
    public String getFilePath() {
        return this.downloadPath;
    }

    public DownloadEntity setFilePath(String filePath) {
        this.downloadPath = filePath;
        return this;
    }

    public DownloadEntity clone() throws CloneNotSupportedException {
        return (DownloadEntity)super.clone();
    }

    public String toString() {
        return "DownloadEntity{downloadPath='" + this.downloadPath + '\'' + ", groupHash='" + this.groupHash + '\'' + ", fileName='" + this.getFileName() + '\'' + ", md5Code='" + this.md5Code + '\'' + ", disposition='" + this.disposition + '\'' + ", serverFileName='" + this.serverFileName + '\'' + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.downloadPath);
        dest.writeString(this.groupHash);
        dest.writeString(this.md5Code);
        dest.writeString(this.disposition);
        dest.writeString(this.serverFileName);
        dest.writeParcelable((Parcelable)this.m3U8Entity, flags);
    }

    protected DownloadEntity(Parcel in) {
        super(in);
        this.downloadPath = in.readString();
        this.groupHash = in.readString();
        this.md5Code = in.readString();
        this.disposition = in.readString();
        this.serverFileName = in.readString();
        this.m3U8Entity = (M3U8Entity)in.readParcelable(M3U8Entity.class.getClassLoader());
    }
}

