/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.group;

import android.os.Handler;
import android.os.Looper;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.group.AbsSubDLoadUtil;
import com.arialyy.aria.core.group.GroupRunState;
import com.arialyy.aria.core.group.SimpleSchedulers;
import com.arialyy.aria.core.group.SimpleSubQueue;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IDGroupListener;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoader;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbsGroupLoader
implements ILoaderVisitor,
ILoader {
    protected final String TAG = CommonUtil.getClassName(this.getClass());
    private long mCurrentLocation = 0L;
    private IDGroupListener mListener;
    private ScheduledThreadPoolExecutor mTimer;
    private long mUpdateInterval;
    private boolean isStop = false;
    private boolean isCancel = false;
    private Handler mScheduler;
    private SimpleSubQueue mSubQueue = SimpleSubQueue.newInstance();
    private Map<String, AbsSubDLoadUtil> mExeLoader = new WeakHashMap<String, AbsSubDLoadUtil>();
    private Map<String, DTaskWrapper> mCache = new WeakHashMap<String, DTaskWrapper>();
    private DGTaskWrapper mGTWrapper;
    private GroupRunState mState;
    protected IInfoTask mInfoTask;

    protected AbsGroupLoader(AbsTaskWrapper groupWrapper, IEventListener listener) {
        this.mListener = (IDGroupListener)listener;
        this.mGTWrapper = (DGTaskWrapper)groupWrapper;
        this.mUpdateInterval = Configuration.getInstance().downloadCfg.getUpdateInterval();
    }

    protected abstract void handlerTask(Looper var1);

    protected abstract AbsSubDLoadUtil createSubLoader(DTaskWrapper var1, boolean var2);

    protected IDGroupListener getListener() {
        return this.mListener;
    }

    protected DGTaskWrapper getWrapper() {
        return this.mGTWrapper;
    }

    protected GroupRunState getState() {
        return this.mState;
    }

    public Handler getScheduler() {
        return this.mScheduler;
    }

    private void initState(Looper looper) {
        this.mState = new GroupRunState(this.getWrapper().getKey(), this.mListener, this.mSubQueue);
        for (DTaskWrapper wrapper : this.mGTWrapper.getSubTaskWrapper()) {
            long fileLen = this.checkFileExists(((DownloadEntity)wrapper.getEntity()).getFilePath());
            if (((DownloadEntity)wrapper.getEntity()).getState() == 1 && fileLen > 0L && fileLen == ((DownloadEntity)wrapper.getEntity()).getFileSize()) {
                this.mCurrentLocation += ((DownloadEntity)wrapper.getEntity()).getFileSize();
                continue;
            }
            if (fileLen <= 0L) {
                ((DownloadEntity)wrapper.getEntity()).setCurrentProgress(0L);
            }
            ((DownloadEntity)wrapper.getEntity()).setState(6);
            this.mCache.put(wrapper.getKey(), wrapper);
            this.mCurrentLocation += ((DownloadEntity)wrapper.getEntity()).getCurrentProgress();
        }
        if (this.getWrapper().getSubTaskWrapper().size() != this.mState.getCompleteNum()) {
            this.getWrapper().setState(6);
        }
        this.mState.updateProgress(this.mCurrentLocation);
        this.mScheduler = new Handler(looper, (Handler.Callback)SimpleSchedulers.newInstance(this.mState, this.mGTWrapper.getKey()));
    }

    private long checkFileExists(String filePath) {
        File temp = new File(filePath);
        if (temp.exists()) {
            return temp.length();
        }
        File block = new File(String.format("%s.%s.part", filePath, 0));
        if (block.exists()) {
            return block.length();
        }
        return -1L;
    }

    @Override
    public String getKey() {
        return this.mGTWrapper.getKey();
    }

    void startSubTask(String url) {
        AbsSubDLoadUtil d;
        if (!this.checkSubTask(url, "\u5f00\u59cb")) {
            return;
        }
        if (!this.mState.isRunning.get()) {
            this.startTimer();
        }
        if ((d = this.getDownloader(url, false)) != null && !d.isRunning()) {
            this.mSubQueue.startTask(d);
        }
    }

    void stopSubTask(String url) {
        if (!this.checkSubTask(url, "\u505c\u6b62")) {
            return;
        }
        AbsSubDLoadUtil d = this.getDownloader(url, false);
        if (d != null && d.isRunning()) {
            this.mSubQueue.stopTask(d);
        }
    }

    private boolean checkSubTask(String url, String type) {
        DTaskWrapper wrapper = this.mCache.get(url);
        if (wrapper != null) {
            if (wrapper.getState() == 1) {
                ALog.w(this.TAG, "\u4efb\u52a1\u3010" + url + "\u3011\u5df2\u5b8c\u6210\uff0c" + type + "\u5931\u8d25");
                return false;
            }
        } else {
            ALog.w(this.TAG, "\u4efb\u52a1\u7ec4\u4e2d\u6ca1\u6709\u8be5\u4efb\u52a1\u3010" + url + "\u3011\uff0c" + type + "\u5931\u8d25");
            return false;
        }
        return true;
    }

    private AbsSubDLoadUtil getDownloader(String url, boolean needGetFileInfo) {
        AbsSubDLoadUtil d = this.mExeLoader.get(url);
        if (d == null) {
            return this.createSubLoader(this.mCache.get(url), needGetFileInfo);
        }
        return d;
    }

    @Override
    public boolean isRunning() {
        return this.mState != null && this.mState.isRunning.get();
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        if (this.mInfoTask != null) {
            this.mInfoTask.cancel();
        }
        this.closeTimer();
        this.mSubQueue.removeAllTask();
        this.mListener.onCancel();
    }

    @Override
    public void stop() {
        if (this.mInfoTask != null) {
            this.mInfoTask.stop();
        }
        this.isStop = true;
        if (this.mSubQueue.getExecSize() == 0) {
            this.mListener.onStop(((DownloadGroupEntity)this.mGTWrapper.getEntity()).getCurrentProgress());
        } else {
            this.mSubQueue.stopAllTask();
        }
        this.closeTimer();
    }

    @Override
    public void run() {
        this.checkComponent();
        if (this.isStop || this.isCancel) {
            this.closeTimer();
            return;
        }
        this.startRunningFlow();
    }

    private void startRunningFlow() {
        this.closeTimer();
        Looper.prepare();
        Looper looper = Looper.myLooper();
        if (looper == Looper.getMainLooper()) {
            throw new IllegalThreadStateException("\u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u7a0b\u5e8f\u4e2d\u8c03\u7528Loader");
        }
        this.initState(looper);
        this.getState().setSubSize(this.getWrapper().getSubTaskWrapper().size());
        if (this.getState().getCompleteNum() != 0 && this.getState().getCompleteNum() == this.getState().getSubSize()) {
            this.mListener.onComplete();
            return;
        }
        this.startTimer();
        this.handlerTask(looper);
        Looper.loop();
    }

    protected void onPostStart() {
        if (this.isBreak()) {
            return;
        }
        this.getListener().onPostPre(((DownloadGroupEntity)this.getWrapper().getEntity()).getFileSize());
        if (((DownloadGroupEntity)this.getWrapper().getEntity()).getFileSize() > 0L) {
            this.getListener().onResume(((DownloadGroupEntity)this.getWrapper().getEntity()).getCurrentProgress());
        } else {
            this.getListener().onStart(((DownloadGroupEntity)this.getWrapper().getEntity()).getCurrentProgress());
        }
    }

    private synchronized void startTimer() {
        this.mState.isRunning.set(true);
        this.mTimer = new ScheduledThreadPoolExecutor(1);
        this.mTimer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (!((AbsGroupLoader)AbsGroupLoader.this).mState.isRunning.get()) {
                    AbsGroupLoader.this.closeTimer();
                } else if (AbsGroupLoader.this.mCurrentLocation >= 0L) {
                    long t = 0L;
                    for (DTaskWrapper te : AbsGroupLoader.this.mGTWrapper.getSubTaskWrapper()) {
                        if (te.getState() == 1) {
                            t += ((DownloadEntity)te.getEntity()).getFileSize();
                            continue;
                        }
                        t += ((DownloadEntity)te.getEntity()).getCurrentProgress();
                    }
                    AbsGroupLoader.this.mCurrentLocation = t;
                    AbsGroupLoader.this.mState.updateProgress(AbsGroupLoader.this.mCurrentLocation);
                    AbsGroupLoader.this.mListener.onProgress(t);
                }
            }
        }, 0L, this.mUpdateInterval, TimeUnit.MILLISECONDS);
    }

    protected void startSubLoader(AbsSubDLoadUtil loader) {
        this.mExeLoader.put(loader.getKey(), loader);
        this.mSubQueue.startTask(loader);
    }

    @Override
    public boolean isBreak() {
        if (this.isCancel || this.isStop) {
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u505c\u6b62\u6216\u53d6\u6d88\u4e86", this.mGTWrapper.getKey()));
            return true;
        }
        return false;
    }

    private synchronized void closeTimer() {
        if (this.mTimer != null && !this.mTimer.isShutdown()) {
            this.mTimer.shutdown();
        }
    }

    protected void fail(AriaException e, boolean needRetry) {
        this.closeTimer();
        this.getListener().onFail(needRetry, e);
    }

    @Override
    public long getCurrentProgress() {
        return this.mCurrentLocation;
    }

    @Override
    @Deprecated
    public void addComponent(IRecordHandler recordHandler) {
    }

    @Override
    @Deprecated
    public void addComponent(IThreadTaskBuilder builder) {
    }

    @Override
    @Deprecated
    public void addComponent(IThreadStateManager threadState) {
    }

    private void checkComponent() {
        if (this.mInfoTask == null) {
            throw new NullPointerException("\u6587\u4ef6\u4fe1\u606f\u7ec4\u4ef6\u4e3a\u7a7a");
        }
    }
}

