/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.group;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.group.AbsSubDLoadUtil;
import com.arialyy.aria.core.group.GroupRunState;
import com.arialyy.aria.core.group.SimpleSubQueue;
import com.arialyy.aria.core.group.SimpleSubRetryQueue;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.exception.ExceptionFactory;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.NetUtils;
import java.io.File;

final class SimpleSchedulers
implements Handler.Callback {
    private final String TAG = CommonUtil.getClassName(this);
    private SimpleSubQueue mQueue;
    private GroupRunState mGState;
    private String mKey;

    private SimpleSchedulers(GroupRunState state, String key) {
        this.mQueue = state.queue;
        this.mGState = state;
        this.mKey = key;
    }

    static SimpleSchedulers newInstance(GroupRunState state, String key) {
        return new SimpleSchedulers(state, key);
    }

    public boolean handleMessage(Message msg) {
        Bundle b = msg.getData();
        if (b == null) {
            ALog.w(this.TAG, "\u7ec4\u5408\u4efb\u52a1\u5b50\u4efb\u52a1\u8c03\u5ea6\u6570\u636e\u4e3a\u7a7a");
            return true;
        }
        String threadName = b.getString("DATA_THREAD_NAME");
        AbsSubDLoadUtil loaderUtil = this.mQueue.getLoaderUtil(threadName);
        if (loaderUtil == null) {
            ALog.e(this.TAG, String.format("\u5b50\u4efb\u52a1loader\u4e0d\u5b58\u5728\uff0cstate\uff1a%s\uff0ckey\uff1a%s", msg.what, threadName));
            return true;
        }
        long curLocation = b.getLong("DATA_THREAD_LOCATION", ((AbsEntity)loaderUtil.getLoader().getWrapper().getEntity()).getCurrentProgress());
        switch (msg.what) {
            case 5: {
                long range = (Long)msg.obj;
                this.mGState.listener.onSubRunning(loaderUtil.getEntity(), range);
                break;
            }
            case 7: {
                this.mGState.listener.onSubPre(loaderUtil.getEntity());
                this.mGState.updateCount(loaderUtil.getKey());
                break;
            }
            case 8: {
                this.mGState.listener.onSubStart(loaderUtil.getEntity());
                break;
            }
            case 1: {
                this.handleStop(loaderUtil, curLocation);
                ThreadTaskManager.getInstance().removeSingleTaskThread(this.mKey, threadName);
                break;
            }
            case 4: {
                this.handleComplete(loaderUtil);
                ThreadTaskManager.getInstance().removeSingleTaskThread(this.mKey, threadName);
                break;
            }
            case 2: {
                boolean needRetry = b.getBoolean("DATA_RETRY", false);
                this.handleFail(loaderUtil, needRetry);
                ThreadTaskManager.getInstance().removeSingleTaskThread(this.mKey, threadName);
            }
        }
        return true;
    }

    private synchronized void handleFail(AbsSubDLoadUtil loaderUtil, boolean needRetry) {
        Log.d((String)this.TAG, (String)String.format("handleFail, size = %s, completeNum = %s, failNum = %s, stopNum = %s", this.mGState.getSubSize(), this.mGState.getCompleteNum(), this.mGState.getFailNum(), this.mGState.getSubSize()));
        Configuration config = Configuration.getInstance();
        int num = config.dGroupCfg.getSubReTryNum();
        boolean isNotNetRetry = config.appCfg.isNotNetRetry();
        if (!needRetry || !NetUtils.isConnected(AriaConfig.getInstance().getAPP()) && !isNotNetRetry || loaderUtil.getLoader() == null || loaderUtil.getEntity().getFailNum() > num) {
            this.mQueue.removeTaskFromExecQ(loaderUtil);
            this.mGState.listener.onSubFail(loaderUtil.getEntity(), ExceptionFactory.getException(5, String.format("\u4efb\u52a1\u7ec4\u5b50\u4efb\u52a1\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0c\u4e0b\u8f7d\u5730\u5740\u3010%s\u3011", loaderUtil.getEntity().getFileName(), loaderUtil.getEntity().getUrl()), null));
            this.mGState.countFailNum(loaderUtil.getKey());
            if (this.mGState.getFailNum() == this.mGState.getSubSize() || this.mGState.getStopNum() + this.mGState.getFailNum() + this.mGState.getCompleteNum() == this.mGState.getSubSize()) {
                this.mGState.isRunning.set(false);
                if (this.mGState.getCompleteNum() > 0 && Configuration.getInstance().dGroupCfg.isSubFailAsStop()) {
                    ALog.e(this.TAG, String.format("\u4efb\u52a1\u7ec4\u3010%s\u3011\u505c\u6b62", this.mGState.getGroupHash()));
                    this.mGState.listener.onStop(this.mGState.getProgress());
                    return;
                }
                this.mGState.listener.onFail(false, ExceptionFactory.getException(5, String.format("\u4efb\u52a1\u7ec4\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25", this.mGState.getGroupHash()), null));
                return;
            }
            this.startNext();
            return;
        }
        SimpleSubRetryQueue.getInstance().offer(loaderUtil);
    }

    private synchronized void handleStop(AbsSubDLoadUtil loadUtil, long curLocation) {
        Log.d((String)this.TAG, (String)String.format("handleStop, size = %s, completeNum = %s, failNum = %s, stopNum = %s", this.mGState.getSubSize(), this.mGState.getCompleteNum(), this.mGState.getFailNum(), this.mGState.getSubSize()));
        this.mGState.listener.onSubStop(loadUtil.getEntity(), curLocation);
        this.mGState.countStopNum(loadUtil.getKey());
        if (this.mGState.getStopNum() == this.mGState.getSubSize() || this.mGState.getStopNum() + this.mGState.getCompleteNum() + this.mGState.getFailNum() + this.mQueue.getCacheSize() == this.mGState.getSubSize()) {
            this.mGState.isRunning.set(false);
            this.mGState.listener.onStop(this.mGState.getProgress());
            return;
        }
        this.startNext();
    }

    private synchronized void handleComplete(AbsSubDLoadUtil loader) {
        ALog.d(this.TAG, String.format("\u5b50\u4efb\u52a1\u3010%s\u3011\u5b8c\u6210", loader.getEntity().getFileName()));
        Log.d((String)this.TAG, (String)String.format("handleComplete, size = %s, completeNum = %s, failNum = %s, stopNum = %s", this.mGState.getSubSize(), this.mGState.getCompleteNum(), this.mGState.getFailNum(), this.mGState.getStopNum()));
        TaskRecord record = loader.getRecord();
        if (record != null && record.isBlock) {
            File partFile = new File(String.format("%s.%s.part", record.filePath, 0));
            partFile.renameTo(new File(record.filePath));
        }
        ThreadTaskManager.getInstance().removeTaskThread(loader.getKey());
        this.mGState.listener.onSubComplete(loader.getEntity());
        this.mQueue.removeTaskFromExecQ(loader);
        this.mGState.updateCompleteNum();
        if (this.mGState.getCompleteNum() + this.mGState.getFailNum() + this.mGState.getStopNum() == this.mGState.getSubSize()) {
            if (this.mGState.getStopNum() == 0 && this.mGState.getFailNum() == 0) {
                this.mGState.listener.onComplete();
            } else if (this.mGState.getStopNum() == 0 && !Configuration.getInstance().dGroupCfg.isSubFailAsStop()) {
                this.mGState.listener.onFail(false, ExceptionFactory.getException(5, String.format("\u4efb\u52a1\u7ec4\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25", this.mGState.getGroupHash()), null));
            } else {
                this.mGState.listener.onStop(this.mGState.getProgress());
            }
            this.mGState.isRunning.set(false);
            return;
        }
        this.startNext();
    }

    private void startNext() {
        if (this.mQueue.isStopAll()) {
            return;
        }
        AbsSubDLoadUtil next = this.mQueue.getNextTask();
        if (next != null) {
            ALog.d(this.TAG, String.format("\u542f\u52a8\u4efb\u52a1\uff1a%s", next.getEntity().getFileName()));
            this.mQueue.startTask(next);
            return;
        }
        ALog.i(this.TAG, "\u6ca1\u6709\u4e0b\u4e00\u5b50\u4efb\u52a1");
    }
}

